/*
 * Decompiled with CFR 0.152.
 */
package com.docmosis.template.population;

import com.docmosis.template.population.Cleanable;
import com.docmosis.template.population.DataProvider;
import com.docmosis.template.population.JSONDataProvider;
import com.docmosis.template.population.MutableDataProvider;
import com.docmosis.util.DMProperties;
import com.docmosis.util.FileUtilities;
import com.docmosis.util.logging.LogManager;
import com.docmosis.util.logging.Logger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.com.docmosis.JSONException;
import org.json.com.docmosis.JSONObject;

public class MemoryDataProvider
implements MutableDataProvider,
Cleanable,
Serializable {
    private static final Logger H = LogManager.getLogger(MemoryDataProvider.class);
    private static final boolean I = DMProperties.getBoolean("docmosis.data.provider.case.sensitive");
    private Map D;
    private Map G;
    private ArrayList F;
    private Map J;
    private Map E;

    @Override
    public String getString(String string) {
        String string2 = null;
        if (string == null) {
            return null;
        }
        string = MemoryDataProvider.getRealKey(string);
        if (this.D != null) {
            string2 = (String)this.D.get(string);
        }
        return string2;
    }

    @Override
    public boolean hasStringKey(String string) {
        if (string == null) {
            return false;
        }
        string = MemoryDataProvider.getRealKey(string);
        if (this.D == null) {
            return false;
        }
        return this.D.containsKey(string);
    }

    @Override
    public void setString(String string, String string2) {
        if (this.D == null) {
            this.D = new LinkedHashMap();
        }
        string = MemoryDataProvider.getRealKey(string);
        this.D.put(string, string2);
        if ("true".equalsIgnoreCase(string2) || "false".equalsIgnoreCase(string2)) {
            this.setBooleanInternal(string, Boolean.valueOf(string2));
        }
    }

    public Set getStringKeys() {
        Set set = null;
        if (this.D != null) {
            set = Collections.unmodifiableSet(this.D.keySet());
        }
        return set;
    }

    @Override
    public InputStream getImage(String string) {
        _A _A2;
        if (string == null) {
            return null;
        }
        string = MemoryDataProvider.getRealKey(string);
        InputStream inputStream = null;
        if (this.G != null && (_A2 = (_A)this.G.get(string)) != null && _A2.A() != null) {
            try {
                inputStream = this.createAndRegisterStream(_A2.A());
            }
            catch (FileNotFoundException fileNotFoundException) {
                String string2 = "Could not obtain image for key:" + string + " FileNotFoundException:" + _A2.A().getPath();
                H.error(string2, fileNotFoundException);
                throw new IllegalArgumentException(string2);
            }
        }
        return inputStream;
    }

    @Override
    public boolean hasImageKey(String string) {
        if (string == null) {
            return false;
        }
        string = MemoryDataProvider.getRealKey(string);
        if (this.G != null) {
            return this.G.containsKey(string);
        }
        return false;
    }

    @Override
    public void setImage(String string, File file) {
        String string2;
        Object v;
        if (this.G == null) {
            this.G = new LinkedHashMap();
        }
        if ((v = this.G.get(string2 = MemoryDataProvider.getRealKey(string))) instanceof _A) {
            MemoryDataProvider.cleanup((_A)this.G.remove(string2));
        }
        if (file == null) {
            this.G.put(string2, null);
        } else {
            this.G.put(string2, new _A(file, false));
        }
    }

    private InputStream createAndRegisterStream(File file) throws FileNotFoundException {
        FileInputStream fileInputStream = new FileInputStream(file);
        if (this.F == null) {
            this.F = new ArrayList();
        }
        this.F.add(fileInputStream);
        return fileInputStream;
    }

    @Override
    public void setImage(String string, InputStream inputStream) {
        File file = null;
        try {
            String string2;
            Object v;
            if (this.G == null) {
                this.G = new LinkedHashMap();
            }
            if ((v = this.G.get(string2 = MemoryDataProvider.getRealKey(string))) instanceof _A) {
                MemoryDataProvider.cleanup((_A)this.G.remove(string2));
            }
            if (inputStream != null) {
                file = FileUtilities.createTempFile("dmi", "img");
                FileUtilities.storeToFile(inputStream, file);
                this.G.put(string2, new _A(file, true));
            } else {
                this.G.put(string2, null);
            }
        }
        catch (IOException iOException) {
            if (file != null) {
                FileUtilities.delete(file);
            }
            String string3 = "Unable to add image with key:" + string + " IOException:" + iOException.getMessage();
            H.error(string3, iOException);
            throw new IllegalArgumentException(string3);
        }
    }

    public Set getImageKeys() {
        Set set = null;
        if (this.G != null) {
            set = Collections.unmodifiableSet(this.G.keySet());
        }
        return set;
    }

    @Override
    public boolean getBoolean(String string) {
        if (string == null) {
            return false;
        }
        Boolean bl = null;
        string = MemoryDataProvider.getRealKey(string);
        if (this.J != null) {
            bl = (Boolean)this.J.get(string);
        }
        return Boolean.TRUE.equals(bl);
    }

    @Override
    public boolean hasBooleanKey(String string) {
        if (string == null) {
            return false;
        }
        string = MemoryDataProvider.getRealKey(string);
        if (this.J != null) {
            return this.J.containsKey(string);
        }
        return false;
    }

    @Override
    public void setTrue(String string) {
        this.setBoolean(string, true);
    }

    @Override
    public void setFalse(String string) {
        this.setBoolean(string, false);
    }

    @Override
    public void setBoolean(String string, boolean bl) {
        string = MemoryDataProvider.getRealKey(string);
        this.setBooleanInternal(string, bl);
        this.setString(string, Boolean.toString(bl));
    }

    private void setBooleanInternal(String string, boolean bl) {
        if (this.J == null) {
            this.J = new LinkedHashMap();
        }
        this.J.put(string, bl ? Boolean.TRUE : Boolean.FALSE);
    }

    public Set getBooleanKeys() {
        Set set = null;
        if (this.J != null) {
            set = Collections.unmodifiableSet(this.J.keySet());
        }
        return set;
    }

    @Override
    public int getDataProviderCount(String string) {
        if (string == null) {
            return 0;
        }
        string = MemoryDataProvider.getRealKey(string);
        List list = null;
        if (this.E != null) {
            list = (List)this.E.get(string);
        }
        int n = 0;
        if (list != null) {
            n = list.size();
        }
        return n;
    }

    @Override
    public boolean hasDataProviderKey(String string) {
        if (string == null) {
            return false;
        }
        string = MemoryDataProvider.getRealKey(string);
        if (this.E != null) {
            return this.E.containsKey(string);
        }
        return false;
    }

    @Override
    public DataProvider getDataProvider(String string, int n) {
        if (string == null) {
            return null;
        }
        string = MemoryDataProvider.getRealKey(string);
        List list = null;
        if (this.E != null && n > -1) {
            list = (List)this.E.get(string);
        }
        DataProvider dataProvider = null;
        if (list != null) {
            if (n < list.size()) {
                dataProvider = (DataProvider)list.get(n);
            } else if (H.isTraceEnabled()) {
                H.trace("Reference an index that doesn't exist for key: " + string + "[" + n + "]");
            }
        } else if (H.isTraceEnabled()) {
            H.trace("Referencing a key that doesn't exist: " + string);
        }
        return dataProvider;
    }

    @Override
    public void addDataProvider(String string, DataProvider dataProvider) {
        ArrayList<DataProvider> arrayList;
        if (this.E == null) {
            this.E = new LinkedHashMap();
        }
        if ((arrayList = (ArrayList<DataProvider>)this.E.get(MemoryDataProvider.getRealKey(string))) == null) {
            arrayList = new ArrayList<DataProvider>();
            arrayList.add(dataProvider);
            this.E.put(MemoryDataProvider.getRealKey(string), arrayList);
        } else {
            arrayList.add(dataProvider);
        }
    }

    public Set getDataProviderKeys() {
        Set set = null;
        if (this.E != null) {
            set = Collections.unmodifiableSet(this.E.keySet());
        }
        return set;
    }

    void removeDataProvider(String string, int n) {
        List list;
        if (this.E != null && (list = (List)this.E.get(MemoryDataProvider.getRealKey(string))) != null) {
            list.remove(n);
            if (list.isEmpty()) {
                this.E.remove(MemoryDataProvider.getRealKey(string));
            }
        }
    }

    protected static String getRealKey(String string) {
        if (I) {
            return string;
        }
        return string.toLowerCase();
    }

    boolean isEmpty() {
        Object object;
        if (this.D != null) {
            for (String string : this.D.keySet()) {
                object = (String)this.D.get(string);
                if (object == null) continue;
                return false;
            }
        }
        if (this.J != null) {
            for (String string : this.J.keySet()) {
                object = (Boolean)this.J.get(string);
                if (object == null) continue;
                return false;
            }
        }
        if (this.G != null) {
            for (String string : this.G.keySet()) {
                object = (_A)this.G.get(string);
                if (object == null) continue;
                return false;
            }
        }
        if (this.E != null) {
            for (String string : this.E.keySet()) {
                object = (List)this.E.get(string);
                if (object.isEmpty()) continue;
                return false;
            }
        }
        return true;
    }

    public String toString() {
        return this.toDebugString();
    }

    public String toDebugString() {
        return this.toDebugString(0);
    }

    protected String toDebugString(int n) {
        return this.toDebugString(n, true);
    }

    protected String toDebugString(int n, boolean bl) {
        Object object;
        Object object2;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("   ");
        for (int i = 0; i < n; ++i) {
            stringBuffer.append("  ");
        }
        String string = stringBuffer.toString();
        StringBuffer stringBuffer2 = new StringBuffer();
        if (n == 0) {
            stringBuffer2.append("--- MemoryDataProvider ---\n");
        }
        if (this.D != null) {
            for (String string2 : this.D.keySet()) {
                object2 = (String)this.D.get(string2);
                stringBuffer2.append(string);
                stringBuffer2.append("(String) ");
                stringBuffer2.append("".equals(string2) ? "\"\"" : string2);
                stringBuffer2.append(": ");
                if (object2 == null) {
                    stringBuffer2.append("null");
                } else {
                    stringBuffer2.append((String)object2);
                }
                stringBuffer2.append('\n');
            }
        }
        if (this.J != null) {
            for (String string2 : this.J.keySet()) {
                object2 = (Boolean)this.J.get(string2);
                stringBuffer2.append(string);
                stringBuffer2.append("(Boolean) ");
                stringBuffer2.append("".equals(string2) ? "\"\"" : string2);
                stringBuffer2.append(": ");
                if (object2 == null) {
                    stringBuffer2.append("null");
                } else {
                    stringBuffer2.append(object2);
                }
                stringBuffer2.append("\n");
            }
        }
        if (this.G != null) {
            Iterator iterator = this.G.keySet().iterator();
            object2 = null;
            while (iterator.hasNext()) {
                String string2;
                string2 = (String)iterator.next();
                object = (_A)this.G.get(string2);
                if (object != null && ((_A)object).A() != null) {
                    object2 = ((_A)object).A();
                }
                stringBuffer2.append(string);
                stringBuffer2.append("(File) ");
                stringBuffer2.append("".equals(string2) ? "\"\"" : string2);
                stringBuffer2.append(": ");
                if (object2 == null) {
                    stringBuffer2.append("null");
                } else {
                    stringBuffer2.append(((File)object2).getPath());
                }
                stringBuffer2.append("\n");
            }
        }
        if (this.E != null) {
            for (String string2 : this.E.keySet()) {
                object2 = (List)this.E.get(string2);
                if (object2 == null || object2.isEmpty()) {
                    stringBuffer2.append(string);
                    stringBuffer2.append("(DataProvider) ");
                    stringBuffer2.append("".equals(string2) ? "\"\"" : string2);
                    stringBuffer2.append("[0]: \n");
                    stringBuffer2.append("<none>");
                    continue;
                }
                for (int i = 0; i < object2.size(); ++i) {
                    stringBuffer2.append(string);
                    stringBuffer2.append("(DataProvider) ");
                    stringBuffer2.append("".equals(string2) ? "\"\"" : string2);
                    stringBuffer2.append('[').append(i).append(']');
                    stringBuffer2.append(": \n");
                    object = (MemoryDataProvider)object2.get(i);
                    stringBuffer2.append(((MemoryDataProvider)object).toDebugString(n + 1, bl));
                }
            }
        }
        return stringBuffer2.toString();
    }

    protected void finalize() throws Throwable {
        this.cleanup(false);
        super.finalize();
    }

    @Override
    public void cleanup() {
        this.cleanup(true);
    }

    private static void cleanup(_A _A2) {
        if (_A2 != null && _A2.A) {
            FileUtilities.delete(_A2.A());
        }
    }

    private void cleanup(boolean bl) {
        if (this.F != null) {
            int n = this.F.size();
            for (int i = 0; i < n; ++i) {
                FileUtilities.close((InputStream)this.F.get(i));
            }
            this.F = null;
        }
        if (this.G != null) {
            for (_A _A2 : this.G.values()) {
                MemoryDataProvider.cleanup(_A2);
            }
        }
        this.G = null;
        this.D = null;
        this.J = null;
        if (this.E != null) {
            if (bl) {
                for (List list : this.E.values()) {
                    int n = list.size();
                    for (int i = 0; i < n; ++i) {
                        DataProvider dataProvider = (DataProvider)list.get(i);
                        if (!(dataProvider instanceof Cleanable)) continue;
                        try {
                            ((Cleanable)((Object)dataProvider)).cleanup();
                            continue;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            }
            this.E = null;
        }
    }

    @Override
    public String toStringPretty() {
        try {
            String string = JSONDataProvider.toJSONString(this);
            JSONObject jSONObject = new JSONObject(string);
            return jSONObject.toString(2);
        }
        catch (JSONException jSONException) {
            H.error("Cannot fetch json data", jSONException);
            return null;
        }
    }

    private static class _A {
        private final File B;
        private final boolean A;

        public _A(File file, boolean bl) {
            this.B = file;
            this.A = bl;
        }

        public File A() {
            return this.B;
        }
    }
}

