/*
 * Decompiled with CFR 0.152.
 */
package com.docmosis.template.population;

import com.docmosis.template.population.DataProvider;
import com.docmosis.template.population.DataProviderBuilder;
import com.docmosis.template.population.JSONDataProvider;
import com.docmosis.template.population.MemoryDataProvider;
import com.docmosis.template.population.StringInterceptor;
import java.util.Iterator;
import java.util.Set;
import org.json.com.docmosis.JSONArray;
import org.json.com.docmosis.JSONException;
import org.json.com.docmosis.JSONObject;
import org.json.com.docmosis.JSONStringer;

class JsonBuilder {
    private static final String A = "list";

    JsonBuilder() {
    }

    static void addElementsToJSONStringer(MemoryDataProvider memoryDataProvider, JSONStringer jSONStringer) throws JSONException {
        String string;
        Object object;
        Object object2;
        Set set = memoryDataProvider.getStringKeys();
        if (set != null) {
            object2 = set.iterator();
            while (object2.hasNext()) {
                object = (String)object2.next();
                string = memoryDataProvider.getString((String)object);
                jSONStringer.key((String)object);
                jSONStringer.value(string);
            }
        }
        if ((object2 = memoryDataProvider.getDataProviderKeys()) != null) {
            object = object2.iterator();
            while (object.hasNext()) {
                string = (String)object.next();
                jSONStringer.key(string);
                int n = memoryDataProvider.getDataProviderCount(string);
                if (n > 1) {
                    jSONStringer.array();
                }
                for (int i = 0; i < n; ++i) {
                    jSONStringer.object();
                    JsonBuilder.addElementsToJSONStringer((MemoryDataProvider)memoryDataProvider.getDataProvider(string, i), jSONStringer);
                    jSONStringer.endObject();
                }
                if (n <= 1) continue;
                jSONStringer.endArray();
            }
        }
    }

    static JSONDataProvider buildFromJSONString(String string, JSONDataProvider jSONDataProvider, StringInterceptor[] stringInterceptorArray) throws JSONException {
        if (string.startsWith("{")) {
            JSONObject jSONObject = new JSONObject(string);
            Iterator iterator = jSONObject.keys();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                Object object = jSONObject.get(string2);
                JsonBuilder.addFromObject(string2, object, jSONDataProvider, stringInterceptorArray);
            }
        } else if (string.startsWith("[")) {
            JSONArray jSONArray = new JSONArray(string);
            JsonBuilder.addFromObject(A, jSONArray, jSONDataProvider, stringInterceptorArray);
        } else {
            throw new JSONException("Unexpected first character in JSON data.  Expecting \"[\" or \"{\".");
        }
        return jSONDataProvider;
    }

    private static JSONDataProvider addFromObject(String string, Object object, JSONDataProvider jSONDataProvider, StringInterceptor[] stringInterceptorArray) throws JSONException {
        if (object instanceof JSONObject) {
            JSONObject jSONObject = (JSONObject)object;
            Iterator iterator = jSONObject.keys();
            JSONDataProvider jSONDataProvider2 = new JSONDataProvider();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                Object object2 = jSONObject.get(string2);
                JsonBuilder.addFromObject(string2, object2, jSONDataProvider2, stringInterceptorArray);
            }
            jSONDataProvider.addDataProvider(string, jSONDataProvider2);
        } else if (object instanceof JSONArray) {
            JSONArray jSONArray = (JSONArray)object;
            for (int i = 0; i < jSONArray.length(); ++i) {
                Object object3;
                Object object4 = jSONArray.get(i);
                if (object4 instanceof JSONObject) {
                    JsonBuilder.addFromObject(string, object4, jSONDataProvider, stringInterceptorArray);
                    continue;
                }
                if (object4 instanceof JSONArray) {
                    object3 = new JSONDataProvider();
                    JsonBuilder.addFromObject("", object4, (JSONDataProvider)object3, stringInterceptorArray);
                    jSONDataProvider.addDataProvider(string, (DataProvider)object3);
                    continue;
                }
                object3 = new JSONObject();
                ((JSONObject)object3).accumulate("", object4);
                JsonBuilder.addFromObject(string, object3, jSONDataProvider, stringInterceptorArray);
            }
        } else if (JSONObject.NULL.equals(object)) {
            jSONDataProvider.setString(string, null);
        } else {
            DataProviderBuilder.addStringCheckInterceptors(jSONDataProvider, string, object.toString(), stringInterceptorArray);
        }
        return jSONDataProvider;
    }
}

