/*
 * Decompiled with CFR 0.152.
 */
package com.docmosis.template.population;

import com.docmosis.template.population.DataProviderGrouping;
import com.docmosis.template.population.DataProviderGroupingException;
import com.docmosis.template.population.Discriminator;
import com.docmosis.template.population.MemoryDataProvider;
import com.docmosis.template.population.MutableDataProvider;
import com.docmosis.template.population.NoSuchColumnNameException;
import com.docmosis.template.population.SQLDataItem;
import com.docmosis.template.population.SQLDataProvider;
import com.docmosis.util.DMProperties;
import com.docmosis.util.Equivalence;
import com.docmosis.util.SqlUtilities;
import com.docmosis.util.logging.LogManager;
import com.docmosis.util.logging.Logger;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class GroupedSQLDataProviderPopulator {
    private static final Logger C = LogManager.getLogger(GroupedSQLDataProviderPopulator.class);
    private static final boolean B = DMProperties.getBoolean("docmosis.data.provider.strict.mode");
    private static final boolean A = DMProperties.getBoolean("docmosis.data.provider.field.override.auto");
    private static final boolean D = DMProperties.getBoolean("docmosis.data.provider.field.override.error");

    private GroupedSQLDataProviderPopulator() {
    }

    public static void populateDataProvider(MutableDataProvider mutableDataProvider, ResultSet resultSet, DataProviderGrouping[] dataProviderGroupingArray) throws SQLException, DataProviderGroupingException, NoSuchColumnNameException {
        C.trace("GroupedSQLDataProviderPopulator.populateDataProvider():start");
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        if (resultSetMetaData.getColumnCount() == 0) {
            C.warn("Passed in a result set with no columns.");
            return;
        }
        int n = resultSetMetaData.getColumnCount();
        HashMap hashMap = new HashMap();
        Class<Object> clazz = null;
        for (int i = 0; i < n; ++i) {
            try {
                clazz = Class.forName(resultSetMetaData.getColumnClassName(i + 1));
            }
            catch (ClassNotFoundException classNotFoundException) {
                C.warn("Could not find class: " + resultSetMetaData.getColumnClassName(i + 1) + ". Defaulting to java.lang.Object.");
                clazz = Object.class;
            }
            hashMap.put(SQLDataProvider.getRealKey(resultSetMetaData.getColumnName(i + 1)), clazz);
        }
        HashMap hashMap2 = new HashMap();
        if (resultSet == null) {
            throw new DataProviderGroupingException("Result set must not be null");
        }
        GroupedSQLDataProviderPopulator.validate(dataProviderGroupingArray, resultSet.getMetaData());
        while (resultSet.next()) {
            C.trace("Found a record");
            GroupedSQLDataProviderPopulator.populateGrouping(mutableDataProvider, resultSet, hashMap, dataProviderGroupingArray, 0, hashMap2);
        }
        C.trace("GroupedSQLDataProviderPopulator.populateDataProvider():end");
    }

    private static void populateGrouping(MutableDataProvider mutableDataProvider, ResultSet resultSet, Map map, DataProviderGrouping[] dataProviderGroupingArray, int n, HashMap hashMap) throws SQLException, DataProviderGroupingException {
        C.trace("GroupedSQLDataProviderPopulator.populateGrouping():start: index=" + n);
        DataProviderGrouping dataProviderGrouping = dataProviderGroupingArray[n];
        SQLDataProvider sQLDataProvider = null;
        if (mutableDataProvider instanceof SQLDataProvider) {
            sQLDataProvider = GroupedSQLDataProviderPopulator.findMatch((SQLDataProvider)mutableDataProvider, dataProviderGrouping.getName(), resultSet, hashMap, map);
        }
        if (sQLDataProvider == null) {
            sQLDataProvider = new SQLDataProvider();
            hashMap.put(sQLDataProvider, dataProviderGrouping.getDiscriminator());
            mutableDataProvider.addDataProvider(dataProviderGrouping.getName(), sQLDataProvider);
        }
        String[] stringArray = dataProviderGrouping.getFields();
        for (int i = 0; i < stringArray.length; ++i) {
            Class clazz = (Class)map.get(SQLDataProvider.getRealKey(stringArray[i]));
            Object object = SqlUtilities.getSQLObject(resultSet, stringArray[i], clazz);
            clazz = object instanceof Date ? Date.class : clazz;
            SQLDataItem sQLDataItem = new SQLDataItem(clazz, object);
            if (!sQLDataProvider.hasDataItem(stringArray[i])) {
                sQLDataProvider.setDataItem(stringArray[i], sQLDataItem);
            } else if (!Equivalence.equivalentObjects(sQLDataProvider.getDataItem(stringArray[i]), sQLDataItem)) {
                if (A) {
                    sQLDataProvider.setDataItem(stringArray[i], sQLDataItem);
                    C.trace("Just clobbered a field: " + stringArray[i]);
                } else {
                    if (D) {
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append("Found a duplicate field of different value - Field: ");
                        stringBuffer.append(stringArray[i]);
                        stringBuffer.append(", Old Value: [");
                        stringBuffer.append(sQLDataProvider.getString(stringArray[i]) == null ? "<null>" : sQLDataProvider.getString(stringArray[i]));
                        stringBuffer.append("], New Value: [");
                        stringBuffer.append(sQLDataItem.item == null ? "<null>" : sQLDataItem.item.toString());
                        stringBuffer.append("], Discriminator: ");
                        stringBuffer.append(dataProviderGrouping.getDiscriminator());
                        stringBuffer.append(".  This field is not allowed to have a finer granularity than the discriminator in the same group.  A possible solution is to change the discriminator, perhaps adding this field to it.");
                        throw new DataProviderGroupingException(stringBuffer.toString());
                    }
                    C.trace("Found a duplicate field of different value: " + stringArray[i] + ".  Didn't clobber.");
                }
            }
            if (dataProviderGroupingArray.length <= n + 1) continue;
            GroupedSQLDataProviderPopulator.populateGrouping(sQLDataProvider, resultSet, map, dataProviderGroupingArray, n + 1, hashMap);
        }
        if (sQLDataProvider.isEmpty()) {
            ((MemoryDataProvider)mutableDataProvider).removeDataProvider(dataProviderGrouping.getName(), mutableDataProvider.getDataProviderCount(dataProviderGrouping.getName()) - 1);
        }
    }

    private static void validateGrouping(DataProviderGrouping[] dataProviderGroupingArray) throws DataProviderGroupingException {
        if (dataProviderGroupingArray == null || dataProviderGroupingArray.length == 0) {
            throw new DataProviderGroupingException("No groupings have been provided.");
        }
        for (int i = 0; i < dataProviderGroupingArray.length; ++i) {
            if (dataProviderGroupingArray[i] == null) {
                throw new DataProviderGroupingException("Found a null grouping at index: " + i);
            }
            if (dataProviderGroupingArray[i].getFields() != null && dataProviderGroupingArray[i].getFields().length != 0) continue;
            throw new DataProviderGroupingException("Found an empty grouping at index: " + i);
        }
    }

    private static void validate(DataProviderGrouping[] dataProviderGroupingArray, ResultSetMetaData resultSetMetaData) throws SQLException, DataProviderGroupingException, NoSuchColumnNameException {
        boolean bl = DMProperties.getBoolean("docmosis.data.provider.sql.caseSensitive");
        GroupedSQLDataProviderPopulator.validateGrouping(dataProviderGroupingArray);
        if (resultSetMetaData == null) {
            throw new DataProviderGroupingException("Result set provided a null meta data");
        }
        String[] stringArray = new String[resultSetMetaData.getColumnCount()];
        for (int i = 0; i < resultSetMetaData.getColumnCount(); ++i) {
            stringArray[i] = resultSetMetaData.getColumnName(i + 1);
        }
        String[] stringArray2 = null;
        boolean bl2 = false;
        for (int i = 0; i < dataProviderGroupingArray.length; ++i) {
            stringArray2 = dataProviderGroupingArray[i].getFields();
            for (int j = 0; j < stringArray2.length; ++j) {
                bl2 = false;
                for (int k = 0; k < stringArray.length && !bl2; ++k) {
                    if (bl) {
                        if (!Equivalence.equivalentObjects(stringArray2[j], stringArray[k])) continue;
                        bl2 = true;
                        continue;
                    }
                    if (!Equivalence.equivalentStringsIgnoreCase(stringArray2[j], stringArray[k])) continue;
                    bl2 = true;
                }
                if (bl2) continue;
                StringBuffer stringBuffer = new StringBuffer("Could not find column ");
                stringBuffer.append(stringArray2[j]);
                stringBuffer.append(" in the result set.");
                GroupedSQLDataProviderPopulator.fail(stringBuffer.toString());
            }
        }
    }

    private static void fail(String string) throws NoSuchColumnNameException {
        if (B) {
            throw new NoSuchColumnNameException(string);
        }
        C.warn(string);
    }

    private static SQLDataProvider findMatch(SQLDataProvider sQLDataProvider, String string, ResultSet resultSet, HashMap hashMap, Map map) throws SQLException {
        SQLDataProvider sQLDataProvider2 = null;
        for (int i = 0; i < sQLDataProvider.getDataProviderCount(SQLDataProvider.getRealKey(string)); ++i) {
            sQLDataProvider2 = (SQLDataProvider)sQLDataProvider.getDataProvider(SQLDataProvider.getRealKey(string), i);
            if (!GroupedSQLDataProviderPopulator.matchesKey(sQLDataProvider2, resultSet, hashMap, map)) continue;
            return sQLDataProvider2;
        }
        return null;
    }

    private static boolean matchesKey(SQLDataProvider sQLDataProvider, ResultSet resultSet, HashMap hashMap, Map map) throws SQLException {
        String[] stringArray;
        Discriminator discriminator = (Discriminator)hashMap.get(sQLDataProvider);
        if (discriminator != null && (stringArray = discriminator.getColumns()) != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                Class clazz = (Class)map.get(SQLDataProvider.getRealKey(stringArray[i]));
                if (Equivalence.equivalentObjects(sQLDataProvider.getDataItem((String)stringArray[i]).item, SqlUtilities.getSQLObject(resultSet, stringArray[i], clazz))) continue;
                return false;
            }
        }
        return true;
    }
}

