/*
 * Decompiled with CFR 0.152.
 */
package com.docmosis.template.population;

import com.docmosis.template.population.CompoundDataProvider;
import com.docmosis.template.population.DataProvider;
import com.docmosis.template.population.DataProviderCall;
import com.docmosis.template.population.DataProviderGrouping;
import com.docmosis.template.population.DataProviderGroupingException;
import com.docmosis.template.population.DataProviderKeyException;
import com.docmosis.template.population.DataProviderKeyParser;
import com.docmosis.template.population.GroupedSQLDataProviderPopulator;
import com.docmosis.template.population.JSONDataProvider;
import com.docmosis.template.population.JsonBuilder;
import com.docmosis.template.population.KeyedReflectiveDataProvider;
import com.docmosis.template.population.MemoryDataProvider;
import com.docmosis.template.population.MutableDataProvider;
import com.docmosis.template.population.NoSuchColumnNameException;
import com.docmosis.template.population.ReflectiveDataProvider;
import com.docmosis.template.population.SQLDataProvider;
import com.docmosis.template.population.SimpleSQLDataProviderPopulator;
import com.docmosis.template.population.StringInterceptor;
import com.docmosis.template.population.StringInterceptorException;
import com.docmosis.template.population.XMLDataProvider;
import com.docmosis.template.population.XMLNodeFilter;
import com.docmosis.template.population.data.Base64ImageStringInterceptor;
import com.docmosis.util.DMProperties;
import com.docmosis.util.FileUtilities;
import com.docmosis.util.logging.LogManager;
import com.docmosis.util.logging.Logger;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.json.com.docmosis.JSONException;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DataProviderBuilder {
    private static final Logger D = LogManager.getLogger(DataProviderBuilder.class);
    private static final boolean C = DMProperties.getBoolean("docmosis.populator.lookup.java.forgiving", true);
    private static final StringInterceptor E = Base64ImageStringInterceptor.getDefaultInstance();
    private DataProvider B;
    private StringInterceptor[] F;
    private boolean A = DMProperties.getBoolean("docmosis.data.provider.builder.base64Image.autoInstall", false);

    public DataProviderBuilder() {
        this.setAutoDecodeBase64Images(this.A);
    }

    public DataProviderBuilder(MutableDataProvider mutableDataProvider) {
        this.setAutoDecodeBase64Images(this.A);
        this.B = mutableDataProvider;
    }

    public void addStringInterceptor(StringInterceptor stringInterceptor) {
        this.addStringInterceptor(stringInterceptor, false);
    }

    public void addStringInterceptor(StringInterceptor stringInterceptor, boolean bl) {
        if (stringInterceptor == null) {
            throw new IllegalArgumentException("the interceptor cannot be null");
        }
        if (this.F == null) {
            this.F = new StringInterceptor[]{stringInterceptor};
        } else {
            StringInterceptor[] stringInterceptorArray = new StringInterceptor[this.F.length + 1];
            if (bl) {
                System.arraycopy(this.F, 0, stringInterceptorArray, 1, this.F.length);
                stringInterceptorArray[0] = stringInterceptor;
            } else {
                System.arraycopy(this.F, 0, stringInterceptorArray, 0, this.F.length);
                stringInterceptorArray[stringInterceptorArray.length - 1] = stringInterceptor;
            }
            this.F = stringInterceptorArray;
        }
    }

    public StringInterceptor[] getStringInterceptors() {
        return this.F;
    }

    public DataProviderBuilder addXMLDocument(Document document) throws DOMException {
        return this.addXMLDocument(document, null, true);
    }

    public DataProviderBuilder addXMLDocument(Document document, XMLNodeFilter xMLNodeFilter, boolean bl) throws DOMException {
        XMLDataProvider xMLDataProvider = new XMLDataProvider(document, xMLNodeFilter, bl, this.F);
        if (this.B == null) {
            this.B = xMLDataProvider;
        } else if (this.B instanceof CompoundDataProvider) {
            ((CompoundDataProvider)this.B).addDataProvider(xMLDataProvider);
        } else {
            CompoundDataProvider compoundDataProvider = new CompoundDataProvider();
            compoundDataProvider.addDataProvider(this.B);
            compoundDataProvider.addDataProvider(xMLDataProvider);
            this.B = compoundDataProvider;
        }
        return this;
    }

    public DataProviderBuilder addXMLFile(File file) throws IOException, SAXException, ParserConfigurationException, DOMException {
        return this.addXMLFile(file, null);
    }

    public DataProviderBuilder addXMLFile(File file, boolean bl) throws IOException, SAXException, ParserConfigurationException, DOMException {
        return this.addXMLFile(file, null, bl);
    }

    public DataProviderBuilder addXMLFile(File file, XMLNodeFilter xMLNodeFilter) throws IOException, SAXException, ParserConfigurationException, DOMException {
        return this.addXMLFile(file, xMLNodeFilter, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataProviderBuilder addXMLFile(File file, XMLNodeFilter xMLNodeFilter, boolean bl) throws IOException, SAXException, ParserConfigurationException, DOMException {
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            DataProviderBuilder dataProviderBuilder = this.addXMLStream(fileInputStream, xMLNodeFilter, bl);
            return dataProviderBuilder;
        }
        finally {
            FileUtilities.close(fileInputStream);
        }
    }

    public DataProviderBuilder addXMLString(String string) throws ParserConfigurationException, SAXException, IOException {
        return this.addXMLString(string, null);
    }

    public DataProviderBuilder addXMLString(String string, XMLNodeFilter xMLNodeFilter) throws ParserConfigurationException, SAXException, IOException {
        return this.addXMLString(string, xMLNodeFilter, true);
    }

    public DataProviderBuilder addXMLString(String string, XMLNodeFilter xMLNodeFilter, boolean bl) throws ParserConfigurationException, SAXException, IOException {
        return this.addXMLStream(new InputSource(new StringReader(string)), xMLNodeFilter, bl);
    }

    public DataProviderBuilder addXMLStream(InputStream inputStream, XMLNodeFilter xMLNodeFilter, boolean bl) throws ParserConfigurationException, SAXException, IOException {
        return this.addXMLStream(new InputSource(inputStream), xMLNodeFilter, bl);
    }

    public DataProviderBuilder addXMLStream(InputSource inputSource, XMLNodeFilter xMLNodeFilter, boolean bl) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        if (DMProperties.getBoolean("docmosis.data.xml.blockExternalEntities", true)) {
            documentBuilder.setEntityResolver(new _A());
        }
        Document document = documentBuilder.parse(inputSource);
        document.getDocumentElement().normalize();
        return this.addXMLDocument(document, xMLNodeFilter, bl);
    }

    public DataProviderBuilder addJSONString(String string) throws JSONException {
        if (string != null && !"".equals(string = string.trim())) {
            JSONDataProvider jSONDataProvider = JsonBuilder.buildFromJSONString(string, new JSONDataProvider(), this.F);
            if (this.B == null) {
                this.B = jSONDataProvider;
            } else if (this.B instanceof CompoundDataProvider) {
                ((CompoundDataProvider)this.B).addDataProvider(jSONDataProvider);
            } else {
                CompoundDataProvider compoundDataProvider = new CompoundDataProvider();
                compoundDataProvider.addDataProvider(this.B);
                compoundDataProvider.addDataProvider(jSONDataProvider);
                this.B = compoundDataProvider;
            }
        }
        return this;
    }

    public DataProviderBuilder addJSONFile(File file) throws IOException, JSONException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        FileUtilities.streamOut(file, byteArrayOutputStream);
        byteArrayOutputStream.close();
        String string = new String(byteArrayOutputStream.toByteArray(), "UTF-8");
        return this.addJSONString(string);
    }

    public DataProviderBuilder addJavaObject(Object object) {
        return this.addJavaObject(object, C);
    }

    public DataProviderBuilder addJavaObject(Object object, boolean bl) {
        if (this.B == null) {
            this.B = ReflectiveDataProvider.getInstance(object, bl);
        } else if (this.B instanceof CompoundDataProvider) {
            ((CompoundDataProvider)this.B).addDataProvider(ReflectiveDataProvider.getInstance(object, bl));
        } else {
            CompoundDataProvider compoundDataProvider = new CompoundDataProvider();
            compoundDataProvider.addDataProvider(this.B);
            compoundDataProvider.addDataProvider(ReflectiveDataProvider.getInstance(object, bl));
            this.B = compoundDataProvider;
        }
        return this;
    }

    public DataProviderBuilder addJavaObject(Object object, String string) {
        return this.addJavaObject(object, string, C);
    }

    public DataProviderBuilder addJavaObject(Object object, String string, boolean bl) {
        if (this.B == null) {
            this.B = new KeyedReflectiveDataProvider(string, object, bl);
        } else if (this.B instanceof CompoundDataProvider) {
            ((CompoundDataProvider)this.B).addDataProvider(new KeyedReflectiveDataProvider(string, object, bl));
        } else {
            CompoundDataProvider compoundDataProvider = new CompoundDataProvider();
            compoundDataProvider.addDataProvider(this.B);
            compoundDataProvider.addDataProvider(new KeyedReflectiveDataProvider(string, object, bl));
            this.B = compoundDataProvider;
        }
        return this;
    }

    public DataProviderBuilder addSQL(ResultSet resultSet, String string) throws SQLException {
        SimpleSQLDataProviderPopulator.populateDataProvider(this.getDataProviderForAdd(true), resultSet, string);
        return this;
    }

    public DataProviderBuilder addSQL(ResultSet resultSet, DataProviderGrouping[] dataProviderGroupingArray) throws NoSuchColumnNameException, SQLException, DataProviderGroupingException {
        GroupedSQLDataProviderPopulator.populateDataProvider(this.getDataProviderForAdd(true), resultSet, dataProviderGroupingArray);
        return this;
    }

    public DataProviderBuilder add(DataProvider dataProvider, String string) {
        this.getDataProviderForAdd(false).addDataProvider(string, dataProvider);
        return this;
    }

    public DataProviderBuilder add(DataProviderBuilder dataProviderBuilder, String string) {
        this.add(dataProviderBuilder.getDataProvider(), string);
        return this;
    }

    public DataProviderBuilder addAll(Map[] mapArray, String string) {
        for (int i = 0; i < mapArray.length; ++i) {
            DataProviderBuilder dataProviderBuilder = new DataProviderBuilder();
            dataProviderBuilder.addAll(mapArray[i]);
            this.add(dataProviderBuilder.getDataProvider(), string);
        }
        return this;
    }

    public DataProviderBuilder addAll(String[][][] stringArray, String string) {
        for (int i = 0; i < stringArray.length; ++i) {
            DataProviderBuilder dataProviderBuilder = new DataProviderBuilder();
            dataProviderBuilder.addAll(stringArray[i]);
            this.add(dataProviderBuilder.getDataProvider(), string);
        }
        return this;
    }

    public DataProviderBuilder addImage(String string, File file) {
        try {
            _B _B2 = DataProviderBuilder.createKeyNesting(string, this.getDataProviderForAdd(false));
            _B2.B.setImage(_B2.A, file);
        }
        catch (DataProviderKeyException dataProviderKeyException) {
            throw new IllegalArgumentException(dataProviderKeyException.getMessage());
        }
        return this;
    }

    public DataProviderBuilder addImage(String string, InputStream inputStream) {
        try {
            _B _B2 = DataProviderBuilder.createKeyNesting(string, this.getDataProviderForAdd(false));
            _B2.B.setImage(_B2.A, inputStream);
        }
        catch (DataProviderKeyException dataProviderKeyException) {
            throw new IllegalArgumentException(dataProviderKeyException.getMessage());
        }
        return this;
    }

    public DataProviderBuilder add(String string, String string2) {
        try {
            _B _B2 = DataProviderBuilder.createKeyNesting(string, this.getDataProviderForAdd(false));
            DataProviderBuilder.addStringCheckInterceptors(_B2.B, _B2.A, string2, this.F);
        }
        catch (DataProviderKeyException dataProviderKeyException) {
            throw new IllegalArgumentException(dataProviderKeyException.getMessage());
        }
        return this;
    }

    private static _B createKeyNesting(String string, MutableDataProvider mutableDataProvider) throws DataProviderKeyException {
        if (string == null) {
            throw new NullPointerException("key cannot be null");
        }
        MutableDataProvider mutableDataProvider2 = mutableDataProvider;
        String string2 = null;
        for (DataProviderCall dataProviderCall = DataProviderKeyParser.parse(string); dataProviderCall != null; dataProviderCall = dataProviderCall.getChild()) {
            if (dataProviderCall.getChild() != null) {
                if (mutableDataProvider2.getDataProvider(dataProviderCall.getElement(), dataProviderCall.getIndex()) == null) {
                    if (dataProviderCall.getIndex() != mutableDataProvider2.getDataProviderCount(dataProviderCall.getElement())) {
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append("Key: [").append(string).append("] is invalid. ");
                        stringBuffer.append("Expected index of ");
                        stringBuffer.append(mutableDataProvider2.getDataProviderCount(dataProviderCall.getElement()));
                        stringBuffer.append(" for element " + dataProviderCall.getElement());
                        stringBuffer.append(" but index was ");
                        stringBuffer.append(dataProviderCall.getIndex());
                        stringBuffer.append(".");
                        throw new DataProviderKeyException(stringBuffer.toString());
                    }
                    mutableDataProvider2.addDataProvider(dataProviderCall.getElement(), new MemoryDataProvider());
                }
                mutableDataProvider2 = (MemoryDataProvider)mutableDataProvider2.getDataProvider(dataProviderCall.getElement(), dataProviderCall.getIndex());
            }
            string2 = dataProviderCall.getElement();
        }
        return new _B(mutableDataProvider2, string2);
    }

    static void addStringCheckInterceptors(MutableDataProvider mutableDataProvider, String string, String string2, StringInterceptor[] stringInterceptorArray) {
        String string3;
        String string4 = string3 = string2 == null ? null : string2.trim();
        if ("[[true]]".equalsIgnoreCase(string3) || "[[false]]".equalsIgnoreCase(string3)) {
            mutableDataProvider.setBoolean(string, "[[true]]".equalsIgnoreCase(string3));
            mutableDataProvider.setString(string, string3);
        } else if (string3 != null && string3.startsWith("[image:")) {
            StringBuffer stringBuffer = new StringBuffer(string3.substring("[image:".length()));
            if (stringBuffer.charAt(stringBuffer.length() - 1) == ']') {
                stringBuffer.deleteCharAt(stringBuffer.length() - 1);
            }
            mutableDataProvider.setImage(string, new File(stringBuffer.toString()));
        } else {
            boolean bl = true;
            if (stringInterceptorArray != null) {
                for (int i = 0; i < stringInterceptorArray.length; ++i) {
                    try {
                        if (!stringInterceptorArray[i].process(string, string3, mutableDataProvider)) continue;
                        bl = false;
                        break;
                    }
                    catch (StringInterceptorException stringInterceptorException) {
                        D.error(stringInterceptorException);
                        throw new RuntimeException(stringInterceptorException);
                    }
                }
            }
            if (bl) {
                mutableDataProvider.setString(string, string2);
            }
        }
    }

    public DataProviderBuilder add(String[] stringArray) {
        if (stringArray == null) {
            throw new IllegalArgumentException("Key Value Pair is not allowed to be null");
        }
        if (stringArray.length != 2) {
            throw new IllegalArgumentException("Key Value Pair must be of length 2.  Length found: " + stringArray.length);
        }
        return this.add(stringArray[0], stringArray[1]);
    }

    public DataProviderBuilder addAll(String[][] stringArray) {
        if (stringArray != null && stringArray.length > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                this.add(stringArray[i]);
            }
        } else {
            D.warn("Passed in a null or empty grid of key value pairs.");
        }
        return this;
    }

    public DataProviderBuilder addAll(Map map) {
        if (map == null) {
            throw new NullPointerException("Map cannot be null");
        }
        for (Map.Entry entry : map.entrySet()) {
            this.add((String)entry.getKey(), (String)entry.getValue());
        }
        return this;
    }

    public DataProviderBuilder addFile(File file) throws IOException {
        return this.addFile(file, ',');
    }

    public DataProviderBuilder addFile(File file, char c) throws IOException {
        return this.addFile(file, c, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataProviderBuilder addFile(File file, char c, String string) throws IOException {
        if (file == null) {
            throw new NullPointerException("key pair file cannot be null");
        }
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = string == null ? new BufferedReader(new InputStreamReader(new FileInputStream(file))) : new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), string));
            String string2 = null;
            while ((string2 = bufferedReader.readLine()) != null) {
                if (string2.trim().length() <= 0 || string2.startsWith("#")) continue;
                String string3 = null;
                String string4 = null;
                int n = string2.indexOf(c);
                if (n == 0) {
                    if (string2.length() <= 1) continue;
                    string3 = string2.substring(1);
                } else if (n != -1) {
                    string3 = string2.substring(0, n);
                    if (n < string2.length() - 1) {
                        string4 = string2.substring(n + 1);
                    }
                } else {
                    string3 = string2;
                }
                if (string3 != null) {
                    string3 = string3.trim();
                }
                if (string4 != null && string4.indexOf("\\n") != -1) {
                    StringBuffer stringBuffer = new StringBuffer(string4);
                    int n2 = stringBuffer.indexOf("\\n");
                    while (n2 != -1) {
                        stringBuffer.replace(n2, n2 + 2, "\n");
                        n2 = stringBuffer.indexOf("\\n");
                    }
                    string4 = stringBuffer.toString();
                }
                this.add(string3, string4);
            }
        }
        catch (Throwable throwable) {
            FileUtilities.close(bufferedReader);
            throw throwable;
        }
        FileUtilities.close(bufferedReader);
        return this;
    }

    public DataProvider getDataProvider() {
        if (this.B == null) {
            this.getDataProviderForAdd(false);
        }
        return this.B;
    }

    private MutableDataProvider getDataProviderForAdd(boolean bl) {
        if (this.B == null) {
            this.B = bl ? new SQLDataProvider() : new MemoryDataProvider();
            return (MutableDataProvider)this.B;
        }
        if (this.B instanceof CompoundDataProvider) {
            DataProvider dataProvider = ((CompoundDataProvider)this.B).getLastDataProvider();
            if (bl) {
                if (!DataProviderBuilder.isSQLDP(this.B)) {
                    dataProvider = new SQLDataProvider();
                    ((CompoundDataProvider)this.B).addDataProvider(dataProvider);
                }
            } else if (!(dataProvider instanceof MutableDataProvider)) {
                dataProvider = new MemoryDataProvider();
                ((CompoundDataProvider)this.B).addDataProvider(dataProvider);
            }
            return (MutableDataProvider)dataProvider;
        }
        if (bl && DataProviderBuilder.isSQLDP(this.B)) {
            return (MutableDataProvider)this.B;
        }
        if (!bl && this.B instanceof MutableDataProvider) {
            return (MutableDataProvider)this.B;
        }
        CompoundDataProvider compoundDataProvider = new CompoundDataProvider();
        compoundDataProvider.addDataProvider(this.B);
        this.B = compoundDataProvider;
        MemoryDataProvider memoryDataProvider = bl ? new SQLDataProvider() : new MemoryDataProvider();
        ((CompoundDataProvider)this.B).addDataProvider(memoryDataProvider);
        return memoryDataProvider;
    }

    public void setAutoDecodeBase64Images(boolean bl) {
        this.A = bl;
        if (bl) {
            boolean bl2 = false;
            if (this.F != null) {
                for (int i = 0; i < this.F.length; ++i) {
                    if (this.F[i] != E) continue;
                    bl2 = true;
                    break;
                }
            }
            if (!bl2) {
                this.addStringInterceptor(E);
            }
        } else {
            int n;
            ArrayList<StringInterceptor> arrayList = new ArrayList<StringInterceptor>();
            if (this.F != null) {
                for (n = 0; n < this.F.length; ++n) {
                    if (this.F[n] == E) continue;
                    arrayList.add(this.F[n]);
                }
            }
            if (arrayList.size() == 0) {
                this.F = null;
            } else {
                int n2 = n = this.F == null ? 0 : this.F.length;
                if (arrayList.size() != n) {
                    this.F = new StringInterceptor[arrayList.size()];
                    arrayList.toArray(this.F);
                }
            }
        }
    }

    private static boolean isSQLDP(DataProvider dataProvider) {
        return dataProvider instanceof SQLDataProvider;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString()).append("\n");
        if (this.B == null) {
            stringBuffer.append("<empty>");
        } else {
            stringBuffer.append(this.B.toString());
        }
        return stringBuffer.toString();
    }

    private static class _A
    implements EntityResolver {
        private _A() {
        }

        @Override
        public InputSource resolveEntity(String string, String string2) {
            D.warn("XML external entity resolution ignored:[" + string + "],[" + string2 + "]");
            InputSource inputSource = new InputSource(new ByteArrayInputStream("".getBytes()));
            return inputSource;
        }
    }

    private static class _B {
        private final MutableDataProvider B;
        private final String A;

        public _B(MutableDataProvider mutableDataProvider, String string) {
            this.B = mutableDataProvider;
            this.A = string;
        }
    }
}

