/*
 * Decompiled with CFR 0.152.
 */
package com.docmosis.template.population;

import com.docmosis.template.population.DataProvider;
import com.docmosis.template.population.ReflectiveDataProvider;
import java.io.InputStream;
import java.io.Serializable;
import java.util.List;

public class CompoundDataProvider
implements DataProvider,
Serializable {
    private DataProvider[] R = null;

    public CompoundDataProvider addDataProvider(DataProvider dataProvider) {
        if (dataProvider == null) {
            throw new IllegalArgumentException("Cannot add a null DataProvider");
        }
        this.expand(1);
        this.R[this.R.length - 1] = dataProvider;
        return this;
    }

    public DataProvider getLastDataProvider() {
        if (this.R == null) {
            return null;
        }
        return this.R[this.R.length - 1];
    }

    public CompoundDataProvider addDataObject(Object object) {
        return this.addDataObject(object, true);
    }

    public CompoundDataProvider addDataObject(Object object, boolean bl) {
        if (object == null) {
            throw new IllegalArgumentException("Cannot add a null DataProvider");
        }
        this.expand(1);
        this.R[this.R.length - 1] = object instanceof DataProvider ? (DataProvider)object : ReflectiveDataProvider.getInstance(object, bl);
        return this;
    }

    public CompoundDataProvider addDataProviders(DataProvider[] dataProviderArray) {
        if (dataProviderArray == null) {
            throw new IllegalArgumentException("Cannot add a null DataProvider array");
        }
        this.expand(dataProviderArray.length);
        for (int i = 0; i < dataProviderArray.length; ++i) {
            if (dataProviderArray[i] == null) {
                throw new IllegalArgumentException("Cannot add a null DataProvider");
            }
            this.R[this.R.length - (dataProviderArray.length - i)] = dataProviderArray[i];
        }
        return this;
    }

    public CompoundDataProvider addDataProviders(List list) {
        if (list == null) {
            throw new IllegalArgumentException("Cannot add a null DataProvider List");
        }
        int n = list.size();
        this.expand(n);
        for (int i = 0; i < n; ++i) {
            Object e = list.get(i);
            if (e == null) {
                throw new IllegalArgumentException("Cannot add a null DataProvider");
            }
            this.R[this.R.length - (n - i)] = e instanceof DataProvider ? (DataProvider)e : ReflectiveDataProvider.getInstance(e);
        }
        return this;
    }

    private void expand(int n) {
        if (this.R == null) {
            this.R = new DataProvider[n];
        } else {
            DataProvider[] dataProviderArray = new DataProvider[this.R.length + n];
            System.arraycopy(this.R, 0, dataProviderArray, 0, this.R.length);
            this.R = dataProviderArray;
        }
    }

    @Override
    public boolean getBoolean(String string) {
        if (this.R != null) {
            for (int i = 0; i < this.R.length; ++i) {
                if (!this.R[i].hasBooleanKey(string)) continue;
                return this.R[i].getBoolean(string);
            }
        }
        return false;
    }

    @Override
    public DataProvider getDataProvider(String string, int n) {
        if (this.R != null) {
            for (int i = 0; i < this.R.length; ++i) {
                if (!this.R[i].hasDataProviderKey(string)) continue;
                return this.R[i].getDataProvider(string, n);
            }
        }
        return null;
    }

    @Override
    public int getDataProviderCount(String string) {
        if (this.R != null) {
            for (int i = 0; i < this.R.length; ++i) {
                if (!this.R[i].hasDataProviderKey(string)) continue;
                return this.R[i].getDataProviderCount(string);
            }
        }
        return 0;
    }

    @Override
    public InputStream getImage(String string) {
        if (this.R != null) {
            for (int i = 0; i < this.R.length; ++i) {
                if (!this.R[i].hasImageKey(string)) continue;
                return this.R[i].getImage(string);
            }
        }
        return null;
    }

    @Override
    public String getString(String string) {
        if (this.R != null) {
            for (int i = 0; i < this.R.length; ++i) {
                if (!this.R[i].hasStringKey(string)) continue;
                return this.R[i].getString(string);
            }
        }
        return null;
    }

    @Override
    public boolean hasBooleanKey(String string) {
        if (this.R != null) {
            for (int i = 0; i < this.R.length; ++i) {
                if (!this.R[i].hasBooleanKey(string)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean hasDataProviderKey(String string) {
        if (this.R != null) {
            for (int i = 0; i < this.R.length; ++i) {
                if (!this.R[i].hasDataProviderKey(string)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean hasImageKey(String string) {
        if (this.R != null) {
            for (int i = 0; i < this.R.length; ++i) {
                if (!this.R[i].hasImageKey(string)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean hasStringKey(String string) {
        if (this.R != null) {
            for (int i = 0; i < this.R.length; ++i) {
                if (!this.R[i].hasStringKey(string)) continue;
                return true;
            }
        }
        return false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString()).append('\n');
        if (this.R == null || this.R.length == 0) {
            stringBuffer.append("<empty>");
        } else {
            for (int i = 0; i < this.R.length; ++i) {
                stringBuffer.append(" DP: ").append(i).append("  ");
                stringBuffer.append(this.R[i].toString());
            }
        }
        return stringBuffer.toString();
    }

    @Override
    public String toStringPretty() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.R != null && this.R.length > 0) {
            for (int i = 0; i < this.R.length; ++i) {
                if (this.R[i] == null) continue;
                stringBuffer.append(this.R[i].toStringPretty());
                stringBuffer.append('\n');
            }
        }
        return stringBuffer.toString();
    }
}

