/*
 * Decompiled with CFR 0.152.
 */
package com.docmosis.template.analysis.util;

import com.docmosis.template.Template;
import com.docmosis.template.TemplateNotFoundException;
import com.docmosis.template.TemplateStoreException;
import com.docmosis.template.analysis.ImageAnalysis;
import com.docmosis.template.analysis.SimpleTemplateField;
import com.docmosis.template.analysis.SimpleTemplateRepeatableSection;
import com.docmosis.template.analysis.SimpleTemplateSection;
import com.docmosis.template.analysis.TemplateAnalysis;
import com.docmosis.template.analysis.TemplateField;
import com.docmosis.template.analysis.TemplateNamedSection;
import com.docmosis.template.analysis.TemplateSection;
import com.docmosis.template.analysis.TemplateTable;
import com.docmosis.template.analysis.TemplateXMLAdjustmentSection;
import com.docmosis.template.store.TemplateIdentifier;
import com.docmosis.template.store.TemplateStoreFactory;
import com.docmosis.util.MultiInputStreamReader;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.HashMap;

public class AnalysisDumper {
    private static final String G = "[before ]   ";
    private static final String B = "[content]   ";
    private static final String F = "[preamble]  ";
    private static final String E = "[postamble] ";
    private static final String A = "[adjust   ] ";
    private static final String C = "  ";
    private PrintStream D;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dumpTemplateWithIndexes(TemplateIdentifier templateIdentifier) throws TemplateNotFoundException, IOException, TemplateStoreException {
        Template template = TemplateStoreFactory.getStore().getTemplate(templateIdentifier);
        try {
            TemplateAnalysis templateAnalysis = template.getAnalysis();
            MultiInputStreamReader multiInputStreamReader = new MultiInputStreamReader(template.getInputStream());
            multiInputStreamReader.nextStream();
            System.out.println("content.xml\n============\n" + AnalysisDumper.extractTemplateContentXML(templateIdentifier) + "\n");
            AnalysisDumper.doIndexDump(templateAnalysis.getTemplateImages(), new InputStreamReader((InputStream)multiInputStreamReader, Charset.forName("UTF-8")), 0L, templateAnalysis.getSections(), "");
        }
        finally {
            template.cleanup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String extractTemplateContentXML(TemplateIdentifier templateIdentifier) throws IOException, TemplateNotFoundException, TemplateStoreException {
        Template template = TemplateStoreFactory.getStore().getTemplate(templateIdentifier);
        try {
            int n;
            MultiInputStreamReader multiInputStreamReader = new MultiInputStreamReader(template.getInputStream());
            multiInputStreamReader.nextStream();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray = new byte[8192];
            while ((n = multiInputStreamReader.read(byArray, 0, byArray.length)) != -1) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
            String string = byteArrayOutputStream.toString("UTF-8");
            multiInputStreamReader.close();
            String string2 = string;
            return string2;
        }
        finally {
            template.cleanup();
        }
    }

    public static void dumpTemplateWithIndexes(TemplateAnalysis templateAnalysis) throws IOException {
        AnalysisDumper.doIndexDump(templateAnalysis.getTemplateImages(), null, 0L, templateAnalysis.getSections(), "");
    }

    public static void dumpTemplateWithIndexes(TemplateAnalysis templateAnalysis, File file) throws IOException {
        AnalysisDumper.doIndexDump(templateAnalysis.getTemplateImages(), new BufferedReader(new FileReader(file)), 0L, templateAnalysis.getSections(), "");
    }

    private static long doIndexDump(ImageAnalysis imageAnalysis, Reader reader, long l, TemplateSection[] templateSectionArray, String string) throws IOException {
        System.out.println("ANALYSIS DUMP\n=============");
        if (imageAnalysis == null) {
            System.out.println("Images:<null>");
        } else {
            System.out.println("Images:");
            ImageAnalysis.ImageDetail[] imageDetailArray = imageAnalysis.getImages();
            for (int i = 0; i < imageDetailArray.length; ++i) {
                System.out.println(" " + i + " " + imageDetailArray[i].getWidth() + "x" + imageDetailArray[i].getHeight() + "x" + imageDetailArray[i].getDepth() + " memSize=" + imageDetailArray[i].memSize() + " " + imageDetailArray[i].getName());
            }
        }
        return AnalysisDumper.doIndexDump(reader, l, templateSectionArray, string);
    }

    private static long doIndexDump(Reader reader, long l, TemplateSection[] templateSectionArray, String string) throws IOException {
        if (templateSectionArray != null) {
            for (int i = 0; i < templateSectionArray.length; ++i) {
                int n;
                Object object;
                TemplateSection templateSection = templateSectionArray[i];
                String string2 = "";
                if (templateSection instanceof TemplateNamedSection) {
                    if (((TemplateNamedSection)templateSection).getSectionName() != null) {
                        string2 = " \"" + ((TemplateNamedSection)templateSection).getSectionName() + "\" ";
                        if ("".equals(((TemplateNamedSection)templateSection).getSectionName()) && templateSection.getParsedFieldDetails().isConditionalSectionElseStart()) {
                            string2 = " \"ELSE\" ";
                        }
                    }
                } else if (templateSection instanceof SimpleTemplateField) {
                    object = (SimpleTemplateField)templateSection;
                    string2 = ((SimpleTemplateSection)object).getParsedFieldDetails().isSetVariable() ? " <setVariable(" + ((SimpleTemplateSection)object).getParsedFieldDetails().getOriginalFieldText() + ")> " : " \"" + ((SimpleTemplateField)object).getFieldName() + "\" ";
                }
                if (((String)(object = templateSection.getClass().getName())).indexOf(46) != -1) {
                    object = ((String)object).substring(((String)object).lastIndexOf(46) + 1);
                }
                String string3 = (String)object + string2 + " [" + templateSection.getStartIndex() + " - " + templateSection.getEndIndex() + "]";
                String string4 = "";
                if (templateSection.skipPreAndPostAmble()) {
                    string4 = " [SkipPreAmble to:" + templateSection.getPreAmbleEndIdx() + " SkipPostAmble from:" + templateSection.getPostAmbleStartIdx() + "]";
                }
                if (reader != null && templateSection.getStartIndex() > l) {
                    System.out.print(string + B);
                    l += AnalysisDumper.stream(reader, templateSection.getStartIndex() - l);
                    System.out.println();
                }
                System.out.println();
                System.out.println(string + string3 + string4);
                System.out.print(string);
                for (n = 0; n < string3.length(); ++n) {
                    System.out.print('-');
                }
                System.out.println();
                if (reader != null) {
                    if (templateSection.getPreAmbleEndIdx() > l) {
                        System.out.print(string + F);
                        l += AnalysisDumper.stream(reader, templateSection.getPreAmbleEndIdx() - l + 1L);
                        System.out.println();
                    }
                    if (templateSection.getSubSections() != null && templateSection.getSubSections().length > 0 && templateSection.getSubSections()[0].getStartIndex() > l) {
                        System.out.print(string + B);
                        l += AnalysisDumper.stream(reader, templateSection.getSubSections()[0].getStartIndex() - l);
                        System.out.println();
                    }
                }
                l = AnalysisDumper.doIndexDump(reader, l, templateSection.getSubSections(), string + C);
                if (reader != null) {
                    if (templateSection.getPostAmbleStartIdx() > l) {
                        System.out.print(string + B);
                        l += AnalysisDumper.stream(reader, templateSection.getPostAmbleStartIdx() - l);
                        System.out.println();
                    }
                    if (templateSection.getPostAmbleStartIdx() == l) {
                        System.out.print(string + E);
                        l += AnalysisDumper.stream(reader, templateSection.getEndIndex() - l + 1L);
                        System.out.println();
                    }
                    if (templateSection.getEndIndex() > l) {
                        System.out.print(string + B);
                        l += AnalysisDumper.stream(reader, templateSection.getEndIndex() - l + 1L);
                        System.out.println();
                    }
                    if (templateSection instanceof TemplateXMLAdjustmentSection) {
                        System.out.println(string + A + ((TemplateXMLAdjustmentSection)templateSection).getContent());
                    }
                    System.out.print(string);
                    for (n = 0; n < string3.length(); ++n) {
                        System.out.print('-');
                    }
                    System.out.println();
                }
                System.out.println();
            }
            System.out.println();
        }
        return l;
    }

    private static long stream(Reader reader, long l) throws IOException {
        char[] cArray = new char[1];
        int n = 0;
        while ((long)n < l) {
            char c;
            if (reader.read(cArray, 0, 1) == -1) {
                // empty if block
            }
            if ((c = cArray[0]) < ' ' || c > '~') {
                c = '_';
            }
            System.out.print(c);
            ++n;
        }
        return l;
    }

    public static void dump(TemplateAnalysis templateAnalysis) {
        new AnalysisDumper().dump(templateAnalysis, System.out);
    }

    public void dump(TemplateAnalysis templateAnalysis, PrintStream printStream) {
        this.D = printStream;
        printStream.println("<HTML><BODY>");
        this.dump(templateAnalysis.getSections(), null);
        printStream.println("</BODY></HTML>");
    }

    public void dump(TemplateSection[] templateSectionArray, _A _A2) {
        if (templateSectionArray == null) {
            return;
        }
        for (int i = 0; i < templateSectionArray.length; ++i) {
            this.dump(templateSectionArray[i], _A2);
        }
    }

    public void dump(TemplateSection templateSection, _A _A2) {
        if (templateSection instanceof TemplateTable) {
            this.dumpTable((TemplateTable)templateSection, _A2);
        } else if (templateSection instanceof SimpleTemplateField) {
            this.dumpField((SimpleTemplateField)templateSection, _A2);
        } else if (templateSection instanceof SimpleTemplateRepeatableSection) {
            boolean bl;
            boolean bl2 = bl = _A2 != null && ((SimpleTemplateRepeatableSection)templateSection).isDerivedFromRepeatingTableRow();
            if (bl) {
                _A2.B(this.D);
            }
            this.dump(templateSection.getSubSections(), _A2);
            if (bl) {
                _A2.A(this.D);
            }
        } else {
            String string = templateSection.getClass().getName();
            if (string.lastIndexOf(46) != -1) {
                string = string.substring(string.lastIndexOf(46) + 1);
            }
            this.D.println(string);
            if (templateSection.getSubSections() != null) {
                this.dump(templateSection.getSubSections(), _A2);
            }
        }
    }

    private void dumpField(SimpleTemplateField simpleTemplateField, _A _A2) {
        if (_A2 != null) {
            if (simpleTemplateField.isFirstFieldInTableRow()) {
                _A2.B(this.D);
            }
            this.D.print("<TD bgcolor=\"" + _A2.A(simpleTemplateField) + "\">");
        }
        this.D.print(simpleTemplateField.toBriefString());
        if (_A2 != null) {
            this.D.print("</TD>");
        }
    }

    private void dumpTable(TemplateTable templateTable, _A _A2) {
        this.D.println("<P/><table border=\"1\">");
        _A _A3 = new _A();
        this.dump(templateTable.getSubSections(), _A3);
        _A3.A(this.D);
        this.D.println("</table>");
    }

    public static void main(String[] stringArray) throws TemplateNotFoundException, IOException, TemplateStoreException {
        AnalysisDumper.dump(null);
    }

    private static class _A {
        private static final String[] C = new String[]{"b9", "bc", "bf", "d9", "dc", "df", "f9", "fc", "ff", "59", "55", "5c", "5f", "79", "7c", "7f", "99", "9c", "9f"};
        int E;
        int D;
        int B;
        private HashMap F = new HashMap();
        private boolean A = false;

        private _A() {
        }

        private String A(TemplateField templateField) {
            String string = ((SimpleTemplateField)templateField).toDebugString(0);
            String string2 = (String)this.F.get(string);
            if (string2 == null) {
                string2 = this.A();
                this.F.put(string, string2);
            }
            return string2;
        }

        private String A() {
            ++this.E;
            if (this.E % 2 == 0) {
                this.D += 3;
            }
            this.B += 5;
            return new StringBuffer().append("#").append(C[this.E % C.length]).append(C[this.D % C.length]).append(C[this.B % C.length]).toString();
        }

        public void B(PrintStream printStream) {
            if (this.A) {
                printStream.println("</TR>");
            }
            printStream.println("<TR>");
            this.A = true;
        }

        public void A(PrintStream printStream) {
            if (this.A) {
                printStream.println("</TR>");
                this.A = false;
            }
        }
    }
}

