/*
 * Decompiled with CFR 0.152.
 */
package com.docmosis.template.analysis.structure;

import com.docmosis.template.analysis.structure.JSONDummyDataTemplateStructureProcessor;
import java.io.ByteArrayInputStream;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.json.com.docmosis.JSONObject;
import org.json.com.docmosis.XML;

public class XMLDummyDataTemplateStructureProcessor
extends JSONDummyDataTemplateStructureProcessor {
    @Override
    public String toString() {
        return this.jsonToXml(this.jsonRoot);
    }

    private String jsonToXml(JSONObject jSONObject) {
        try {
            String string = XML.toString(jSONObject, "data");
            return XMLDummyDataTemplateStructureProcessor.formatXml(string);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static String formatXml(String string) throws TransformerFactoryConfigurationError, UnsupportedEncodingException, TransformerException {
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        transformer.setURIResolver(new NoExternalEntitiesAllowedResolver());
        StreamResult streamResult = new StreamResult(new StringWriter());
        StreamSource streamSource = new StreamSource(new ByteArrayInputStream(string.getBytes("UTF-8")));
        transformer.transform(streamSource, streamResult);
        String string2 = streamResult.getWriter().toString();
        if ("<data/>".equals(string2) || "<data/>\r\n".equals(string2) || "<data/>\n".equals(string2)) {
            string2 = "<data>\n</data>\n";
        }
        return string2;
    }

    private static class NoExternalEntitiesAllowedResolver
    implements URIResolver {
        private NoExternalEntitiesAllowedResolver() {
        }

        @Override
        public Source resolve(String string, String string2) throws TransformerException {
            StreamSource streamSource = new StreamSource(new ByteArrayInputStream("".getBytes()));
            return streamSource;
        }
    }
}

