/*
 * Decompiled with CFR 0.152.
 */
package com.docmosis.template.analysis.structure;

import com.docmosis.template.TemplateNotFoundException;
import com.docmosis.template.TemplateStoreException;
import com.docmosis.template.analysis.ParsedField;
import com.docmosis.template.analysis.SimpleTemplateField;
import com.docmosis.template.analysis.SimpleTemplateImage;
import com.docmosis.template.analysis.SimpleTemplateReferenceSection;
import com.docmosis.template.analysis.SimpleTemplateRepeatableSection;
import com.docmosis.template.analysis.SimpleTemplateSection;
import com.docmosis.template.analysis.TemplateAnalysis;
import com.docmosis.template.analysis.TemplateNamedSection;
import com.docmosis.template.analysis.TemplateSection;
import com.docmosis.template.analysis.barcode.BarcodeInfo;
import com.docmosis.template.analysis.parsing.FieldParserCommon;
import com.docmosis.template.analysis.structure.AbstractStructureElement;
import com.docmosis.template.analysis.structure.NestedStructureDetails;
import com.docmosis.template.analysis.structure.TemplateExpression;
import com.docmosis.template.analysis.structure.TemplateStructureElement;
import com.docmosis.template.analysis.structure.TemplateStructureProcessor;
import com.docmosis.template.population.PopulatorFactory;
import com.docmosis.template.store.TemplateIdentifier;
import com.docmosis.template.store.TemplateStore;
import com.docmosis.template.store.TemplateStoreFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.jeval.com.docmosis.EvaluationException;
import net.sourceforge.jeval.com.docmosis.Evaluator;
import net.sourceforge.jeval.com.docmosis.VariableResolver;
import net.sourceforge.jeval.com.docmosis.function.FunctionException;

public class TemplateStructureExtractor {
    private List structure = new ArrayList();

    public TemplateStructureExtractor(TemplateAnalysis templateAnalysis) {
        this.extractStructure(templateAnalysis.getStyleAnalysis(), true);
        this.extractStructure(templateAnalysis, false);
    }

    private void extractStructure(TemplateAnalysis templateAnalysis, boolean bl) {
        this.extractStructure(templateAnalysis.getSections(), this.structure, bl);
    }

    private void extractStructure(TemplateSection[] templateSectionArray, List list, boolean bl) {
        if (templateSectionArray != null) {
            for (int i = 0; i < templateSectionArray.length; ++i) {
                Object object;
                Object object2;
                String string = null;
                NestedStructureDetails nestedStructureDetails = null;
                if (templateSectionArray[i] instanceof SimpleTemplateImage) {
                    if (TemplateStructureExtractor.isNested(templateSectionArray[i])) {
                        nestedStructureDetails = TemplateStructureExtractor.createNestedStructure(templateSectionArray[i], bl);
                        string = nestedStructureDetails.getLookupName();
                    }
                    object2 = (SimpleTemplateImage)templateSectionArray[i];
                    String string2 = string = string == null ? ((SimpleTemplateImage)object2).getLookupName() : string;
                    if (((SimpleTemplateImage)object2).isStaticImage()) continue;
                    AbstractStructureElement.ImageSectionElement imageSectionElement = new AbstractStructureElement.ImageSectionElement(string, bl, templateSectionArray[i].isArtificial(), BarcodeInfo.isBarcode(((SimpleTemplateImage)object2).getBarcodeInfo()), BarcodeInfo.isQRCode(((SimpleTemplateImage)object2).getBarcodeInfo()), ((SimpleTemplateSection)object2).getParsedFieldDetails().getOriginalFieldText());
                    imageSectionElement.setContainingNest(nestedStructureDetails);
                    list.add(imageSectionElement);
                    continue;
                }
                if (templateSectionArray[i] instanceof SimpleTemplateField) {
                    if (templateSectionArray[i].getParsedFieldDetails().isDumpField() || templateSectionArray[i].getParsedFieldDetails().isDumpVersionsField()) continue;
                    if (TemplateStructureExtractor.isNested(templateSectionArray[i])) {
                        nestedStructureDetails = TemplateStructureExtractor.createNestedStructure(templateSectionArray[i], bl);
                        string = nestedStructureDetails.getLookupName();
                    }
                    object2 = list;
                    SimpleTemplateField simpleTemplateField = (SimpleTemplateField)templateSectionArray[i];
                    object = TemplateStructureExtractor.getExpression(simpleTemplateField, bl, simpleTemplateField.isHyperlink(), simpleTemplateField.isHtmlRef());
                    boolean bl2 = object != null;
                    boolean bl3 = TemplateStructureExtractor.isVariableGetField(simpleTemplateField);
                    boolean bl4 = TemplateStructureExtractor.isVariableSetField(simpleTemplateField);
                    if (string == null && !bl2) {
                        if (bl3) {
                            string = simpleTemplateField.getFieldName();
                        } else if (!(simpleTemplateField.getParsedFieldDetails().getLastTerm().isLiteral() || simpleTemplateField.getParsedFieldDetails().getLastTerm().isMethodName() || simpleTemplateField.getParsedFieldDetails().getLastTerm().isVariable())) {
                            string = simpleTemplateField.getParsedFieldDetails().getLastTerm().getLookupName();
                        }
                    }
                    AbstractStructureElement.FieldSectionElement fieldSectionElement = new AbstractStructureElement.FieldSectionElement(string, bl, simpleTemplateField.isArtificial(), simpleTemplateField.isHyperlink(), simpleTemplateField.getParsedFieldDetails().getOriginalFieldText(), simpleTemplateField.isHtmlRef());
                    fieldSectionElement.setVariableGetField(bl3);
                    fieldSectionElement.setVariableSetField(bl4);
                    fieldSectionElement.setExpression((TemplateExpression)object);
                    fieldSectionElement.setContainingNest(nestedStructureDetails);
                    object2.add(fieldSectionElement);
                    continue;
                }
                if (templateSectionArray[i] instanceof TemplateNamedSection) {
                    if (TemplateStructureExtractor.isNested(templateSectionArray[i])) {
                        nestedStructureDetails = TemplateStructureExtractor.createNestedStructure(templateSectionArray[i], bl);
                        string = nestedStructureDetails.getLookupName();
                    }
                    if ((object2 = string) == null && templateSectionArray[i].getParsedFieldDetails() != null && templateSectionArray[i].getParsedFieldDetails().getLastTerm() != null) {
                        object2 = templateSectionArray[i].getParsedFieldDetails().getLastTerm().getLookupName();
                    }
                    if (object2 == null && templateSectionArray[i] instanceof TemplateNamedSection) {
                        object2 = ((TemplateNamedSection)templateSectionArray[i]).getSectionName();
                    }
                    if (templateSectionArray[i].isRepeatable()) {
                        boolean bl5 = templateSectionArray[i] instanceof SimpleTemplateRepeatableSection && ((SimpleTemplateRepeatableSection)templateSectionArray[i]).isGroupItems();
                        object = new AbstractStructureElement.RepeatingSectionElement((String)object2, bl, templateSectionArray[i].isArtificial(), templateSectionArray[i].getParsedFieldDetails().getOriginalFieldText(), bl5);
                        ((AbstractStructureElement)object).setContainingNest(nestedStructureDetails);
                        list.add(object);
                        this.extractStructure(templateSectionArray[i].getSubSections(), ((AbstractStructureElement)object).getSubStructures(), bl);
                        continue;
                    }
                    if (templateSectionArray[i].isConditional()) {
                        TemplateExpression templateExpression = TemplateStructureExtractor.getExpression(templateSectionArray[i], bl, false, false);
                        object = new AbstractStructureElement.ConditionalSectionElement((String)object2, bl, templateSectionArray[i].isArtificial(), templateSectionArray[i].getParsedFieldDetails().getOriginalFieldText());
                        ((AbstractStructureElement)object).setExpression(templateExpression);
                        ((AbstractStructureElement)object).setContainingNest(nestedStructureDetails);
                        list.add(object);
                        this.extractStructure(templateSectionArray[i].getSubSections(), ((AbstractStructureElement)object).getSubStructures(), bl);
                        continue;
                    }
                    this.extractStructure(templateSectionArray[i].getSubSections(), list, bl);
                    continue;
                }
                if (templateSectionArray[i] instanceof SimpleTemplateReferenceSection) {
                    if (TemplateStructureExtractor.isNested(templateSectionArray[i])) {
                        nestedStructureDetails = TemplateStructureExtractor.createNestedStructure(templateSectionArray[i], bl);
                        string = nestedStructureDetails.getLookupName();
                    }
                    object2 = list;
                    SimpleTemplateReferenceSection simpleTemplateReferenceSection = (SimpleTemplateReferenceSection)templateSectionArray[i];
                    object = string;
                    if (object == null && templateSectionArray[i].getParsedFieldDetails() != null && templateSectionArray[i].getParsedFieldDetails().getLastTerm() != null) {
                        object = templateSectionArray[i].getParsedFieldDetails().getLastTerm().getLookupName();
                    }
                    string = string == null ? object : string;
                    string = string == null ? simpleTemplateReferenceSection.getName() : string;
                    AbstractStructureElement.TemplateReferenceSectionElement templateReferenceSectionElement = new AbstractStructureElement.TemplateReferenceSectionElement(string, bl, simpleTemplateReferenceSection.isArtificial(), simpleTemplateReferenceSection.getName(), simpleTemplateReferenceSection.isTemplateLookup(), simpleTemplateReferenceSection.isOptional(), simpleTemplateReferenceSection.getParsedFieldDetails().getOriginalFieldText());
                    templateReferenceSectionElement.setContainingNest(nestedStructureDetails);
                    object2.add(templateReferenceSectionElement);
                    continue;
                }
                this.extractStructure(templateSectionArray[i].getSubSections(), list, bl);
            }
        }
    }

    private static boolean isNested(TemplateSection templateSection) {
        return templateSection.getParsedFieldDetails() != null && templateSection.getParsedFieldDetails().getTerms() != null && templateSection.getParsedFieldDetails().getTerms().length > 1;
    }

    private static NestedStructureDetails createNestedStructure(TemplateSection templateSection, boolean bl) {
        AbstractStructureElement.RepeatingSectionElement repeatingSectionElement = null;
        TemplateStructureElement templateStructureElement = null;
        ParsedField.NameTerm nameTerm = null;
        for (int i = 0; i < templateSection.getParsedFieldDetails().getTerms().length; ++i) {
            boolean bl2;
            ParsedField.NameTerm nameTerm2 = templateSection.getParsedFieldDetails().getTerms()[i];
            boolean bl3 = bl2 = templateSection instanceof SimpleTemplateRepeatableSection && ((SimpleTemplateRepeatableSection)templateSection).isGroupItems();
            if (i < templateSection.getParsedFieldDetails().getTerms().length - 1) {
                AbstractStructureElement.RepeatingSectionElement repeatingSectionElement2 = new AbstractStructureElement.RepeatingSectionElement(nameTerm2.getLookupName(), bl, false, templateSection.getParsedFieldDetails().getOriginalFieldText(), bl2);
                if (repeatingSectionElement == null) {
                    repeatingSectionElement = repeatingSectionElement2;
                } else {
                    templateStructureElement.getSubStructures().add(repeatingSectionElement2);
                }
                templateStructureElement = repeatingSectionElement2;
            }
            nameTerm = nameTerm2;
        }
        return new NestedStructureDetails(repeatingSectionElement, nameTerm.getLookupName());
    }

    private static NestedStructureDetails createNestedStructure(String string, boolean bl, boolean bl2, boolean bl3) {
        AbstractStructureElement.RepeatingSectionElement repeatingSectionElement = null;
        TemplateStructureElement templateStructureElement = null;
        String string2 = null;
        String[] stringArray = string.split("\\.");
        for (int i = 0; i < stringArray.length; ++i) {
            String string3 = stringArray[i];
            if (i < stringArray.length - 1) {
                AbstractStructureElement.RepeatingSectionElement repeatingSectionElement2 = new AbstractStructureElement.RepeatingSectionElement(string3, bl, bl2, null, bl3);
                if (repeatingSectionElement == null) {
                    repeatingSectionElement = repeatingSectionElement2;
                } else {
                    templateStructureElement.getSubStructures().add(repeatingSectionElement2);
                }
                templateStructureElement = repeatingSectionElement2;
            }
            string2 = string3;
        }
        return new NestedStructureDetails(repeatingSectionElement, string2);
    }

    public static List getStructureFromDefaultStore(TemplateIdentifier templateIdentifier) throws TemplateNotFoundException, TemplateStoreException {
        TemplateAnalysis templateAnalysis;
        try {
            templateAnalysis = TemplateStoreFactory.getStore().getTemplateAnalysis(templateIdentifier);
        }
        catch (IOException iOException) {
            throw new TemplateStoreException(iOException);
        }
        return new TemplateStructureExtractor(templateAnalysis).getStructure();
    }

    public List getStructure() {
        return this.structure;
    }

    public void process(TemplateStructureProcessor templateStructureProcessor) {
        if (this.structure != null) {
            templateStructureProcessor.start();
            this.process(templateStructureProcessor, this.structure);
            templateStructureProcessor.finish();
        }
    }

    public static void process(TemplateStructureProcessor templateStructureProcessor, TemplateIdentifier templateIdentifier) throws TemplateNotFoundException, TemplateStoreException {
        TemplateStructureExtractor templateStructureExtractor;
        TemplateStore templateStore = TemplateStoreFactory.getStore();
        try {
            templateStructureExtractor = new TemplateStructureExtractor(templateStore.getTemplateAnalysis(templateIdentifier));
        }
        catch (IOException iOException) {
            throw new TemplateStoreException(iOException);
        }
        templateStructureExtractor.process(templateStructureProcessor);
    }

    private void process(TemplateStructureProcessor templateStructureProcessor, List list) {
        for (int i = 0; i < list.size(); ++i) {
            boolean bl;
            TemplateStructureElement templateStructureElement = (TemplateStructureElement)list.get(i);
            if (templateStructureElement.isRepeatingSection()) {
                int n = 0;
                bl = true;
                while (bl) {
                    if (templateStructureProcessor.repeatBegin(templateStructureElement, n)) {
                        this.process(templateStructureProcessor, templateStructureElement.getSubStructures());
                        bl = templateStructureProcessor.repeatEnd(templateStructureElement, n);
                        ++n;
                        continue;
                    }
                    bl = false;
                }
                continue;
            }
            if (templateStructureElement.isConditionalSection()) {
                if (!templateStructureElement.isArtificial()) {
                    templateStructureProcessor.conditionalBegin(templateStructureElement);
                }
                this.process(templateStructureProcessor, templateStructureElement.getSubStructures());
                if (templateStructureElement.isArtificial()) continue;
                templateStructureProcessor.conditionalEnd(templateStructureElement);
                continue;
            }
            if (templateStructureElement.isField()) {
                if (templateStructureElement.isArtificial()) continue;
                String string = templateStructureElement.getName();
                bl = false;
                for (int j = i + 1; j < list.size(); ++j) {
                    TemplateStructureElement templateStructureElement2 = (TemplateStructureElement)list.get(j);
                    if (!templateStructureElement2.isImage() || templateStructureElement2.getName() == null || !templateStructureElement2.getName().equals(string)) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                templateStructureProcessor.field(templateStructureElement);
                continue;
            }
            if (templateStructureElement.isImage()) {
                templateStructureProcessor.image(templateStructureElement);
                continue;
            }
            if (!templateStructureElement.isTemplateReference()) continue;
            templateStructureProcessor.templateReference(templateStructureElement);
        }
    }

    private static TemplateExpression getExpression(TemplateSection templateSection, boolean bl, boolean bl2, boolean bl3) {
        TemplateExpression templateExpression = null;
        if (templateSection != null && templateSection.getParsedFieldDetails() != null && templateSection.getParsedFieldDetails().isExpression()) {
            templateExpression = new TemplateExpression(templateSection.getParsedFieldDetails().getExpression().getExpressionString(), TemplateStructureExtractor.extractDataLookupFieldsFromExpression(templateSection.getParsedFieldDetails().getExpression().getExpressionString(), bl, templateSection.isArtificial(), bl2, bl3));
        }
        return templateExpression;
    }

    private static AbstractStructureElement.FieldSectionElement[] extractDataLookupFieldsFromExpression(String string, final boolean bl, final boolean bl2, final boolean bl3, final boolean bl4) {
        final ArrayList arrayList = new ArrayList();
        Evaluator evaluator = PopulatorFactory.getExpressionEvaluator();
        evaluator.setVariableResolver(new VariableResolver(){

            @Override
            public String resolveVariable(String string) throws FunctionException {
                if (FieldParserCommon.isFieldNameBracketingEnabled()) {
                    string = FieldParserCommon.unbracket(string);
                    if (FieldParserCommon.isFieldNameBracketingHyphenAllowed()) {
                        string = string.replace('\u2013', '-').replace('\u2014', '-');
                    }
                }
                NestedStructureDetails nestedStructureDetails = TemplateStructureExtractor.createNestedStructure(string, bl, bl2, false);
                String string2 = string;
                if (nestedStructureDetails != null) {
                    string2 = nestedStructureDetails.getLookupName();
                }
                AbstractStructureElement.FieldSectionElement fieldSectionElement = new AbstractStructureElement.FieldSectionElement(string2, bl, bl2, bl3, null, bl4);
                fieldSectionElement.setContainingNest(nestedStructureDetails);
                arrayList.add(fieldSectionElement);
                return null;
            }
        });
        try {
            evaluator.evaluate(string);
        }
        catch (EvaluationException evaluationException) {
            // empty catch block
        }
        AbstractStructureElement.FieldSectionElement[] fieldSectionElementArray = null;
        if (!arrayList.isEmpty()) {
            fieldSectionElementArray = new AbstractStructureElement.FieldSectionElement[arrayList.size()];
            arrayList.toArray(fieldSectionElementArray);
        }
        return fieldSectionElementArray;
    }

    private static boolean isVariableSetField(TemplateSection templateSection) {
        return templateSection != null && templateSection.getParsedFieldDetails() != null && templateSection.getParsedFieldDetails().isSetVariable();
    }

    private static boolean isVariableGetField(TemplateSection templateSection) {
        return templateSection != null && templateSection.getParsedFieldDetails() != null && templateSection.getParsedFieldDetails().isVariableLookup();
    }
}

