/*
 * Decompiled with CFR 0.152.
 */
package com.docmosis.template.analysis.structure;

import com.docmosis.template.TemplateNotFoundException;
import com.docmosis.template.TemplateStoreException;
import com.docmosis.template.analysis.structure.DataReferenceCollector;
import com.docmosis.template.analysis.structure.SimpleJSONTemplateStructureProcessor;
import com.docmosis.template.analysis.structure.TemplateStructureElement;
import com.docmosis.template.analysis.structure.TemplateStructureExtractor;
import com.docmosis.template.store.TemplateIdentifier;
import com.docmosis.util.StringUtilities;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;

public class TemplateDataReferenceFinder {
    public TemplateDataReference[] getReferences(TemplateIdentifier templateIdentifier) throws TemplateNotFoundException, TemplateStoreException {
        TemplateDataReferenceExtended[] templateDataReferenceExtendedArray = this.getReferencesDetailed(templateIdentifier);
        LinkedHashSet<TemplateDataReference> linkedHashSet = new LinkedHashSet<TemplateDataReference>();
        for (int i = 0; i < templateDataReferenceExtendedArray.length; ++i) {
            linkedHashSet.add(new TemplateDataReference(templateDataReferenceExtendedArray[i].getKey(), templateDataReferenceExtendedArray[i].getContext()));
        }
        TemplateDataReference[] templateDataReferenceArray = new TemplateDataReference[linkedHashSet.size()];
        linkedHashSet.toArray(templateDataReferenceArray);
        return templateDataReferenceArray;
    }

    public TemplateDataReferenceExtended[] getReferencesDetailed(TemplateIdentifier templateIdentifier) throws TemplateNotFoundException, TemplateStoreException {
        SimpleJSONTemplateStructureProcessor simpleJSONTemplateStructureProcessor = new SimpleJSONTemplateStructureProcessor();
        TemplateDataFieldCollector templateDataFieldCollector = new TemplateDataFieldCollector();
        simpleJSONTemplateStructureProcessor.setDataReferenceCollector(templateDataFieldCollector);
        TemplateStructureExtractor.process(simpleJSONTemplateStructureProcessor, templateIdentifier);
        return templateDataFieldCollector.getFields();
    }

    public String getReferencesInJSONFormat(TemplateIdentifier templateIdentifier) throws TemplateNotFoundException, TemplateStoreException {
        return this.getReferencesInJSONFormat(templateIdentifier, true);
    }

    public String getReferencesDetailedInJSONFormat(TemplateIdentifier templateIdentifier) throws TemplateNotFoundException, TemplateStoreException {
        return this.getReferencesInJSONFormat(templateIdentifier, false);
    }

    private String getReferencesInJSONFormat(TemplateIdentifier templateIdentifier, boolean bl) throws TemplateNotFoundException, TemplateStoreException {
        TemplateDataReference[] templateDataReferenceArray = bl ? this.getReferences(templateIdentifier) : this.getReferencesDetailed(templateIdentifier);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{\n").append(" \"minimized\":\"" + bl + "\",\n").append(" \"templateDataReferences\":[\n");
        for (int i = 0; i < templateDataReferenceArray.length; ++i) {
            TemplateDataReference templateDataReference = templateDataReferenceArray[i];
            if (i > 0) {
                stringBuffer.append(",\n");
            }
            stringBuffer.append("   {\"name\":\"").append(templateDataReference.getKey()).append("\",\"context\":\"").append(templateDataReference.getContext());
            if (!bl) {
                TemplateDataReferenceExtended templateDataReferenceExtended = (TemplateDataReferenceExtended)templateDataReference;
                stringBuffer.append("\",\"inHeaderOrFooter\":\"").append(templateDataReferenceExtended.isInHeaderOrFooter()).append("\",\"originalText\":\"").append(templateDataReferenceExtended.getOriginalFieldText());
            }
            stringBuffer.append("\"}");
        }
        stringBuffer.append("\n  ]\n");
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    public static class TemplateDataReferenceExtended
    extends TemplateDataReference {
        private String originalFieldText;
        private boolean inHeaderOrFooter;

        public TemplateDataReferenceExtended(String string, String string2, String string3, boolean bl) {
            super(string, string2);
            this.originalFieldText = string3;
            this.inHeaderOrFooter = bl;
        }

        public String getOriginalFieldText() {
            return this.originalFieldText;
        }

        public void setOriginalFieldText(String string) {
            this.originalFieldText = string;
        }

        public boolean isInHeaderOrFooter() {
            return this.inHeaderOrFooter;
        }

        public void setInHeaderOrFooter(boolean bl) {
            this.inHeaderOrFooter = bl;
        }

        @Override
        public String toString() {
            StringBuffer stringBuffer = new StringBuffer(super.toString());
            stringBuffer.append(" [original field=" + this.originalFieldText + "]");
            return stringBuffer.toString();
        }

        @Override
        public int hashCode() {
            int n = 31;
            int n2 = super.hashCode();
            n2 = 31 * n2 + (this.inHeaderOrFooter ? 1231 : 1237);
            n2 = 31 * n2 + (this.originalFieldText == null ? 0 : this.originalFieldText.hashCode());
            return n2;
        }

        @Override
        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!super.equals(object)) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            TemplateDataReferenceExtended templateDataReferenceExtended = (TemplateDataReferenceExtended)object;
            if (this.inHeaderOrFooter != templateDataReferenceExtended.inHeaderOrFooter) {
                return false;
            }
            return !(this.originalFieldText == null ? templateDataReferenceExtended.originalFieldText != null : !this.originalFieldText.equals(templateDataReferenceExtended.originalFieldText));
        }
    }

    public static class TemplateDataReference {
        private final String key;
        private final String context;

        public TemplateDataReference(String string, String string2) {
            this.key = string;
            this.context = string2;
        }

        public String getKey() {
            return this.key;
        }

        public String getContext() {
            return this.context;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer(super.toString());
            stringBuffer.append(StringUtilities.isEmpty(this.context) ? this.key : this.context + "." + this.key);
            return stringBuffer.toString();
        }

        public int hashCode() {
            int n = 31;
            int n2 = 1;
            n2 = 31 * n2 + (this.context == null ? 0 : this.context.hashCode());
            n2 = 31 * n2 + (this.key == null ? 0 : this.key.hashCode());
            return n2;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            TemplateDataReference templateDataReference = (TemplateDataReference)object;
            if (this.context == null ? templateDataReference.context != null : !this.context.equals(templateDataReference.context)) {
                return false;
            }
            return !(this.key == null ? templateDataReference.key != null : !this.key.equals(templateDataReference.key));
        }
    }

    public static class TemplateDataFieldCollector
    implements DataReferenceCollector {
        private List fields = new ArrayList();
        private List currentContext = new ArrayList();

        public TemplateDataReferenceExtended[] getFields() {
            TemplateDataReferenceExtended[] templateDataReferenceExtendedArray = new TemplateDataReferenceExtended[this.fields.size()];
            this.fields.toArray(templateDataReferenceExtendedArray);
            return templateDataReferenceExtendedArray;
        }

        @Override
        public void collect(String string, TemplateStructureElement templateStructureElement) {
            String[] stringArray = string.split("\\.");
            String string2 = stringArray[stringArray.length - 1];
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.getCurrentContextAsString());
            for (int i = 0; i < stringArray.length - 1; ++i) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append('.');
                }
                stringBuffer.append(stringArray[i]);
            }
            this.fields.add(new TemplateDataReferenceExtended(string2, stringBuffer.toString(), templateStructureElement.getOriginalFieldText(), templateStructureElement.isInHeaderOrFooter()));
        }

        private String getCurrentContextAsString() {
            String string = "";
            if (!this.currentContext.isEmpty()) {
                StringBuffer stringBuffer = new StringBuffer();
                Iterator iterator = this.currentContext.iterator();
                while (iterator.hasNext()) {
                    if (stringBuffer.length() > 0) {
                        stringBuffer.append('.');
                    }
                    stringBuffer.append((String)iterator.next());
                }
                string = stringBuffer.toString();
            }
            return string;
        }

        @Override
        public void stepIntoContext(String string) {
            this.currentContext.add(string);
        }

        @Override
        public void stepOutOfContext() {
            this.currentContext.remove(this.currentContext.size() - 1);
        }
    }
}

