/*
 * Decompiled with CFR 0.152.
 */
package com.docmosis.template.analysis.structure;

import com.docmosis.template.analysis.structure.AbstractStructureElement;
import com.docmosis.template.analysis.structure.DataReferenceCollector;
import com.docmosis.template.analysis.structure.TemplateStructureElement;
import com.docmosis.template.analysis.structure.TemplateStructureProcessor;
import com.docmosis.util.StringUtilities;
import java.util.HashSet;
import org.json.com.docmosis.JSONObject;

public class SimpleJSONTemplateStructureProcessor
implements TemplateStructureProcessor {
    private static final String DEFAULT_ROOT_NAME = "structure";
    private static final String INDENT_FACTOR = "  ";
    private String indent = "";
    private StringBuffer writeTo = new StringBuffer();
    private int fieldIdx;
    private int imageIdx;
    private int refIdx;
    private int repeatIdx;
    private int conditionIdx;
    private boolean commaRequired;
    private final String mainKeyName;
    private DataReferenceCollector dataReferenceCollector;

    public SimpleJSONTemplateStructureProcessor() {
        this(DEFAULT_ROOT_NAME);
    }

    public SimpleJSONTemplateStructureProcessor(String string) {
        this.mainKeyName = string;
    }

    @Override
    public void start() {
        if (this.mainKeyName != null) {
            this.writeTo.append("{\"" + this.mainKeyName + "\":");
        }
        this.writeTo.append("[");
        this.indent = this.indent + INDENT_FACTOR;
    }

    @Override
    public void finish() {
        this.indent = this.indent.substring(INDENT_FACTOR.length());
        this.writeTo.append("\n]");
        if (this.mainKeyName != null) {
            this.writeTo.append("}");
        }
        this.writeTo.append('\n');
    }

    @Override
    public void field(TemplateStructureElement templateStructureElement) {
        if (this.commaRequired) {
            this.writeTo.append(',');
        }
        this.writeTo.append('\n');
        this.writeTo.append(this.indent).append("{\"type\":\"field\",\"fieldIdx\":").append(this.fieldIdx).append(",\"text\":").append(SimpleJSONTemplateStructureProcessor.jsonEscape(templateStructureElement.getOriginalFieldText())).append(",");
        this.writeDataRefs(this.writeTo, templateStructureElement);
        this.writeTo.append("}");
        this.commaRequired = true;
        ++this.fieldIdx;
    }

    private void writeDataRefs(StringBuffer stringBuffer, TemplateStructureElement templateStructureElement) {
        Object object;
        stringBuffer.append("\"dataRefs\":[");
        HashSet<Object> hashSet = new HashSet<Object>();
        boolean bl = false;
        if (!SimpleJSONTemplateStructureProcessor.ignoreKey(templateStructureElement) && !hashSet.contains(object = this.getNestingContext(templateStructureElement) + templateStructureElement.getName())) {
            hashSet.add(object);
            stringBuffer.append('\"').append((String)object).append('\"');
            bl = true;
            if (this.dataReferenceCollector != null) {
                this.dataReferenceCollector.collect((String)object, templateStructureElement);
            }
        }
        if (templateStructureElement.isExpression() && templateStructureElement.getExpression().getDataLookups() != null) {
            object = templateStructureElement.getExpression().getDataLookups();
            for (int i = 0; i < ((AbstractStructureElement.FieldSectionElement[])object).length; ++i) {
                String string;
                AbstractStructureElement.FieldSectionElement fieldSectionElement = object[i];
                if (SimpleJSONTemplateStructureProcessor.ignoreKey(fieldSectionElement) || hashSet.contains(string = this.getNestingContext(fieldSectionElement) + fieldSectionElement.getName())) continue;
                hashSet.add(string);
                if (bl) {
                    stringBuffer.append(',');
                }
                stringBuffer.append('\"').append(string).append('\"');
                bl = true;
                if (this.dataReferenceCollector == null) continue;
                this.dataReferenceCollector.collect(string, templateStructureElement);
            }
        }
        stringBuffer.append("]");
    }

    private static boolean ignoreKey(TemplateStructureElement templateStructureElement) {
        if (templateStructureElement.isExpression() || templateStructureElement.isVariableGetField() || templateStructureElement.isFunctionCall()) {
            return true;
        }
        if (templateStructureElement.isTemplateReferenceStatic()) {
            return true;
        }
        if (templateStructureElement.isConditionalSection() && (templateStructureElement.getName().equals("true") || templateStructureElement.getName().equals("false"))) {
            return true;
        }
        String string = templateStructureElement.getName();
        return StringUtilities.isEmpty(string) || string.equals("null") || string.startsWith("$") || string.trim().startsWith("{");
    }

    @Override
    public void image(TemplateStructureElement templateStructureElement) {
        if (this.commaRequired) {
            this.writeTo.append(',');
        }
        this.writeTo.append('\n');
        this.writeTo.append(this.indent).append("{\"type\":\"image\",\"imageIdx\":").append(this.imageIdx).append(",\"text\":").append(SimpleJSONTemplateStructureProcessor.jsonEscape(templateStructureElement.getOriginalFieldText())).append(",");
        this.writeDataRefs(this.writeTo, templateStructureElement);
        this.writeTo.append("}");
        this.commaRequired = true;
        ++this.imageIdx;
    }

    @Override
    public void templateReference(TemplateStructureElement templateStructureElement) {
        if (templateStructureElement.getName() == null || templateStructureElement.getName().startsWith("$")) {
            return;
        }
        if (this.commaRequired) {
            this.writeTo.append(',');
        }
        this.writeTo.append('\n');
        String string = templateStructureElement.isTemplateReferenceStatic() ? "static" : "dynamic";
        this.writeTo.append(this.indent).append("{\"type\":\"templateRef\",\"templateRefIdx\":").append(this.refIdx).append(",\"text\":").append(SimpleJSONTemplateStructureProcessor.jsonEscape(templateStructureElement.getOriginalFieldText())).append(",\"templateRefType\":\"").append(string).append("\",");
        this.writeDataRefs(this.writeTo, templateStructureElement);
        this.writeTo.append("}");
        this.commaRequired = true;
        ++this.refIdx;
    }

    @Override
    public boolean repeatBegin(TemplateStructureElement templateStructureElement, int n) {
        if (this.commaRequired) {
            this.writeTo.append(',');
        }
        this.writeTo.append('\n');
        this.writeTo.append(this.indent).append("{\"type\":\"repeat\",\"repeatIdx\":").append(this.repeatIdx).append(",\"text\":").append(SimpleJSONTemplateStructureProcessor.jsonEscape(templateStructureElement.getOriginalFieldText())).append(",");
        this.writeDataRefs(this.writeTo, templateStructureElement);
        this.writeTo.append(",\"contains\":[");
        this.commaRequired = false;
        this.indent = this.indent + INDENT_FACTOR;
        ++this.repeatIdx;
        if (this.dataReferenceCollector != null) {
            this.dataReferenceCollector.stepIntoContext(this.getNestingContext(templateStructureElement) + templateStructureElement.getName());
        }
        return true;
    }

    @Override
    public boolean repeatEnd(TemplateStructureElement templateStructureElement, int n) {
        this.writeTo.append('\n');
        this.indent = this.indent.substring(INDENT_FACTOR.length());
        this.writeTo.append(this.indent).append("]}");
        this.commaRequired = true;
        if (this.dataReferenceCollector != null) {
            this.dataReferenceCollector.stepOutOfContext();
        }
        return false;
    }

    @Override
    public void conditionalBegin(TemplateStructureElement templateStructureElement) {
        if (this.commaRequired) {
            this.writeTo.append(',');
        }
        this.writeTo.append('\n');
        this.writeTo.append(this.indent).append("{\"type\":\"condition\",\"conditionIdx\":").append(this.conditionIdx).append(",\"text\":").append(SimpleJSONTemplateStructureProcessor.jsonEscape(templateStructureElement.getOriginalFieldText())).append(",");
        this.writeDataRefs(this.writeTo, templateStructureElement);
        this.writeTo.append(",\"contains\":[");
        this.indent = this.indent + INDENT_FACTOR;
        this.commaRequired = false;
        ++this.conditionIdx;
    }

    @Override
    public void conditionalEnd(TemplateStructureElement templateStructureElement) {
        this.writeTo.append('\n');
        this.indent = this.indent.substring(INDENT_FACTOR.length());
        this.writeTo.append(this.indent).append("]}");
        this.commaRequired = true;
    }

    public String toString() {
        return this.writeTo.toString();
    }

    private String getNestingContext(TemplateStructureElement templateStructureElement) {
        if (templateStructureElement.getContainingNest() == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        templateStructureElement = templateStructureElement.getContainingNest().getRoot();
        while (templateStructureElement != null) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(".");
            }
            stringBuffer.append(templateStructureElement.getName());
            if (templateStructureElement.getSubStructures() == null || templateStructureElement.getSubStructures().isEmpty()) {
                templateStructureElement = null;
                continue;
            }
            templateStructureElement = templateStructureElement.getSubStructures() == null ? null : (TemplateStructureElement)templateStructureElement.getSubStructures().get(0);
        }
        if (stringBuffer.length() > 0) {
            stringBuffer.append('.');
        }
        return stringBuffer.toString();
    }

    private static String jsonEscape(String string) {
        String string2 = null;
        if (string != null) {
            string2 = JSONObject.quote(string);
        }
        return string2;
    }

    public void setDataReferenceCollector(DataReferenceCollector dataReferenceCollector) {
        this.dataReferenceCollector = dataReferenceCollector;
    }
}

