/*
 * Decompiled with CFR 0.152.
 */
package com.docmosis.template.analysis.structure;

import com.docmosis.template.analysis.structure.AbstractStructureElement;
import com.docmosis.template.analysis.structure.NestedStructureDetails;
import com.docmosis.template.analysis.structure.TemplateStructureElement;
import com.docmosis.template.analysis.structure.TemplateStructureProcessor;
import com.docmosis.util.StringUtilities;
import java.util.Stack;
import org.json.com.docmosis.JSONArray;
import org.json.com.docmosis.JSONException;
import org.json.com.docmosis.JSONObject;

public class JSONDummyDataTemplateStructureProcessor
implements TemplateStructureProcessor {
    private static final String DUMMY_BASE64_IMAGE = "image:base64:" + JSONDummyDataTemplateStructureProcessor.getDummyImage();
    private static final String DUMMY_BARCODE = "bc1234";
    private static final String DUMMY_QRCODE = "https://www.docmosis.com";
    private int dataIdx;
    private static final int DEFAULT_N_REPEATS = 3;
    private static final boolean DEFAULT_INCLUDE_IMAGES = true;
    private int nRepeats = 3;
    private boolean includeImages = true;
    protected final JSONObject jsonRoot;
    private JSONObject currentJsonObject = this.jsonRoot = JSONDummyDataTemplateStructureProcessor.newJSONObject();
    private Stack currentObjectLineage = new Stack();

    public boolean isIncludeImages() {
        return this.includeImages;
    }

    public void setIncludeImages(boolean bl) {
        this.includeImages = bl;
    }

    public int getnRepeats() {
        return this.nRepeats;
    }

    public void setnRepeats(int n) {
        this.nRepeats = n;
    }

    @Override
    public void start() {
        this.dataIdx = 1;
    }

    @Override
    public void finish() {
    }

    @Override
    public void field(TemplateStructureElement templateStructureElement) {
        if (templateStructureElement.isExpression()) {
            if (templateStructureElement.getExpression().getDataLookups() != null) {
                for (int i = 0; i < templateStructureElement.getExpression().getDataLookups().length; ++i) {
                    AbstractStructureElement.FieldSectionElement fieldSectionElement = templateStructureElement.getExpression().getDataLookups()[i];
                    if (JSONDummyDataTemplateStructureProcessor.ignoreKey(fieldSectionElement)) continue;
                    this.addField(fieldSectionElement);
                }
            }
        } else {
            if (JSONDummyDataTemplateStructureProcessor.ignoreKey(templateStructureElement)) {
                return;
            }
            this.addField(templateStructureElement);
        }
    }

    private void addField(TemplateStructureElement templateStructureElement) {
        this.addField(templateStructureElement, null);
    }

    private void addField(TemplateStructureElement templateStructureElement, String string) {
        String string2 = templateStructureElement.getName();
        JSONObject jSONObject = this.currentJsonObject;
        if (templateStructureElement.getContainingNest() != null) {
            jSONObject = this.createPath(templateStructureElement.getContainingNest());
        }
        if (jSONObject != null && !jSONObject.has(string2)) {
            try {
                jSONObject.put(string2, string == null ? this.getValueForField(templateStructureElement) : string);
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
    }

    @Override
    public void image(TemplateStructureElement templateStructureElement) {
        String string = templateStructureElement.getName();
        if (JSONDummyDataTemplateStructureProcessor.ignoreKey(templateStructureElement)) {
            return;
        }
        JSONObject jSONObject = this.currentJsonObject;
        if (templateStructureElement.getContainingNest() != null) {
            jSONObject = this.createPath(templateStructureElement.getContainingNest());
        }
        if (jSONObject != null && !jSONObject.has(string)) {
            try {
                jSONObject.put(string, templateStructureElement.isQRCode() ? DUMMY_QRCODE : (templateStructureElement.isBarcode() ? DUMMY_BARCODE : DUMMY_BASE64_IMAGE));
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
    }

    @Override
    public void templateReference(TemplateStructureElement templateStructureElement) {
        if (templateStructureElement.isTemplateReferenceStatic()) {
            return;
        }
        if (JSONDummyDataTemplateStructureProcessor.ignoreKey(templateStructureElement)) {
            return;
        }
        this.addField(templateStructureElement);
    }

    @Override
    public boolean repeatBegin(TemplateStructureElement templateStructureElement, int n) {
        JSONArray jSONArray;
        Object object;
        String string = templateStructureElement.getName();
        if (JSONDummyDataTemplateStructureProcessor.ignoreKey(templateStructureElement)) {
            return false;
        }
        if (templateStructureElement.isGroupItems()) {
            return true;
        }
        JSONObject jSONObject = this.currentJsonObject;
        if (templateStructureElement.getContainingNest() != null) {
            jSONObject = this.createPath(templateStructureElement.getContainingNest());
        }
        if ((object = jSONObject.opt(string)) == null) {
            jSONArray = new JSONArray();
            try {
                jSONObject.put(string, jSONArray);
            }
            catch (JSONException jSONException) {}
        } else if (object instanceof JSONArray) {
            jSONArray = (JSONArray)object;
        } else {
            jSONArray = new JSONArray();
            try {
                jSONObject.put(string, jSONArray);
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        if (jSONArray.length() > n) {
            try {
                jSONObject = (JSONObject)jSONArray.get(n);
            }
            catch (JSONException jSONException) {}
        } else {
            jSONObject = JSONDummyDataTemplateStructureProcessor.newJSONObject();
            try {
                jSONArray.put(n, jSONObject);
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        this.push(jSONObject);
        return true;
    }

    @Override
    public boolean repeatEnd(TemplateStructureElement templateStructureElement, int n) {
        if (!templateStructureElement.isGroupItems()) {
            this.pop();
        }
        return n < this.nRepeats - 1;
    }

    @Override
    public void conditionalBegin(TemplateStructureElement templateStructureElement) {
        if (templateStructureElement.isExpression()) {
            if (templateStructureElement.getExpression().getDataLookups() != null) {
                for (int i = 0; i < templateStructureElement.getExpression().getDataLookups().length; ++i) {
                    AbstractStructureElement.FieldSectionElement fieldSectionElement = templateStructureElement.getExpression().getDataLookups()[i];
                    if (JSONDummyDataTemplateStructureProcessor.ignoreKey(fieldSectionElement)) continue;
                    this.addField(templateStructureElement.getExpression().getDataLookups()[i]);
                }
            }
        } else {
            if (JSONDummyDataTemplateStructureProcessor.ignoreKey(templateStructureElement)) {
                return;
            }
            this.addField(templateStructureElement, "true");
        }
    }

    @Override
    public void conditionalEnd(TemplateStructureElement templateStructureElement) {
    }

    public String toString() {
        try {
            return this.jsonRoot.toString(2);
        }
        catch (JSONException jSONException) {
            return null;
        }
    }

    private String getValueForField(TemplateStructureElement templateStructureElement) {
        if (templateStructureElement.isHyperlink()) {
            String string = "example.com item " + this.dataIdx++;
            String string2 = "http://example.com/";
            return string + "|" + "http://example.com/";
        }
        if (templateStructureElement.isHtmlRef()) {
            return "<b><i>value" + this.dataIdx++ + "</i></b>";
        }
        return "value" + this.dataIdx++;
    }

    private static boolean ignoreKey(TemplateStructureElement templateStructureElement) {
        if (templateStructureElement.isExpression() || templateStructureElement.isVariableGetField() || templateStructureElement.isFunctionCall()) {
            return true;
        }
        if (templateStructureElement.isConditionalSection() && (templateStructureElement.getName().equals("true") || templateStructureElement.getName().equals("false"))) {
            return true;
        }
        String string = templateStructureElement.getName();
        return StringUtilities.isEmpty(string) || string.equals("null") || string.startsWith("$") || string.trim().startsWith("{");
    }

    private JSONObject createPath(NestedStructureDetails nestedStructureDetails) {
        Object object = this.currentJsonObject;
        TemplateStructureElement templateStructureElement = nestedStructureDetails.getRoot();
        while (templateStructureElement != null) {
            Object object2;
            String string = templateStructureElement.getName();
            Object object3 = ((JSONObject)object).opt(string);
            if (object3 == null) {
                object2 = JSONDummyDataTemplateStructureProcessor.newJSONObject();
                try {
                    ((JSONObject)object).put(string, object2);
                }
                catch (JSONException jSONException) {
                    // empty catch block
                }
                object = object2;
            } else if (object3 instanceof JSONObject) {
                object = (JSONObject)object3;
            } else if (object3 instanceof JSONArray) {
                object2 = (JSONArray)object3;
                Object object4 = ((JSONArray)object2).length() == 0 ? JSONDummyDataTemplateStructureProcessor.newJSONObject() : ((JSONArray)object2).opt(0);
                if (object4 instanceof JSONObject) {
                    object = (JSONObject)object4;
                }
            } else {
                object2 = JSONDummyDataTemplateStructureProcessor.newJSONObject();
                ((JSONObject)object).remove(string);
                try {
                    ((JSONObject)object).put(string, object2);
                    object = object2;
                }
                catch (JSONException jSONException) {
                    // empty catch block
                }
            }
            if (templateStructureElement.getSubStructures() != null && templateStructureElement.getSubStructures().size() > 0) {
                templateStructureElement = (TemplateStructureElement)templateStructureElement.getSubStructures().get(0);
                continue;
            }
            templateStructureElement = null;
        }
        return object;
    }

    private void push(JSONObject jSONObject) {
        this.currentObjectLineage.push(this.currentJsonObject);
        this.currentJsonObject = jSONObject;
    }

    private JSONObject pop() {
        this.currentJsonObject = (JSONObject)this.currentObjectLineage.pop();
        return this.currentJsonObject;
    }

    private static final String getDummyImage() {
        return "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";
    }

    private static JSONObject newJSONObject() {
        JSONObject jSONObject = new JSONObject();
        jSONObject.setPrettyPrintSortEnabled(false);
        return jSONObject;
    }
}

