/*
 * Decompiled with CFR 0.152.
 */
package com.docmosis.template.analysis.parsing;

import com.docmosis.util.DMProperties;

public class FieldParserCommon {
    public static final String PROP_NAME_BRACKETING_ENABLED = "docmosis.analyzer.field.nameBracketing.enabled";
    public static final String PROP_NAME_BRACKETING_HYPHEN_ALLOWED = "docmosis.analyzer.field.nameBracketing.hyphenAllowed";
    public static final char CHAR_DODGY_WORD_LONG_HYPHEN = '\u2013';
    public static final char CHAR_OTHER_DODGY_WORD_LONG_HYPHEN = '\u2014';

    public static boolean isHyphen(char c) {
        return c == '-' || c == '\u2013' || c == '\u2014';
    }

    public static int indexOfHyphen(String string) {
        int n = -1;
        if (string != null) {
            for (int i = 0; i < string.length(); ++i) {
                if (!FieldParserCommon.isHyphen(string.charAt(i))) continue;
                n = i;
                break;
            }
        }
        return n;
    }

    public static boolean isFieldNameBracketingEnabled() {
        return DMProperties.getBoolean(PROP_NAME_BRACKETING_ENABLED, true);
    }

    public static boolean isFieldNameBracketingHyphenAllowed() {
        return FieldParserCommon.isFieldNameBracketingEnabled() && DMProperties.getBoolean(PROP_NAME_BRACKETING_HYPHEN_ALLOWED, true);
    }

    public static String unbracket(String string) {
        int n;
        if (string.startsWith("[") && (n = string.indexOf("]")) != -1) {
            String string2 = string.substring(1, n);
            if (n < string.length() - 1) {
                string2 = string2 + string.substring(n + 1);
            }
            string = string2;
        }
        return string;
    }
}

