/*
 * Decompiled with CFR 0.152.
 */
package com.docmosis.template.analysis.openoffice.style;

import com.docmosis.template.TemplateParseException;
import com.docmosis.template.analysis.list.ListStyles;
import com.docmosis.template.analysis.openoffice.ODFContentAnalyzer;
import com.docmosis.template.analysis.openoffice.XMLComponentHandler;
import com.docmosis.template.analysis.openoffice.style.StyleRenameMapping;
import com.docmosis.template.analysis.openoffice.style.StyleRenamerPhase;
import com.docmosis.template.analysis.openoffice.style.TagStyleRenamer;
import com.docmosis.template.analysis.openoffice.style.TagStyleRenamerFactory;
import com.docmosis.util.DMProperties;
import com.docmosis.util.J;
import com.docmosis.util.StringUtilities;
import com.docmosis.util.xml.XMLIndexedTag;
import com.docmosis.util.xml.XMLIndexedTagParser;
import com.docmosis.util.xml.XMLUtilities;
import java.io.IOException;
import java.io.Writer;
import java.util.HashSet;
import java.util.Set;

public class TemplatePreProcessorStyleRenamerXMLHandler
implements XMLComponentHandler {
    private static final String N = "docmosis.analyzer.preprocessor.attributes.general.updateReferences";
    private static final String M = "docmosis.analyzer.preprocessor.attributes.general.niceDisplayNames";
    private static final Set K = TemplatePreProcessorStyleRenamerXMLHandler.getAttributesToRename();
    protected final StyleRenameMapping mapping;
    protected final String uniquerToken;
    protected final TagStyleRenamerFactory tagFactory;
    protected Writer writer;
    private StyleRenamerPhase J;
    private boolean L = DMProperties.getBoolean("docmosis.analyzer.preprocessor.attributes.general.niceDisplayNames", true);

    public TemplatePreProcessorStyleRenamerXMLHandler(StyleRenameMapping styleRenameMapping, String string, TagStyleRenamerFactory tagStyleRenamerFactory) {
        this.mapping = styleRenameMapping;
        this.uniquerToken = string;
        this.tagFactory = tagStyleRenamerFactory;
    }

    public void setWriter(Writer writer) {
        this.writer = writer;
    }

    @Override
    public void contentChunk(J j, long l, ODFContentAnalyzer.BufferedElementList bufferedElementList, ODFContentAnalyzer.BufferedElementList bufferedElementList2) throws IOException, TemplateParseException {
        if (this.writer != null) {
            j.A(this.writer);
        }
    }

    @Override
    public void tag(J j, long l, ODFContentAnalyzer.BufferedElementList bufferedElementList, ODFContentAnalyzer.BufferedElementList bufferedElementList2) throws IOException, TemplateParseException {
        TagStyleRenamer tagStyleRenamer = this.tagFactory.getProcessor(j);
        if (this.J.equals(StyleRenamerPhase.COLLECT)) {
            tagStyleRenamer.collect(j, this.mapping, this.uniquerToken);
        } else {
            this.writer.write(this.applyRenamedStyles(j.toString()));
        }
    }

    @Override
    public void finish(long l, ODFContentAnalyzer.BufferedElementList bufferedElementList) throws IOException, TemplateParseException {
    }

    @Override
    public void setSkipFinalAnalysisValidation(boolean bl) {
    }

    @Override
    public J getStylesToPromoteToStylesXml() {
        return null;
    }

    @Override
    public void setStylesToPromoteToStylesXml(J j) {
    }

    @Override
    public ListStyles getListStylesOfInterest() {
        return null;
    }

    @Override
    public void setListStylesOfInterest(ListStyles listStyles) {
    }

    public StyleRenamerPhase getRenamePhase() {
        return this.J;
    }

    public void setRenamePhase(StyleRenamerPhase styleRenamerPhase) {
        this.J = styleRenamerPhase;
    }

    private static Set getAttributesToRename() {
        HashSet<String> hashSet = new HashSet<String>();
        String[] stringArray = DMProperties.getStringArray(N, ";");
        for (int i = 0; stringArray != null && i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (hashSet.contains(string)) {
                throw new IllegalStateException(string + " is already mapped");
            }
            hashSet.add(string);
        }
        return hashSet;
    }

    protected String applyRenamedStyles(String string) throws TemplateParseException {
        TagStyleRenamer tagStyleRenamer;
        String[] stringArray = XMLUtilities.getAttributeNames(string);
        String string2 = null;
        for (int i = 0; stringArray != null && i < stringArray.length; ++i) {
            if (K.contains(stringArray[i])) {
                string = this.applyRenamedStyles(stringArray[i], string);
            }
            if (!this.L || !"style:display-name".equals(stringArray[i])) continue;
            string2 = XMLUtilities.getAttributeValue(string, "style:display-name");
        }
        if (this.L && StringUtilities.isEmpty(string2) && (tagStyleRenamer = this.tagFactory.getProcessor(string)).supportsStyleDisplayNameAttribute()) {
            string = this.setStyleDisplayNameAttribute(string);
        }
        return string;
    }

    private String setStyleDisplayNameAttribute(String string) throws TemplateParseException {
        try {
            XMLIndexedTag xMLIndexedTag = XMLIndexedTagParser.parse(new J(string), 0L);
            String string2 = xMLIndexedTag.getAttribute("style:name").getValue();
            if (string2.endsWith(this.uniquerToken)) {
                String string3 = string2.substring(0, string2.length() - this.uniquerToken.length());
                string = xMLIndexedTag.getTagReplacingAttribute("style:display-name", string3);
            }
            return string;
        }
        catch (XMLIndexedTagParser.ParseException parseException) {
            throw new TemplateParseException("Unable to set style display name", parseException);
        }
    }

    private String applyRenamedStyles(String string, String string2) {
        String string3 = null;
        String string4 = " " + string + "=\"";
        int n = string2.indexOf(string4);
        if (n != -1) {
            String string5;
            String string6;
            int n2 = n += string4.length();
            if ((n = string2.indexOf(34, n)) != -1 && !StringUtilities.isEmpty(string6 = XMLUtilities.getAttributeValue(string2, string)) && (string5 = this.mapping.get(string6)) != null) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(string2.substring(0, n2));
                stringBuffer.append(string5);
                stringBuffer.append(string2.substring(n, string2.length()));
                string3 = stringBuffer.toString();
            }
        }
        if (string3 == null) {
            string3 = string2;
        }
        return string3;
    }
}

