/*
 * Decompiled with CFR 0.152.
 */
package com.docmosis.template.analysis.openoffice.style;

import com.docmosis.template.TemplateParseException;
import com.docmosis.template.analysis.openoffice.ODFContentAnalyzer;
import com.docmosis.template.analysis.openoffice.style.StyleRenameMapping;
import com.docmosis.template.analysis.openoffice.style.StyleRenamerPhase;
import com.docmosis.template.analysis.openoffice.style.TagStyleRenamerFactory;
import com.docmosis.template.analysis.openoffice.style.TemplatePreProcessorStyleRenamerXMLHandler;
import com.docmosis.template.store.openoffice.ODFAnalyzingStore;
import com.docmosis.util.Base62Util;
import com.docmosis.util.FileUtilities;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;

public class TemplatePreProcessorStyleRenamer {
    private static final _A A = new _A();
    private final StyleRenameMapping B = new StyleRenameMapping();

    public void preProcess(ODFAnalyzingStore.ExplodedFileSet explodedFileSet) throws IOException, TemplateParseException {
        String string = TemplatePreProcessorStyleRenamer.generateUniquerToken();
        File file = explodedFileSet.getFiles()[0];
        File file2 = explodedFileSet.getFiles()[1];
        TagStyleRenamerFactory tagStyleRenamerFactory = new TagStyleRenamerFactory();
        TemplatePreProcessorStyleRenamerXMLHandler templatePreProcessorStyleRenamerXMLHandler = new TemplatePreProcessorStyleRenamerXMLHandler(this.B, string, tagStyleRenamerFactory);
        templatePreProcessorStyleRenamerXMLHandler.setRenamePhase(StyleRenamerPhase.COLLECT);
        this.process(file2, templatePreProcessorStyleRenamerXMLHandler);
        this.process(file, templatePreProcessorStyleRenamerXMLHandler);
        templatePreProcessorStyleRenamerXMLHandler.setRenamePhase(StyleRenamerPhase.RENAME);
        this.process(file2, templatePreProcessorStyleRenamerXMLHandler);
        this.process(file, templatePreProcessorStyleRenamerXMLHandler);
    }

    public String getRenamedStyle(String string) {
        return this.B.get(string);
    }

    protected static String generateUniquerToken() {
        return "DM" + Base62Util.fromBase10(A.A()) + "_" + Base62Util.fromBase10(System.currentTimeMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void process(File file, TemplatePreProcessorStyleRenamerXMLHandler templatePreProcessorStyleRenamerXMLHandler) throws IOException, TemplateParseException {
        ODFContentAnalyzer.XMLStreamReader xMLStreamReader = new ODFContentAnalyzer.XMLStreamReader();
        OutputStreamWriter outputStreamWriter = null;
        File file2 = null;
        boolean bl = templatePreProcessorStyleRenamerXMLHandler.getRenamePhase().equals(StyleRenamerPhase.RENAME);
        if (bl) {
            file2 = new File(file.getParentFile(), file.getName() + "-preproc" + Math.random() + ".xml");
            outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(file2), "UTF-8");
        }
        FileInputStream fileInputStream = null;
        try {
            templatePreProcessorStyleRenamerXMLHandler.setWriter(outputStreamWriter);
            fileInputStream = new FileInputStream(file);
            xMLStreamReader.process(fileInputStream, templatePreProcessorStyleRenamerXMLHandler);
        }
        catch (Throwable throwable) {
            FileUtilities.close(fileInputStream);
            FileUtilities.close(outputStreamWriter);
            throw throwable;
        }
        FileUtilities.close(fileInputStream);
        FileUtilities.close(outputStreamWriter);
        if (bl) {
            FileUtilities.delete(file);
            file2.renameTo(file);
        }
    }

    private static final class _A {
        private long A;

        private _A() {
        }

        public synchronized long A() {
            return this.A++;
        }
    }
}

