/*
 * Decompiled with CFR 0.152.
 */
package com.docmosis.template.analysis.openoffice.style;

import com.docmosis.template.analysis.openoffice.style.TagStyleRenamer;
import com.docmosis.template.analysis.openoffice.style.tagrenamer.FontFaceStyleTagRenamer;
import com.docmosis.template.analysis.openoffice.style.tagrenamer.MasterPageStyleTagRenamer;
import com.docmosis.template.analysis.openoffice.style.tagrenamer.NoOpTagProcessor;
import com.docmosis.template.analysis.openoffice.style.tagrenamer.PageLayoutStyleTagRenamer;
import com.docmosis.template.analysis.openoffice.style.tagrenamer.StyleStyleTagRenamer;
import com.docmosis.template.analysis.openoffice.style.tagrenamer.TextListStyleTagRenamer;
import com.docmosis.template.analysis.openoffice.style.tagrenamer.TextOutlineStyleTagRenamer;
import com.docmosis.util.J;
import java.util.HashMap;
import java.util.Map;

public class TagStyleRenamerFactory {
    private static final TagStyleRenamer A = new NoOpTagProcessor();
    private static final Map B = new HashMap();

    public TagStyleRenamer getProcessor(J j) {
        return this.getProcessorByName(this.getTagName(j));
    }

    public TagStyleRenamer getProcessor(String string) {
        return this.getProcessorByName(this.getTagName(string));
    }

    private TagStyleRenamer getProcessorByName(String string) {
        TagStyleRenamer tagStyleRenamer = (TagStyleRenamer)B.get(string);
        if (tagStyleRenamer == null) {
            tagStyleRenamer = A;
        }
        return tagStyleRenamer;
    }

    private static void register(TagStyleRenamer tagStyleRenamer) {
        if (B.containsKey(tagStyleRenamer.getTagPrefix())) {
            throw new IllegalStateException("Processor already exists for prefix \"" + tagStyleRenamer.getTagPrefix() + "\"");
        }
        B.put(tagStyleRenamer.getTagPrefix(), tagStyleRenamer);
    }

    private String getTagName(J j) {
        String string = null;
        int n = j.A(' ');
        if (n != -1) {
            string = j.A(1, n).trim();
        }
        return string;
    }

    private String getTagName(String string) {
        String string2 = null;
        int n = string.indexOf(32);
        if (n != -1) {
            string2 = string.substring(1, n).trim();
        }
        return string2;
    }

    static {
        TagStyleRenamerFactory.register(new TextListStyleTagRenamer());
        TagStyleRenamerFactory.register(new StyleStyleTagRenamer());
        TagStyleRenamerFactory.register(new MasterPageStyleTagRenamer());
        TagStyleRenamerFactory.register(new PageLayoutStyleTagRenamer());
        TagStyleRenamerFactory.register(new FontFaceStyleTagRenamer());
        TagStyleRenamerFactory.register(new TextOutlineStyleTagRenamer());
    }
}

