/*
 * Decompiled with CFR 0.152.
 */
package com.docmosis.template.analysis.openoffice.fontmapping;

import com.docmosis.template.analysis.fontmapping.FontInfo;
import com.docmosis.template.analysis.fontmapping.FontMappingUseItem;
import com.docmosis.template.analysis.openoffice.fontmapping.FontInfoExtractor;
import com.docmosis.template.analysis.openoffice.fontmapping.FontInfoExtractorException;
import com.sun.star.awt.Toolkit;
import com.sun.star.awt.XToolkit2;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class FontInfoExtractorImplementation
implements FontInfoExtractor {
    XComponentContext xComponentContext;

    public FontInfoExtractorImplementation(XComponentContext xComponentContext) {
        this.xComponentContext = xComponentContext;
    }

    @Override
    public void start() throws FontInfoExtractorException {
        try {
            XToolkit2 xToolkit2 = Toolkit.create((XComponentContext)this.xComponentContext);
            ClassLoader classLoader = FontInfoExtractorImplementation.class.getClassLoader();
            Class<?> clazz = classLoader.loadClass("com.sun.star.awt.XFontMappingUse");
            Method method = clazz.getDeclaredMethod("startTrackingFontMappingUse", new Class[0]);
            Object object = UnoRuntime.queryInterface(clazz, (Object)xToolkit2);
            method.invoke(object, new Object[0]);
        }
        catch (Exception exception) {
            throw new FontInfoExtractorException(exception);
        }
    }

    @Override
    public FontInfo stop() throws FontInfoExtractorException {
        try {
            XToolkit2 xToolkit2 = Toolkit.create((XComponentContext)this.xComponentContext);
            ClassLoader classLoader = FontInfoExtractorImplementation.class.getClassLoader();
            Class<?> clazz = classLoader.loadClass("com.sun.star.awt.XFontMappingUse");
            Method method = clazz.getDeclaredMethod("finishTrackingFontMappingUse", new Class[0]);
            Class<?> clazz2 = classLoader.loadClass("com.sun.star.awt.XFontMappingUseItem");
            Field field = clazz2.getDeclaredField("count");
            Field field2 = clazz2.getDeclaredField("originalFont");
            Field field3 = clazz2.getDeclaredField("usedFonts");
            Object object = UnoRuntime.queryInterface(clazz, (Object)xToolkit2);
            Object object2 = method.invoke(object, new Object[0]);
            if (object2 != null) {
                Object[] objectArray = (Object[])object2;
                FontMappingUseItem[] fontMappingUseItemArray = new FontMappingUseItem[objectArray.length];
                for (int i = 0; i < objectArray.length; ++i) {
                    Object obj = clazz2.cast(objectArray[i]);
                    int n = field.getInt(obj);
                    String string = (String)field2.get(obj);
                    String[] stringArray = (String[])field3.get(obj);
                    fontMappingUseItemArray[i] = new FontMappingUseItem(string, stringArray, n);
                }
                return new FontInfo(fontMappingUseItemArray);
            }
            return null;
        }
        catch (Exception exception) {
            throw new FontInfoExtractorException(exception);
        }
    }
}

