/*
 * Decompiled with CFR 0.152.
 */
package com.docmosis.template.analysis.openoffice.expression;

import com.docmosis.template.analysis.openoffice.expression.ExpressionFunctionException;
import com.docmosis.template.analysis.openoffice.expression.StringExpressionFunction;

public class ToRomanFormatFunction
implements StringExpressionFunction {
    @Override
    public String getName() {
        return "toRoman";
    }

    @Override
    public String execute(String[] stringArray) throws ExpressionFunctionException {
        if (stringArray.length != 1) {
            throw new ExpressionFunctionException("requires 1 parameter");
        }
        String string = stringArray[0];
        if (string == null || "null".equalsIgnoreCase(string) || "".equals(string)) {
            return null;
        }
        try {
            int n = (int)Double.parseDouble(string);
            return ToRomanFormatFunction.toRomanNum(n);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ExpressionFunctionException("\"" + string + "\" must be a number");
        }
        catch (NullPointerException nullPointerException) {
            throw new ExpressionFunctionException("\"" + string + "\" must be a non-null number");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ExpressionFunctionException(illegalArgumentException.getMessage());
        }
    }

    public static String toRomanNum(int n) throws IllegalArgumentException {
        StringBuffer stringBuffer = new StringBuffer();
        if (n < 1 || n > 3999) {
            throw new IllegalArgumentException("Cannot compute Roman number for value [" + n + "]");
        }
        while (n >= 1000) {
            stringBuffer.append("m");
            n -= 1000;
        }
        while (n >= 900) {
            stringBuffer.append("cm");
            n -= 900;
        }
        while (n >= 500) {
            stringBuffer.append("d");
            n -= 500;
        }
        while (n >= 400) {
            stringBuffer.append("cd");
            n -= 400;
        }
        while (n >= 100) {
            stringBuffer.append("c");
            n -= 100;
        }
        while (n >= 90) {
            stringBuffer.append("xc");
            n -= 90;
        }
        while (n >= 50) {
            stringBuffer.append("l");
            n -= 50;
        }
        while (n >= 40) {
            stringBuffer.append("xl");
            n -= 40;
        }
        while (n >= 10) {
            stringBuffer.append("x");
            n -= 10;
        }
        while (n >= 9) {
            stringBuffer.append("ix");
            n -= 9;
        }
        while (n >= 5) {
            stringBuffer.append("v");
            n -= 5;
        }
        while (n >= 4) {
            stringBuffer.append("iv");
            n -= 4;
        }
        while (n >= 1) {
            stringBuffer.append("i");
            --n;
        }
        return stringBuffer.toString();
    }
}

