/*
 * Decompiled with CFR 0.152.
 */
package com.docmosis.template.analysis.openoffice.expression;

import com.docmosis.template.analysis.openoffice.expression.ExpressionFunctionException;
import com.docmosis.template.analysis.openoffice.expression.StringExpressionFunction;

public class ToAlphaFormatFunction
implements StringExpressionFunction {
    @Override
    public String getName() {
        return "toAlpha";
    }

    @Override
    public final String execute(String[] stringArray) throws ExpressionFunctionException {
        if (stringArray.length != 1) {
            throw new ExpressionFunctionException("requires 1 parameter");
        }
        String string = stringArray[0];
        if (string == null || "null".equalsIgnoreCase(string) || "".equals(string)) {
            return null;
        }
        try {
            int n = (int)Double.parseDouble(string);
            return this.getAlphaValue(n);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ExpressionFunctionException("\"" + string + "\" must be a number");
        }
        catch (NullPointerException nullPointerException) {
            throw new ExpressionFunctionException("\"" + string + "\" must be a non-null number");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ExpressionFunctionException(illegalArgumentException.getMessage());
        }
    }

    protected String getAlphaValue(int n) {
        return ToAlphaFormatFunction.toAlpha(n);
    }

    public static String toAlpha(int n) throws IllegalArgumentException {
        if (n < 0 || n > 10000) {
            throw new IllegalArgumentException("value must be between 0 and 10000");
        }
        int n2 = (n - 1) % 26;
        int n3 = (n - 1) / 26;
        StringBuffer stringBuffer = new StringBuffer();
        char c = n2 < 0 ? (char)' ' : (char)(97 + n2);
        for (int i = 0; i <= n3; ++i) {
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        for (int i = 0; i < 1000; ++i) {
            System.out.println(i + " => [" + ToAlphaFormatFunction.toAlpha(i) + "]");
        }
    }
}

