/*
 * Decompiled with CFR 0.152.
 */
package com.docmosis.template.analysis.openoffice.expression;

import com.docmosis.template.analysis.openoffice.expression.ExpressionFunctionException;
import com.docmosis.template.analysis.openoffice.expression.StringExpressionFunction;
import com.docmosis.util.StringUtilities;

public class SplitFunction
implements StringExpressionFunction {
    @Override
    public String getName() {
        return "split";
    }

    @Override
    public String execute(String[] stringArray) throws ExpressionFunctionException {
        if (stringArray.length != 3) {
            throw new ExpressionFunctionException("requires 3 parameters");
        }
        String string = stringArray[0];
        String string2 = stringArray[1];
        String string3 = stringArray[2];
        if (string == null || "null".equals(string) || "".equals(string)) {
            return null;
        }
        if (string2 == null) {
            return string;
        }
        if (string3 == null) {
            throw new ExpressionFunctionException("parameter 3 must be a non-null integer [" + string3 + "]");
        }
        try {
            int n = (int)Double.parseDouble(string3);
            String[] stringArray2 = StringUtilities.splitNoRegex(string, string2);
            if (n < 0 || n >= stringArray2.length) {
                return null;
            }
            return stringArray2[n];
        }
        catch (NumberFormatException numberFormatException) {
            throw new ExpressionFunctionException("parameter 3 must be an integer [" + string3 + "]");
        }
    }
}

