/*
 * Decompiled with CFR 0.152.
 */
package com.docmosis.template.analysis.openoffice.expression;

import com.docmosis.template.analysis.openoffice.expression.ExpressionFunctionException;
import com.docmosis.template.analysis.openoffice.expression.StringExpressionFunction;
import java.math.BigDecimal;
import java.math.RoundingMode;
import net.sourceforge.jeval.com.docmosis.ExtendedBigDecimal;

public class RoundFunction
implements StringExpressionFunction {
    @Override
    public String getName() {
        return "round";
    }

    @Override
    public String execute(String[] stringArray) throws ExpressionFunctionException {
        ExtendedBigDecimal extendedBigDecimal;
        if (stringArray.length < 1 || stringArray.length > 2) {
            throw new ExpressionFunctionException("requires 1 or 2 parameters");
        }
        if (stringArray[0] == null || "null".equals(stringArray[0]) || "".equals(stringArray[0])) {
            return null;
        }
        int n = 0;
        if (stringArray.length == 2) {
            try {
                n = (int)Double.parseDouble(stringArray[1]);
            }
            catch (NullPointerException nullPointerException) {
                throw new ExpressionFunctionException("precision must be a non-null integer:[" + stringArray[1] + "]", nullPointerException);
            }
            catch (NumberFormatException numberFormatException) {
                throw new ExpressionFunctionException("precision must be an integer:[" + stringArray[1] + "]", numberFormatException);
            }
        }
        try {
            extendedBigDecimal = ExtendedBigDecimal.valueOf(stringArray[0]);
        }
        catch (Exception exception) {
            throw new ExpressionFunctionException("value must be numeric:[" + stringArray[0] + "]", exception);
        }
        String string = RoundFunction.round(extendedBigDecimal, n);
        return string;
    }

    static String round(ExtendedBigDecimal extendedBigDecimal, int n) {
        BigDecimal bigDecimal = null;
        ExtendedBigDecimal extendedBigDecimal2 = null;
        bigDecimal = extendedBigDecimal.isNaN() ? BigDecimal.ZERO : (extendedBigDecimal.isPositiveInfinity() ? new BigDecimal(Long.MAX_VALUE) : (extendedBigDecimal.isNegativeInfinity() ? new BigDecimal(Long.MIN_VALUE) : extendedBigDecimal.getBigDecimal()));
        extendedBigDecimal2 = new ExtendedBigDecimal(bigDecimal.setScale(n, RoundingMode.HALF_UP), false);
        return extendedBigDecimal2.toString();
    }
}

