/*
 * Decompiled with CFR 0.152.
 */
package com.docmosis.template.analysis.openoffice.expression;

import com.docmosis.template.analysis.openoffice.expression.ExpressionFunctionException;
import com.docmosis.template.analysis.openoffice.expression.NumToTextFunction;
import com.docmosis.template.analysis.openoffice.expression.StringExpressionFunction;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;

public class OrdinalFunction
implements StringExpressionFunction {
    @Override
    public String getName() {
        return "ordinal";
    }

    @Override
    public final String execute(String[] stringArray) throws ExpressionFunctionException {
        OrdinalFormat ordinalFormat;
        if (stringArray.length != 1 && stringArray.length != 2) {
            throw new ExpressionFunctionException("requires 1 or 2 parameters");
        }
        String string = stringArray[0];
        if (string == null || "null".equalsIgnoreCase(string) || "".equals(string)) {
            return null;
        }
        String string2 = stringArray.length == 2 ? stringArray[1] : null;
        OrdinalFormat ordinalFormat2 = ordinalFormat = string2 == null ? OrdinalFormat.SHORT : OrdinalFormat.valueOf(string2);
        if (ordinalFormat == null) {
            throw new ExpressionFunctionException("format \"" + string2 + "\" is not valid.  Valid formats:" + OrdinalFormat.getFormats());
        }
        try {
            BigDecimal bigDecimal = new BigDecimal(string);
            return ordinalFormat.map(bigDecimal);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ExpressionFunctionException("\"" + string + "\" must be a number");
        }
        catch (NullPointerException nullPointerException) {
            throw new ExpressionFunctionException("\"" + string + "\" must be a non-null number");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ExpressionFunctionException(illegalArgumentException.getMessage());
        }
    }

    public static String getOrdinal(BigDecimal bigDecimal, OrdinalFormat ordinalFormat) {
        return ordinalFormat.map(bigDecimal);
    }

    public static abstract class OrdinalFormat {
        private static String B = "";
        private static Map A = new HashMap();
        public static OrdinalFormat SHORT = new OrdinalFormat("short"){

            @Override
            public String map(BigDecimal bigDecimal) {
                return bigDecimal.longValue() + SUFFIX.map(bigDecimal);
            }
        };
        public static OrdinalFormat LONG = new OrdinalFormat("long"){

            @Override
            public String map(BigDecimal bigDecimal) {
                return NumToTextFunction.format(bigDecimal, NumToTextFunction.WordingFormat.AS_ORDINAL, NumToTextFunction.AndFormat.LAST_TERM_ONLY);
            }
        };
        public static OrdinalFormat LONG_ALL_ANDS = new OrdinalFormat("longAllAnds"){

            @Override
            public String map(BigDecimal bigDecimal) {
                return NumToTextFunction.format(bigDecimal, NumToTextFunction.WordingFormat.AS_ORDINAL, NumToTextFunction.AndFormat.ALWAYS);
            }
        };
        public static OrdinalFormat LONG_NO_ANDS = new OrdinalFormat("longNoAnds"){

            @Override
            public String map(BigDecimal bigDecimal) {
                return NumToTextFunction.format(bigDecimal, NumToTextFunction.WordingFormat.AS_ORDINAL, NumToTextFunction.AndFormat.NONE);
            }
        };
        public static OrdinalFormat SUFFIX = new OrdinalFormat("suffix"){

            @Override
            public String map(BigDecimal bigDecimal) {
                int n;
                long l = bigDecimal.longValue();
                if (l < 0L) {
                    l = -l;
                }
                String string = l >= 11L && l <= 13L ? "th" : ((n = (int)(l % 10L)) == 1 ? "st" : (n == 2 ? "nd" : (n == 3 ? "rd" : "th")));
                return string;
            }
        };

        private OrdinalFormat(String string) {
            A.put(string, this);
            if (B.length() > 0) {
                B = B + ", ";
            }
            B = B + string;
        }

        public abstract String map(BigDecimal var1);

        public static OrdinalFormat valueOf(String string) {
            return (OrdinalFormat)A.get(string);
        }

        public static String getFormats() {
            return B;
        }
    }
}

