/*
 * Decompiled with CFR 0.152.
 */
package com.docmosis.template.analysis.openoffice.expression;

import com.docmosis.template.analysis.openoffice.expression.ExpressionFunctionException;
import com.docmosis.template.analysis.openoffice.expression.StringExpressionFunction;
import com.docmosis.util.StringUtilities;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class NumToTextFunction
implements StringExpressionFunction {
    public static final String[] UNITS = new String[]{"", "one", "two", "three", "four", "five", "six", "seven", "eight", "nine", "ten", "eleven", "twelve", "thirteen", "fourteen", "fifteen", "sixteen", "seventeen", "eighteen", "nineteen"};
    public static final String[] UNITS_ORDINAL = new String[]{"", "first", "second", "third", "fourth", "fifth", "sixth", "seventh", "eighth", "nineth", "tenth", "eleventh", "twelfth", "thirteenth", "fourteenth", "fifteenth", "sixteenth", "seventeenth", "eighteenth", "nineteenth"};
    public static final String[] TENS = new String[]{"", "", "twenty", "thirty", "forty", "fifty", "sixty", "seventy", "eighty", "ninety"};
    public static final String[] TENS_ORDINAL = new String[]{"", "", "twentieth", "thirtieth", "fortieth", "fiftieth", "sixtieth", "seventieth", "eightieth", "ninetieth"};

    @Override
    public String getName() {
        return "numToText";
    }

    @Override
    public final String execute(String[] stringArray) throws ExpressionFunctionException {
        AndFormat andFormat;
        if (stringArray.length != 1 && stringArray.length != 2) {
            throw new ExpressionFunctionException("requires 1 or 2 parameters");
        }
        String string = stringArray[0];
        if (string == null || "null".equalsIgnoreCase(string) || "".equals(string)) {
            return null;
        }
        String string2 = stringArray.length == 2 ? stringArray[1] : null;
        AndFormat andFormat2 = andFormat = string2 == null ? AndFormat.LAST_TERM_ONLY : AndFormat.valueOf(string2);
        if (andFormat == null) {
            throw new ExpressionFunctionException("format \"" + string2 + "\" is not valid.  Valid formats:" + AndFormat.getFormats());
        }
        try {
            return NumToTextFunction.format(string, WordingFormat.AS_TEXT, andFormat);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ExpressionFunctionException("\"" + string + "\" must be a number");
        }
        catch (NullPointerException nullPointerException) {
            throw new ExpressionFunctionException("\"" + string + "\" must be a non-null number");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ExpressionFunctionException(illegalArgumentException.getMessage());
        }
    }

    public static String format(String string, WordingFormat wordingFormat, AndFormat andFormat) throws NumberFormatException {
        BigDecimal bigDecimal = new BigDecimal(string);
        return NumToTextFunction.format(bigDecimal, wordingFormat, andFormat);
    }

    public static String format(BigDecimal bigDecimal, WordingFormat wordingFormat, AndFormat andFormat) throws NumberFormatException {
        long l = bigDecimal.longValue();
        if (l < 0L) {
            return "minus " + NumToTextFunction.format(bigDecimal.negate(), wordingFormat, andFormat);
        }
        if (l == 0L) {
            return wordingFormat.isOrdinal() ? "zeroth" : "zero";
        }
        StringBuffer stringBuffer = new StringBuffer();
        List list = NumToTextFunction.getUnitGroups(l);
        int n = list.size();
        _A _A2 = null;
        for (int i = 0; i < n; ++i) {
            _A _A3 = (_A)list.get(i);
            if (_A3.A()) continue;
            _A3.A(stringBuffer, wordingFormat.isOrdinal(), andFormat);
            _A2 = _A3;
        }
        if (wordingFormat.isOrdinal() && _A2 != null && !StringUtilities.isEmpty(_A2.D)) {
            stringBuffer.append("th");
        } else if (WordingFormat.AS_DOLLARS.equals(wordingFormat)) {
            if (l == 1L) {
                stringBuffer.append(" dollar");
            } else {
                stringBuffer.append(" dollars");
            }
        }
        if (!wordingFormat.isOrdinal() && bigDecimal.scale() > 0) {
            try {
                String string = NumToTextFunction.getValueAfterDecimal(bigDecimal);
                long l2 = Long.valueOf(string);
                if (l2 > 0L) {
                    if (WordingFormat.AS_DOLLARS.equals(wordingFormat)) {
                        stringBuffer.append(" and ").append(NumToTextFunction.format(new BigDecimal(l2), WordingFormat.AS_TEXT, AndFormat.NONE)).append(" cents");
                    } else {
                        stringBuffer.append(" point ").append(NumToTextFunction.digitsToWords(string));
                    }
                }
            }
            catch (RuntimeException runtimeException) {
                throw new NumberFormatException(runtimeException.getMessage());
            }
        }
        return stringBuffer.toString();
    }

    public static String getValueAfterDecimal(BigDecimal bigDecimal) {
        return bigDecimal.toString().substring(bigDecimal.toString().indexOf(46) + 1);
    }

    public static String digitsToWords(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(' ');
            }
            stringBuffer.append(NumToTextFunction.digitToWord(string.charAt(i)));
        }
        return stringBuffer.toString();
    }

    public static String digitToWord(char c) {
        if (c == '0') {
            return "zero";
        }
        return UNITS[Integer.valueOf(c + "")];
    }

    public static void main(String[] stringArray) {
        long l = Long.MAX_VALUE;
        l = 999001L;
        WordingFormat wordingFormat = WordingFormat.AS_ORDINAL;
        String string = NumToTextFunction.format(new BigDecimal(l), wordingFormat, AndFormat.ALWAYS);
        System.err.println("[" + string + "]");
    }

    private static List getUnitGroups(long l) {
        String[] stringArray = new String[]{"", "thousand", "million", "billion", "trillion", "quadrillion", "quintillion"};
        ArrayList<_A> arrayList = new ArrayList<_A>();
        while (l > 0L) {
            _A _A2 = new _A((int)(l % 1000L), stringArray[arrayList.size()]);
            arrayList.add(_A2);
            l /= 1000L;
        }
        boolean bl = false;
        for (_A _A3 : arrayList) {
            if (_A3.A()) continue;
            bl = true;
            _A3.A(true);
            break;
        }
        if (!bl) {
            ((_A)arrayList.get(0)).A(true);
        }
        Collections.reverse(arrayList);
        return arrayList;
    }

    private static class _A {
        public final int C;
        public final int B;
        public final int A;
        public final String D;
        public boolean E;

        public _A(int n, String string) {
            if (n >= 1000) {
                throw new RuntimeException("Unit Group must be smaller than 1000");
            }
            this.A = n / 100;
            this.B = (n %= 100) / 10;
            this.C = n %= 10;
            this.D = string;
        }

        public void A(boolean bl) {
            this.E = bl;
        }

        public void A(StringBuffer stringBuffer, boolean bl, AndFormat andFormat) {
            boolean bl2;
            boolean bl3 = StringUtilities.isEmpty(this.D);
            StringBuffer stringBuffer2 = new StringBuffer();
            boolean bl4 = bl2 = this.A != 0;
            if (bl2) {
                String string = " hundred";
                stringBuffer2.append(UNITS[this.A]);
                if (this.B == 0 && this.C == 0) {
                    stringBuffer2.append(" hundred").append(bl3 && bl ? "th" : "");
                } else {
                    stringBuffer2.append(" hundred");
                }
            }
            if (this.B != 0) {
                int n = this.B * 10 + this.C;
                if (n < 20) {
                    if (bl2 || this.E && stringBuffer.length() > 0) {
                        andFormat.addAnd(stringBuffer2, this.E);
                    }
                    if (stringBuffer2.length() > 0) {
                        stringBuffer2.append(' ');
                    }
                    stringBuffer2.append(bl3 && bl ? UNITS_ORDINAL[n] : UNITS[n]);
                } else if (this.C == 0) {
                    if (bl2 || this.E && stringBuffer.length() > 0) {
                        andFormat.addAnd(stringBuffer2, this.E);
                    }
                    if (stringBuffer2.length() > 0) {
                        stringBuffer2.append(' ');
                    }
                    stringBuffer2.append(bl3 && bl ? TENS_ORDINAL[this.B] : TENS[this.B]);
                } else {
                    if (bl2 || this.E && stringBuffer.length() > 0) {
                        andFormat.addAnd(stringBuffer2, this.E);
                    }
                    if (stringBuffer2.length() > 0) {
                        stringBuffer2.append(' ');
                    }
                    stringBuffer2.append(TENS[this.B]);
                    if (stringBuffer2.length() > 0) {
                        stringBuffer2.append(' ');
                    }
                    stringBuffer2.append(bl3 && bl ? UNITS_ORDINAL[this.C] : UNITS[this.C]);
                }
            } else if (this.C != 0) {
                if (bl2 || this.E && stringBuffer.length() > 0) {
                    andFormat.addAnd(stringBuffer2, this.E);
                }
                if (stringBuffer2.length() > 0) {
                    stringBuffer2.append(' ');
                }
                stringBuffer2.append(bl3 && bl ? UNITS_ORDINAL[this.C] : UNITS[this.C]);
            }
            if (!StringUtilities.isEmpty(this.D)) {
                stringBuffer2.append(' ').append(this.D);
            }
            if (stringBuffer2.length() > 0) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(' ');
                }
                stringBuffer.append(stringBuffer2);
            }
        }

        public boolean A() {
            return this.C == 0 && this.B == 0 && this.A == 0;
        }

        public String toString() {
            return String.valueOf(this.A * 100 + this.B * 10 + this.C + (StringUtilities.isEmpty(this.D) ? "" : " " + this.D));
        }
    }

    static abstract class AndFormat {
        private static String B = "";
        private static Map A = new HashMap();
        public static final AndFormat NONE = new AndFormat("andNone"){

            @Override
            protected void addAnd(StringBuffer stringBuffer, boolean bl) {
            }
        };
        public static final AndFormat ALWAYS = new AndFormat("andAlways"){

            @Override
            protected void addAnd(StringBuffer stringBuffer, boolean bl) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(' ');
                }
                stringBuffer.append("and");
            }
        };
        public static final AndFormat LAST_TERM_ONLY = new AndFormat("andLast"){

            @Override
            protected void addAnd(StringBuffer stringBuffer, boolean bl) {
                if (bl) {
                    ALWAYS.addAnd(stringBuffer, bl);
                }
            }
        };

        public AndFormat(String string) {
            A.put(string, this);
            if (B.length() > 0) {
                B = B + ", ";
            }
            B = B + string;
        }

        protected abstract void addAnd(StringBuffer var1, boolean var2);

        public static AndFormat valueOf(String string) {
            return (AndFormat)A.get(string);
        }

        public static String getFormats() {
            return B;
        }
    }

    public static class WordingFormat {
        public static WordingFormat AS_TEXT = new WordingFormat("text", false);
        public static WordingFormat AS_ORDINAL = new WordingFormat("ordinal", true);
        public static WordingFormat AS_DOLLARS = new WordingFormat("dollars", false);
        private final String B;
        private final boolean A;

        private WordingFormat(String string, boolean bl) {
            this.B = string;
            this.A = bl;
        }

        public boolean isOrdinal() {
            return this.A;
        }

        public int hashCode() {
            int n = 31;
            int n2 = 1;
            n2 = 31 * n2 + (this.B == null ? 0 : this.B.hashCode());
            return n2;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            WordingFormat wordingFormat = (WordingFormat)object;
            return !(this.B == null ? wordingFormat.B != null : !this.B.equals(wordingFormat.B));
        }
    }
}

