/*
 * Decompiled with CFR 0.152.
 */
package com.docmosis.template.analysis.openoffice.expression;

import com.docmosis.template.analysis.openoffice.expression.ExpressionFunctionException;
import com.docmosis.template.analysis.openoffice.expression.NumToTextFunction;
import com.docmosis.template.analysis.openoffice.expression.StringExpressionFunction;
import java.math.BigDecimal;

public class NumToDollarsFunction
implements StringExpressionFunction {
    @Override
    public String getName() {
        return "numToDollars";
    }

    @Override
    public final String execute(String[] stringArray) throws ExpressionFunctionException {
        if (stringArray.length != 1) {
            throw new ExpressionFunctionException("requires 1 parameter");
        }
        String string = stringArray[0];
        if (string == null || "null".equalsIgnoreCase(string) || "".equals(string)) {
            return null;
        }
        try {
            string = NumToDollarsFunction.cleanseDollarSymbol(string);
            BigDecimal bigDecimal = new BigDecimal(string).setScale(2, 6);
            long l = Long.valueOf(NumToTextFunction.getValueAfterDecimal(bigDecimal));
            NumToTextFunction.AndFormat andFormat = l == 0L ? NumToTextFunction.AndFormat.LAST_TERM_ONLY : NumToTextFunction.AndFormat.NONE;
            return NumToTextFunction.format(bigDecimal, NumToTextFunction.WordingFormat.AS_DOLLARS, andFormat);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ExpressionFunctionException("\"" + string + "\" must be a number");
        }
        catch (NullPointerException nullPointerException) {
            throw new ExpressionFunctionException("\"" + string + "\" must be a non-null number");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ExpressionFunctionException(illegalArgumentException.getMessage());
        }
    }

    private static String cleanseDollarSymbol(String string) {
        return string.replaceAll("\\$", "");
    }
}

