/*
 * Decompiled with CFR 0.152.
 */
package com.docmosis.template.analysis.openoffice.expression;

import com.docmosis.template.analysis.openoffice.expression.ExpressionFunctionException;
import com.docmosis.template.analysis.openoffice.expression.StringExpressionFunction;
import com.docmosis.template.population.render.NumberRendererUtil;
import com.docmosis.util.locale.LocaleUtils;

public class NumFormatFunction
implements StringExpressionFunction {
    @Override
    public String getName() {
        return "numFormat";
    }

    @Override
    public String execute(String[] stringArray) throws ExpressionFunctionException {
        boolean bl;
        if (stringArray.length < 2 || stringArray.length > 5) {
            throw new ExpressionFunctionException("requires 2 to 5 parameters");
        }
        String string = stringArray[0];
        String string2 = stringArray[1];
        String string3 = stringArray.length > 2 ? stringArray[2] : null;
        boolean bl2 = stringArray.length > 3 ? Boolean.valueOf(stringArray[3]) : true;
        boolean bl3 = bl = stringArray.length > 4 ? Boolean.valueOf(stringArray[4]) : true;
        if (string == null || "null".equals(string) || "".equals(string)) {
            return null;
        }
        if (string2 == null) {
            return string;
        }
        try {
            return NumberRendererUtil.format(string, string2, string3, bl2, bl);
        }
        catch (LocaleUtils.UnknownLocaleException unknownLocaleException) {
            throw new ExpressionFunctionException(unknownLocaleException.getMessage());
        }
        catch (NumberRendererUtil.BadValueException badValueException) {
            throw new ExpressionFunctionException(badValueException.getMessage());
        }
    }
}

