/*
 * Decompiled with CFR 0.152.
 */
package com.docmosis.template.analysis.openoffice.expression;

import com.docmosis.template.analysis.openoffice.expression.ExpressionFunctionException;
import com.docmosis.template.analysis.openoffice.expression.StringExpressionFunction;
import com.docmosis.util.locale.LocaleUtils;
import java.text.SimpleDateFormat;
import java.util.Locale;

public class LocaleDatePatternFunction
implements StringExpressionFunction {
    @Override
    public String getName() {
        return "localeDatePattern";
    }

    @Override
    public String execute(String[] stringArray) throws ExpressionFunctionException {
        if (stringArray.length < 1 || stringArray.length > 2) {
            throw new ExpressionFunctionException("requires 1 or 2 parameters");
        }
        if (stringArray[0] == null || "null".equals(stringArray[0]) || "".equals(stringArray[0])) {
            throw new ExpressionFunctionException("parameter 1 must be a pattern");
        }
        String string = stringArray[0];
        String string2 = stringArray.length < 2 || stringArray[1] == null || "null".equals(stringArray[1]) || "".equals(stringArray[1]) ? null : stringArray[1];
        try {
            Locale locale = string2 == null ? Locale.getDefault() : LocaleUtils.localeStringToLocale(string2);
            return new SimpleDateFormat(string, locale).toLocalizedPattern();
        }
        catch (LocaleUtils.UnknownLocaleException unknownLocaleException) {
            throw new ExpressionFunctionException("Cannot get Locale for " + unknownLocaleException.getMessage());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ExpressionFunctionException("Bad pattern [" + string + "] for locale [" + string2 + "]");
        }
    }
}

