/*
 * Decompiled with CFR 0.152.
 */
package com.docmosis.template.analysis.openoffice.expression;

import com.docmosis.template.analysis.openoffice.expression.ExpressionFunction;
import com.docmosis.template.analysis.openoffice.expression.ExpressionFunctionException;
import com.docmosis.template.analysis.openoffice.expression.ExtendedBigDecimalExpressionFunction;
import com.docmosis.template.analysis.openoffice.expression.StringExpressionFunction;
import com.docmosis.util.DMProperties;
import com.docmosis.util.logging.LogManager;
import com.docmosis.util.logging.Logger;
import net.sourceforge.jeval.com.docmosis.Evaluator;
import net.sourceforge.jeval.com.docmosis.function.Function;
import net.sourceforge.jeval.com.docmosis.function.FunctionException;
import net.sourceforge.jeval.com.docmosis.function.FunctionHelper;
import net.sourceforge.jeval.com.docmosis.function.FunctionResult;

public class ExpressionFunctionAdapter
implements Function {
    private static final Logger D = LogManager.getLogger(ExpressionFunctionAdapter.class);
    private static final String F = "docmosis.populator.functions.errors.logWarnings";
    private final ExpressionFunction E;
    private final Evaluator H;
    private final boolean G = DMProperties.getBoolean("docmosis.populator.functions.errors.logWarnings", false);

    public ExpressionFunctionAdapter(ExpressionFunction expressionFunction, Evaluator evaluator) {
        this.E = expressionFunction;
        this.H = evaluator;
    }

    @Override
    public String getName() {
        return this.E.getName();
    }

    @Override
    public FunctionResult execute(Evaluator evaluator, String[] stringArray) throws FunctionException {
        try {
            FunctionResult functionResult = null;
            functionResult = this.E instanceof StringExpressionFunction ? new FunctionResult(((StringExpressionFunction)this.E).execute(this.prepareParams(stringArray))) : new FunctionResult(((ExtendedBigDecimalExpressionFunction)this.E).execute(this.prepareParams(stringArray)));
            return functionResult;
        }
        catch (FunctionException functionException) {
            if (this.G) {
                D.warn("Error executing function [" + this.getName() + "]", functionException);
            }
            throw new FunctionException(functionException.getMessage());
        }
        catch (ExpressionFunctionException expressionFunctionException) {
            if (this.G) {
                D.warn("Error executing function [" + this.getName() + "]", expressionFunctionException);
            }
            throw new FunctionException(expressionFunctionException.getMessage(), expressionFunctionException, expressionFunctionException.isIntentional());
        }
    }

    private final String[] prepareParams(String[] stringArray) throws FunctionException {
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] == null) continue;
            stringArray[i] = FunctionHelper.trimAndRemoveQuoteChars(stringArray[i], this.H.getQuoteCharacter(), false);
        }
        return stringArray;
    }
}

