/*
 * Decompiled with CFR 0.152.
 */
package com.docmosis.template.analysis.openoffice.expression;

import com.docmosis.template.TemplateParseException;
import com.docmosis.template.analysis.ParsedField;
import com.docmosis.template.analysis.openoffice.FieldParser;
import com.docmosis.template.analysis.openoffice.expression.CharFunction;
import com.docmosis.template.analysis.openoffice.expression.CountStringFunction;
import com.docmosis.template.analysis.openoffice.expression.DateAddFunction;
import com.docmosis.template.analysis.openoffice.expression.DateDiffFunction;
import com.docmosis.template.analysis.openoffice.expression.DateFormatFunction;
import com.docmosis.template.analysis.openoffice.expression.ExpressionFunctionAdapter;
import com.docmosis.template.analysis.openoffice.expression.FailFunction;
import com.docmosis.template.analysis.openoffice.expression.IfBlankFunction;
import com.docmosis.template.analysis.openoffice.expression.IsBlankFunction;
import com.docmosis.template.analysis.openoffice.expression.IsNumberFunction;
import com.docmosis.template.analysis.openoffice.expression.LeftFunction;
import com.docmosis.template.analysis.openoffice.expression.LocaleDatePatternFunction;
import com.docmosis.template.analysis.openoffice.expression.LocaleFunction;
import com.docmosis.template.analysis.openoffice.expression.LocaleInfoFunction;
import com.docmosis.template.analysis.openoffice.expression.MapFunction;
import com.docmosis.template.analysis.openoffice.expression.MapiFunction;
import com.docmosis.template.analysis.openoffice.expression.NumFormatFunction;
import com.docmosis.template.analysis.openoffice.expression.NumToDollarsFunction;
import com.docmosis.template.analysis.openoffice.expression.NumToTextFunction;
import com.docmosis.template.analysis.openoffice.expression.OrdinalFunction;
import com.docmosis.template.analysis.openoffice.expression.ReplaceFirstFunction;
import com.docmosis.template.analysis.openoffice.expression.ReplaceStringFunction;
import com.docmosis.template.analysis.openoffice.expression.RightFunction;
import com.docmosis.template.analysis.openoffice.expression.RoundFunction;
import com.docmosis.template.analysis.openoffice.expression.SQuoteFunction;
import com.docmosis.template.analysis.openoffice.expression.SentenceCaseFunction;
import com.docmosis.template.analysis.openoffice.expression.SplitFunction;
import com.docmosis.template.analysis.openoffice.expression.TitleCaseFunction;
import com.docmosis.template.analysis.openoffice.expression.ToAlpha2FormatFunction;
import com.docmosis.template.analysis.openoffice.expression.ToAlphaFormatFunction;
import com.docmosis.template.analysis.openoffice.expression.ToRomanFormatFunction;
import com.docmosis.template.analysis.parsing.FieldParserCommon;
import com.docmosis.template.population.openoffice.ContentStreamPopulatorObfImpl;
import com.docmosis.template.population.openoffice.PopulationContext;
import java.io.IOException;
import net.sourceforge.jeval.com.docmosis.EvaluationException;
import net.sourceforge.jeval.com.docmosis.Evaluator;
import net.sourceforge.jeval.com.docmosis.FieldParserSettings;
import net.sourceforge.jeval.com.docmosis.FunctionResolver;
import net.sourceforge.jeval.com.docmosis.VariableResolver;
import net.sourceforge.jeval.com.docmosis.function.Function;
import net.sourceforge.jeval.com.docmosis.function.FunctionException;
import net.sourceforge.jeval.com.docmosis.function.FunctionResult;

public class DocmosisExpression {
    private final Evaluator A = DocmosisExpression.constructStandardEvaluator(false);

    public DocmosisExpression(PopulationContext populationContext, ContentStreamPopulatorObfImpl contentStreamPopulatorObfImpl) {
        this.A.setVariableResolver(new _A(populationContext, this.A, contentStreamPopulatorObfImpl));
        this.A.setFunctionResolver(new DynamicFunctionResolver(populationContext, this.A, contentStreamPopulatorObfImpl));
    }

    public static Evaluator constructStandardEvaluator() {
        return DocmosisExpression.constructStandardEvaluator(false);
    }

    public static Evaluator constructStandardEvaluator(final boolean bl) {
        Evaluator evaluator = new Evaluator();
        evaluator.putFunction(new ExpressionFunctionAdapter(new MapFunction(), evaluator));
        evaluator.putFunction(new ExpressionFunctionAdapter(new MapiFunction(), evaluator));
        evaluator.putFunction(new ExpressionFunctionAdapter(new RoundFunction(), evaluator));
        evaluator.putFunction(new ExpressionFunctionAdapter(new TitleCaseFunction(), evaluator));
        evaluator.putFunction(new ExpressionFunctionAdapter(new SplitFunction(), evaluator));
        evaluator.putFunction(new ExpressionFunctionAdapter(new NumFormatFunction(), evaluator));
        evaluator.putFunction(new ExpressionFunctionAdapter(new DateFormatFunction(), evaluator));
        evaluator.putFunction(new ExpressionFunctionAdapter(new DateAddFunction(), evaluator));
        evaluator.putFunction(new ExpressionFunctionAdapter(new DateDiffFunction(), evaluator));
        evaluator.putFunction(new ExpressionFunctionAdapter(new ToRomanFormatFunction(), evaluator));
        evaluator.putFunction(new ExpressionFunctionAdapter(new ToAlphaFormatFunction(), evaluator));
        evaluator.putFunction(new ExpressionFunctionAdapter(new ToAlpha2FormatFunction(), evaluator));
        evaluator.putFunction(new ExpressionFunctionAdapter(new SentenceCaseFunction(), evaluator));
        evaluator.putFunction(new ExpressionFunctionAdapter(new IsBlankFunction(), evaluator));
        evaluator.putFunction(new ExpressionFunctionAdapter(new IfBlankFunction(), evaluator));
        evaluator.putFunction(new ExpressionFunctionAdapter(new SQuoteFunction(), evaluator));
        evaluator.putFunction(new ExpressionFunctionAdapter(new ReplaceStringFunction(), evaluator));
        evaluator.putFunction(new ExpressionFunctionAdapter(new ReplaceFirstFunction(), evaluator));
        evaluator.putFunction(new ExpressionFunctionAdapter(new OrdinalFunction(), evaluator));
        evaluator.putFunction(new ExpressionFunctionAdapter(new NumToTextFunction(), evaluator));
        evaluator.putFunction(new ExpressionFunctionAdapter(new NumToDollarsFunction(), evaluator));
        evaluator.putFunction(new ExpressionFunctionAdapter(new IsNumberFunction(), evaluator));
        evaluator.putFunction(new ExpressionFunctionAdapter(new LocaleFunction(), evaluator));
        evaluator.putFunction(new ExpressionFunctionAdapter(new LocaleInfoFunction(), evaluator));
        evaluator.putFunction(new ExpressionFunctionAdapter(new LocaleDatePatternFunction(), evaluator));
        evaluator.putFunction(new ExpressionFunctionAdapter(new CharFunction(), evaluator));
        evaluator.putFunction(new ExpressionFunctionAdapter(new LeftFunction(), evaluator));
        evaluator.putFunction(new ExpressionFunctionAdapter(new RightFunction(), evaluator));
        evaluator.putFunction(new ExpressionFunctionAdapter(new CountStringFunction(), evaluator));
        evaluator.putFunction(new ExpressionFunctionAdapter(new FailFunction(), evaluator));
        evaluator.setFieldParserSettings(new FieldParserSettings(){

            @Override
            public String unbracket(String string) {
                return FieldParserCommon.unbracket(string);
            }

            @Override
            public boolean isHyphenated(String string) {
                return FieldParserCommon.indexOfHyphen(string) != -1;
            }

            @Override
            public boolean bracketedHyphenatedFieldNameEnabled() {
                return FieldParserCommon.isFieldNameBracketingHyphenAllowed();
            }

            @Override
            public boolean bracketedFieldNamesEnabled() {
                return FieldParserCommon.isFieldNameBracketingEnabled();
            }

            @Override
            public boolean forgivingParseMode() {
                return bl;
            }
        });
        return evaluator;
    }

    public static Evaluator constructParsingEvaluator() {
        Evaluator evaluator = DocmosisExpression.constructStandardEvaluator(false);
        evaluator.setFunctionResolver(new DummyFunctionResolver());
        return evaluator;
    }

    public boolean evaluateBoolean(String string) throws TemplateParseException {
        String string2 = this.evaluate(string);
        return DocmosisExpression.evaluateBooleanValue(string2);
    }

    public static boolean evaluateBooleanValue(String string) {
        return "1.0".equals(string) || Boolean.valueOf(string) != false;
    }

    public String evaluate(String string) throws TemplateParseException {
        try {
            return this.A.evaluate(string, false, true);
        }
        catch (EvaluationException evaluationException) {
            throw new TemplateParseException(evaluationException.getMessage(), evaluationException.isAssertionFailure());
        }
    }

    public String resolveVariable(String string, boolean bl) throws TemplateParseException {
        try {
            String string2 = this.A.getVariableResolver().resolveVariable(string);
            if (bl && string2 != null && string2.length() > 1) {
                char c = this.A.getQuoteCharacter();
                if (string2.charAt(0) == c && string2.charAt(string2.length() - 1) == c) {
                    string2 = string2.substring(1, string2.length() - 1);
                }
            }
            return string2;
        }
        catch (FunctionException functionException) {
            throw new TemplateParseException(functionException.getMessage());
        }
    }

    private static ParsedField getNameTermsFromKey(String string) throws FunctionException {
        try {
            return FieldParser.parse(string);
        }
        catch (TemplateParseException templateParseException) {
            throw new FunctionException(templateParseException);
        }
    }

    private static String quoteIfNotLiteral(String string, Evaluator evaluator) {
        if ("true".equals(string) || "false".equals(string)) {
            return string;
        }
        return evaluator.getQuoteCharacter() + string + evaluator.getQuoteCharacter();
    }

    public static class DynamicFunction
    implements Function {
        private final String C;
        private final PopulationContext A;
        private final ContentStreamPopulatorObfImpl B;

        public DynamicFunction(String string, PopulationContext populationContext, ContentStreamPopulatorObfImpl contentStreamPopulatorObfImpl) {
            this.C = string;
            this.A = populationContext;
            this.B = contentStreamPopulatorObfImpl;
        }

        @Override
        public String getName() {
            return this.C;
        }

        @Override
        public FunctionResult execute(Evaluator evaluator, String[] stringArray) throws FunctionException {
            try {
                StringBuffer stringBuffer = new StringBuffer();
                for (int i = 0; i < stringArray.length; ++i) {
                    if (i > 0) {
                        stringBuffer.append(",");
                    }
                    stringBuffer.append(stringArray[i]);
                }
                ParsedField.NameTerm[] nameTermArray = DocmosisExpression.getNameTermsFromKey(this.C + "(" + stringBuffer.toString() + ")").getTerms();
                Object object = this.B.A(false, null, nameTermArray, this.A, this.B.b, 0, null);
                String string = null;
                if (object != null) {
                    string = String.valueOf(object);
                }
                return new FunctionResult(string);
            }
            catch (IOException iOException) {
                throw new FunctionException(iOException);
            }
        }
    }

    public static class DummyFunctionResolver
    implements FunctionResolver {
        private static final FunctionResult C = DummyFunctionResolver.getDummyResult();

        @Override
        public Function resolveFunction(final String string) throws FunctionException {
            return new Function(){

                @Override
                public String getName() {
                    return string;
                }

                @Override
                public FunctionResult execute(Evaluator evaluator, String[] stringArray) {
                    return C;
                }
            };
        }

        private static final FunctionResult getDummyResult() {
            return new FunctionResult("dummyResult");
        }
    }

    public static class DynamicFunctionResolver
    implements FunctionResolver {
        private final PopulationContext A;
        private final ContentStreamPopulatorObfImpl B;

        public DynamicFunctionResolver(PopulationContext populationContext, Evaluator evaluator, ContentStreamPopulatorObfImpl contentStreamPopulatorObfImpl) {
            this.A = populationContext;
            this.B = contentStreamPopulatorObfImpl;
        }

        @Override
        public Function resolveFunction(String string) throws FunctionException {
            return new DynamicFunction(string, this.A, this.B);
        }
    }

    private static class _A
    implements VariableResolver {
        private final PopulationContext A;
        private final ContentStreamPopulatorObfImpl B;
        private final Evaluator C;

        public _A(PopulationContext populationContext, Evaluator evaluator, ContentStreamPopulatorObfImpl contentStreamPopulatorObfImpl) {
            this.A = populationContext;
            this.C = evaluator;
            this.B = contentStreamPopulatorObfImpl;
        }

        @Override
        public String resolveVariable(String string) throws FunctionException {
            ParsedField.NameTerm[] nameTermArray = DocmosisExpression.getNameTermsFromKey(string).getTerms();
            try {
                Object object = this.B.A(false, null, nameTermArray, this.A, this.B.b, 0, null);
                if (object == null) {
                    return null;
                }
                return DocmosisExpression.quoteIfNotLiteral(String.valueOf(object), this.C);
            }
            catch (IOException iOException) {
                throw new FunctionException(iOException);
            }
        }
    }
}

