/*
 * Decompiled with CFR 0.152.
 */
package com.docmosis.template.analysis.openoffice.expression;

import com.docmosis.template.analysis.openoffice.expression.ExpressionFunctionException;
import com.docmosis.template.analysis.openoffice.expression.StringExpressionFunction;
import com.docmosis.template.population.render.DateRendererUtil;

public class DateFormatFunction
implements StringExpressionFunction {
    @Override
    public String getName() {
        return "dateFormat";
    }

    @Override
    public String execute(String[] stringArray) throws ExpressionFunctionException {
        if (stringArray.length < 1 || stringArray.length > 7) {
            throw new ExpressionFunctionException("requires 1 to 7 parameters");
        }
        String string = stringArray[0];
        if (string == null || "null".equals(string) || "".equals(string)) {
            return null;
        }
        String string2 = stringArray.length > 1 ? stringArray[1] : null;
        String string3 = stringArray.length > 2 ? stringArray[2] : null;
        String string4 = stringArray.length > 3 ? stringArray[3] : null;
        String string5 = stringArray.length > 4 ? stringArray[4] : null;
        boolean bl = stringArray.length > 5 ? Boolean.valueOf(stringArray[5]) : false;
        boolean bl2 = stringArray.length > 6 ? Boolean.valueOf(stringArray[6]) : false;
        try {
            return new DateRendererUtil().format(string, string2, string3, string4, string5, bl, bl2);
        }
        catch (DateRendererUtil.CannotParseDateException cannotParseDateException) {
            throw new ExpressionFunctionException(cannotParseDateException.getMessage());
        }
        catch (DateRendererUtil.InvalidDateFormatException invalidDateFormatException) {
            throw new ExpressionFunctionException(invalidDateFormatException.getMessage());
        }
    }
}

