/*
 * Decompiled with CFR 0.152.
 */
package com.docmosis.template.analysis.openoffice.expression;

import com.docmosis.template.analysis.openoffice.expression.ExpressionFunctionException;
import com.docmosis.template.analysis.openoffice.expression.RoundFunction;
import com.docmosis.template.analysis.openoffice.expression.StringExpressionFunction;
import com.docmosis.template.population.render.DateRendererUtil;
import com.docmosis.util.DateUtilities;
import com.docmosis.util.StringUtilities;
import net.sourceforge.jeval.com.docmosis.ExtendedBigDecimal;

public class DateDiffFunction
implements StringExpressionFunction {
    @Override
    public String getName() {
        return "dateDiff";
    }

    @Override
    public String execute(String[] stringArray) throws ExpressionFunctionException {
        String string;
        if (stringArray.length < 3 || stringArray.length > 4) {
            throw new ExpressionFunctionException("requires 3 or 4 parameters");
        }
        String string2 = stringArray[0];
        String string3 = stringArray[1];
        if (string2 == null || "null".equals(string2) || "".equals(string2) || string3 == null || "null".equals(string3) || "".equals(string3)) {
            return "0";
        }
        String string4 = string = stringArray[2] == null ? null : stringArray[2].trim();
        if (string == null || "".equals(string) || "null".equals(string)) {
            throw new ExpressionFunctionException("Parameter 3 must be a valid Unit (" + StringUtilities.arrayToString(DateUtilities.Unit.supportedUnitsList(), ",", null) + ")");
        }
        DateUtilities.Unit unit = DateUtilities.Unit.valueOf(string);
        if (unit == null) {
            throw new ExpressionFunctionException("Parameter 3 must be a valid Unit (" + StringUtilities.arrayToString(DateUtilities.Unit.supportedUnitsList(), ",", null) + ")");
        }
        String string5 = stringArray.length < 4 ? null : stringArray[3];
        try {
            double d = new DateRendererUtil().diff(string2, string3, unit, string5);
            return RoundFunction.round(ExtendedBigDecimal.valueOf(d), 0);
        }
        catch (DateRendererUtil.CannotParseDateException cannotParseDateException) {
            throw new ExpressionFunctionException(cannotParseDateException.getMessage());
        }
        catch (DateRendererUtil.InvalidDateFormatException invalidDateFormatException) {
            throw new ExpressionFunctionException(invalidDateFormatException.getMessage());
        }
    }
}

