/*
 * Decompiled with CFR 0.152.
 */
package com.docmosis.template.analysis.openoffice.expression;

import com.docmosis.template.analysis.openoffice.expression.ExpressionFunctionException;
import com.docmosis.template.analysis.openoffice.expression.StringExpressionFunction;
import com.docmosis.template.population.render.DateRendererUtil;
import com.docmosis.util.DateUtilities;
import com.docmosis.util.StringUtilities;

public class DateAddFunction
implements StringExpressionFunction {
    @Override
    public String getName() {
        return "dateAdd";
    }

    @Override
    public String execute(String[] stringArray) throws ExpressionFunctionException {
        String string;
        int n;
        if (stringArray.length < 3 || stringArray.length > 5) {
            throw new ExpressionFunctionException("requires 3 to 5 parameters");
        }
        String string2 = stringArray[0];
        if (string2 == null || "null".equals(string2) || "".equals(string2)) {
            return null;
        }
        try {
            n = (int)Double.parseDouble(stringArray[1]);
        }
        catch (RuntimeException runtimeException) {
            throw new ExpressionFunctionException("Parameter 2 must be an integer");
        }
        String string3 = string = stringArray[2] == null ? null : stringArray[2].trim();
        if (string == null || "null".equals(string) || "".equals(string)) {
            throw new ExpressionFunctionException("Parameter 3 must be a valid UNIT (day, days, month, months etc)");
        }
        DateUtilities.Unit unit = DateUtilities.Unit.valueOf(string);
        if (unit == null) {
            throw new ExpressionFunctionException("Parameter 3 must be a valid Unit (" + StringUtilities.arrayToString(DateUtilities.Unit.supportedUnitsList(), ",", null) + ")");
        }
        String string4 = stringArray.length < 4 ? null : stringArray[3];
        String string5 = stringArray.length < 5 ? null : stringArray[4];
        try {
            return new DateRendererUtil().add(string2, n, unit, string4, string5);
        }
        catch (DateRendererUtil.CannotParseDateException cannotParseDateException) {
            throw new ExpressionFunctionException(cannotParseDateException.getMessage());
        }
        catch (DateRendererUtil.InvalidDateFormatException invalidDateFormatException) {
            throw new ExpressionFunctionException(invalidDateFormatException.getMessage());
        }
    }
}

