/*
 * Decompiled with CFR 0.152.
 */
package com.docmosis.template.analysis.openoffice.expression;

import com.docmosis.template.analysis.openoffice.expression.ExpressionFunctionException;
import com.docmosis.template.analysis.openoffice.expression.StringExpressionFunction;

public class CharFunction
implements StringExpressionFunction {
    @Override
    public String getName() {
        return "char";
    }

    @Override
    public String execute(String[] stringArray) throws ExpressionFunctionException {
        boolean bl;
        if (stringArray.length != 1) {
            throw new ExpressionFunctionException("requires 1 parameter");
        }
        String string = stringArray[0];
        if ("null".equals(string) || string == null || "".equals(string)) {
            return null;
        }
        if ((string = string.trim().toLowerCase()).startsWith("&#x")) {
            bl = true;
            string = string.substring(3);
            while (string.endsWith(";")) {
                string = string.substring(0, string.length() - 1);
            }
        } else if (string.startsWith("&#")) {
            bl = false;
            string = string.substring(2);
            while (string.endsWith(";")) {
                string = string.substring(0, string.length() - 1);
            }
        } else if (string.startsWith("0x")) {
            bl = true;
            string = string.substring(2);
        } else if (string.startsWith("\\u")) {
            bl = true;
            string = string.substring(2);
        } else {
            bl = false;
        }
        try {
            int n = bl ? Integer.parseInt(string, 16) : (int)Double.parseDouble(string);
            String string2 = String.valueOf((char)n);
            return string2;
        }
        catch (NumberFormatException numberFormatException) {
            throw new ExpressionFunctionException("Parameter must be an integer or hexadecimal");
        }
    }
}

