/*
 * Decompiled with CFR 0.152.
 */
package com.docmosis.template.analysis.openoffice;

import com.docmosis.template.TemplateParseException;
import com.docmosis.template.analysis.ParsedField;
import com.docmosis.template.analysis.SimpleTemplateConditionalSection;
import com.docmosis.template.analysis.SimpleTemplateContainer;
import com.docmosis.template.analysis.SimpleTemplateField;
import com.docmosis.template.analysis.SimpleTemplatePlainTextSection;
import com.docmosis.template.analysis.SimpleTemplateRepeatableSection;
import com.docmosis.template.analysis.SimpleTemplateSection;
import com.docmosis.template.analysis.SimpleTemplateSkipSection;
import com.docmosis.template.analysis.SimpleTemplateTable;
import com.docmosis.template.analysis.SimpleTemplateTableCell;
import com.docmosis.template.analysis.SimpleTemplateTableRow;
import com.docmosis.template.analysis.TableCellStyle;
import com.docmosis.template.analysis.TemplateField;
import com.docmosis.template.analysis.TemplateListSection;
import com.docmosis.template.analysis.TemplateNoTableRowAlternateField;
import com.docmosis.template.analysis.TemplateSection;
import com.docmosis.template.analysis.TemplateTableColumn;
import com.docmosis.template.analysis.openoffice.FieldParser;
import com.docmosis.template.analysis.sorting.SortDescription;
import com.docmosis.util.Equivalence;
import com.docmosis.util.logging.LogManager;
import com.docmosis.util.logging.Logger;
import com.docmosis.util.xml.XMLIndexedAttribute;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class TableAnalyzer {
    private static final Logger A = LogManager.getLogger(TableAnalyzer.class);
    private static final String B = "#ffffff";

    public static SimpleTemplateTable analyze(SimpleTemplateTable simpleTemplateTable, Map map, boolean bl) throws TemplateParseException {
        TableAnalyzer.doMarkedUpTableAnalysis(simpleTemplateTable, bl);
        TableAnalyzer.resetParents(simpleTemplateTable.getSubSections(), simpleTemplateTable);
        return simpleTemplateTable;
    }

    private static void resetParents(TemplateSection[] templateSectionArray, SimpleTemplateSection simpleTemplateSection) {
        for (int i = 0; templateSectionArray != null && i < templateSectionArray.length; ++i) {
            SimpleTemplateSection simpleTemplateSection2 = (SimpleTemplateSection)templateSectionArray[i];
            simpleTemplateSection2.setParentSection(simpleTemplateSection);
            if (templateSectionArray[i].isContainer()) {
                TableAnalyzer.resetParents(templateSectionArray[i].getSubSections(), simpleTemplateSection2);
            }
            if (!(simpleTemplateSection instanceof SimpleTemplateTableCell)) continue;
            if (templateSectionArray[i] instanceof SimpleTemplateField) {
                ((SimpleTemplateField)templateSectionArray[i]).setContainingCell((SimpleTemplateTableCell)simpleTemplateSection);
                continue;
            }
            if (!(templateSectionArray[i] instanceof TemplateListSection) || templateSectionArray[i].getSubSections() == null || templateSectionArray[i].getSubSections().length <= 0 || !(templateSectionArray[i].getSubSections()[0] instanceof SimpleTemplateField)) continue;
            ((SimpleTemplateField)templateSectionArray[i].getSubSections()[0]).setContainingCell((SimpleTemplateTableCell)simpleTemplateSection);
        }
    }

    private static void doMarkedUpTableAnalysis(SimpleTemplateTable simpleTemplateTable, boolean bl) throws TemplateParseException {
        Object object;
        _B _B2 = TableAnalyzer.doColumnAnalysis(simpleTemplateTable);
        if (_B2.A()) {
            TableAnalyzer.breakdownTableColumnDefinitions(simpleTemplateTable, _B2);
        }
        int n = 0;
        for (int i = 0; i < simpleTemplateTable.getAllRows().length; ++i) {
            SimpleTemplateTableRow simpleTemplateTableRow = (SimpleTemplateTableRow)simpleTemplateTable.getAllRows()[i];
            object = TableAnalyzer.getRowInfo(simpleTemplateTableRow);
            if (((_C)object).L || ((_C)object).D) {
                ++n;
                continue;
            }
            if (((_C)object).O) {
                --n;
                continue;
            }
            if (n != 0 || !TableAnalyzer.lookAheadForAlternateDisabled(simpleTemplateTableRow.getSubSections())) continue;
            bl = true;
            break;
        }
        SimpleTemplateContainer simpleTemplateContainer = new SimpleTemplateContainer();
        if (simpleTemplateTable.getHeaderRows() != null) {
            TableAnalyzer.doMarkedUpRepeatingOrConditionalRowAnalysis(simpleTemplateTable, simpleTemplateTable.getHeaderRows(), 0, simpleTemplateContainer, null, _B2, bl);
            simpleTemplateTable.replaceHeaderRows(simpleTemplateContainer.getSubSections());
        }
        simpleTemplateContainer = new SimpleTemplateContainer();
        if (simpleTemplateTable.getNonHeaderRows() != null) {
            TableAnalyzer.doMarkedUpRepeatingOrConditionalRowAnalysis(simpleTemplateTable, simpleTemplateTable.getNonHeaderRows(), 0, simpleTemplateContainer, null, _B2, bl);
            simpleTemplateTable.replaceNonHeaderRows(simpleTemplateContainer.getSubSections());
        }
        if (_B2.A()) {
            TemplateSection[] templateSectionArray;
            TemplateSection templateSection;
            for (int i = 0; i < _B2.B(); ++i) {
                object = _B2.B(i);
                if (object == null) continue;
                templateSection = new SimpleTemplateField();
                ((SimpleTemplateField)templateSection).setFieldName((String)object + "=" + _B2.C(i).getParsedFieldDetails().getOriginalFieldTextSansPrefix());
                ((SimpleTemplateSection)templateSection).setStartIndex(0L);
                ((SimpleTemplateSection)templateSection).setEndIndex(0L);
                ((SimpleTemplateSection)templateSection).setArtificial(true);
                ((SimpleTemplateSection)templateSection).setParsedFieldDetails(FieldParser.parse(((SimpleTemplateField)templateSection).getFieldName()));
                simpleTemplateTable.addSectionPositioned((SimpleTemplateSection)templateSection);
            }
            TemplateSection[] templateSectionArray2 = simpleTemplateTable.getAllRows();
            if (templateSectionArray2 != null) {
                for (int i = 0; i < templateSectionArray2.length; ++i) {
                    templateSection = templateSectionArray2[i];
                    templateSectionArray = templateSection.getSubSections();
                    if (templateSectionArray == null) continue;
                    for (int j = 0; j < templateSectionArray.length; ++j) {
                        TemplateSection templateSection2 = templateSectionArray[j];
                        if (templateSection2 instanceof SimpleTemplateConditionalSection) {
                            TemplateSection templateSection3 = templateSection2 = templateSection2.getSubSections() != null && templateSection2.getSubSections().length > 0 ? templateSection2.getSubSections()[0] : null;
                        }
                        if (!(templateSection2 instanceof SimpleTemplateTableCell)) continue;
                        SimpleTemplateTableCell simpleTemplateTableCell = (SimpleTemplateTableCell)templateSection2;
                        simpleTemplateTableCell.setAllColumnsLeftConditional(TableAnalyzer.areAllColumnsLeftConditional(templateSectionArray, j));
                        simpleTemplateTableCell.setAllColumnsRightConditional(TableAnalyzer.areAllColumnsRightConditional(templateSectionArray, j));
                    }
                }
            }
            if ((templateSectionArray2 = simpleTemplateTable.getAllRows()) != null) {
                for (int i = 0; i < templateSectionArray2.length; ++i) {
                    if (!(templateSectionArray2[i] instanceof SimpleTemplateTableRow) || (templateSectionArray = ((SimpleTemplateSection)(templateSection = (SimpleTemplateTableRow)templateSectionArray2[i])).getSubSections()) == null || templateSectionArray.length <= 0) continue;
                    TemplateSection templateSection4 = templateSectionArray[0];
                    if (templateSection4 instanceof SimpleTemplateConditionalSection) {
                        TemplateSection templateSection5 = templateSection4 = templateSection4.getSubSections() != null && templateSection4.getSubSections().length > 0 ? templateSection4.getSubSections()[0] : null;
                    }
                    if (templateSection4 instanceof SimpleTemplateTableCell) {
                        ((SimpleTemplateTableRow)templateSection).setLeftBorderStyle(((SimpleTemplateTableCell)templateSection4).getStyle().getOriginalLeftBorder());
                    }
                    if ((templateSection4 = templateSectionArray[templateSectionArray.length - 1]) instanceof SimpleTemplateConditionalSection) {
                        TemplateSection templateSection6 = templateSection4 = templateSection4.getSubSections() != null && templateSection4.getSubSections().length > 0 ? templateSection4.getSubSections()[0] : null;
                    }
                    if (!(templateSection4 instanceof SimpleTemplateTableCell)) continue;
                    ((SimpleTemplateTableRow)templateSection).setRightBorderStyle(((SimpleTemplateTableCell)templateSection4).getStyle().getOriginalRightBorder());
                }
            }
        }
    }

    private static boolean areAllColumnsLeftConditional(TemplateSection[] templateSectionArray, int n) {
        if (templateSectionArray == null || n == 0 || n > templateSectionArray.length - 1) {
            return false;
        }
        boolean bl = true;
        for (int i = 0; i < n; ++i) {
            TemplateSection templateSection = templateSectionArray[i];
            if (templateSection instanceof SimpleTemplateConditionalSection) continue;
            bl = false;
            break;
        }
        return bl;
    }

    private static boolean areAllColumnsRightConditional(TemplateSection[] templateSectionArray, int n) {
        if (templateSectionArray == null || n >= templateSectionArray.length - 1) {
            return false;
        }
        boolean bl = true;
        for (int i = n + 1; i < templateSectionArray.length; ++i) {
            TemplateSection templateSection = templateSectionArray[i];
            if (templateSection instanceof SimpleTemplateConditionalSection) continue;
            bl = false;
            break;
        }
        return bl;
    }

    private static _B doColumnAnalysis(SimpleTemplateTable simpleTemplateTable) throws TemplateParseException {
        TemplateSection[] templateSectionArray;
        _B _B2 = new _B();
        if (simpleTemplateTable.getSubSections() != null && (templateSectionArray = simpleTemplateTable.getAllRows()) != null) {
            SimpleTemplateTableRow simpleTemplateTableRow = (SimpleTemplateTableRow)templateSectionArray[0];
            TemplateSection[] templateSectionArray2 = simpleTemplateTableRow.getSubSections();
            for (int i = 0; templateSectionArray2 != null && i < templateSectionArray2.length; ++i) {
                TemplateSection[] templateSectionArray3 = templateSectionArray2[i].getSubSections();
                if (!(templateSectionArray2[i] instanceof SimpleTemplateTableCell)) {
                    A.warn("Expected cell, but got a " + templateSectionArray2[i].getClass().getName());
                    continue;
                }
                TemplateField templateField = TableAnalyzer.doColumnAnalysis(templateSectionArray3);
                int n = ((SimpleTemplateTableCell)templateSectionArray2[i]).getColumnsSpanned();
                for (int j = 0; j < n; ++j) {
                    _B2.A(templateField);
                }
            }
        }
        return _B2;
    }

    private static TemplateField doColumnAnalysis(TemplateSection[] templateSectionArray) {
        TemplateField templateField = null;
        for (int i = 0; templateSectionArray != null && i < templateSectionArray.length; ++i) {
            if (templateSectionArray[i] instanceof TemplateField) {
                TemplateField templateField2 = (TemplateField)templateSectionArray[i];
                ParsedField parsedField = templateField2.getParsedFieldDetails();
                if (!parsedField.isConditionalColumn()) continue;
                if (templateField == null) {
                    templateField = templateField2;
                }
                SimpleTemplateSkipSection simpleTemplateSkipSection = new SimpleTemplateSkipSection();
                simpleTemplateSkipSection.setStartIndex(templateField2.getStartIndex());
                simpleTemplateSkipSection.setEndIndex(templateField2.getEndIndex());
                simpleTemplateSkipSection.setSubSections(new TemplateSection[]{templateField2});
                templateSectionArray[i] = simpleTemplateSkipSection;
                continue;
            }
            if (!(templateSectionArray[i] instanceof TemplateListSection)) continue;
            templateField = TableAnalyzer.doColumnAnalysis(templateSectionArray[i].getSubSections());
        }
        return templateField;
    }

    private static void breakdownTableColumnDefinitions(SimpleTemplateTable simpleTemplateTable, _B _B2) throws TemplateParseException {
        ArrayList<SimpleTemplateSection> arrayList = new ArrayList<SimpleTemplateSection>();
        TemplateSection[] templateSectionArray = simpleTemplateTable.getColumns();
        int n = 0;
        for (int i = 0; i < templateSectionArray.length; ++i) {
            Object object;
            SimpleTemplateSection simpleTemplateSection;
            TemplateTableColumn templateTableColumn = (TemplateTableColumn)templateSectionArray[i];
            XMLIndexedAttribute xMLIndexedAttribute = templateTableColumn.getTag().getAttribute("table:number-columns-repeated");
            if (xMLIndexedAttribute != null) {
                simpleTemplateSection = new SimpleTemplateSkipSection();
                simpleTemplateSection.setStartIndex(templateTableColumn.getStartIndex());
                simpleTemplateSection.setEndIndex(templateTableColumn.getEndIndex());
                simpleTemplateSection.setSubSections(new TemplateSection[]{templateTableColumn});
                arrayList.add(simpleTemplateSection);
                object = templateTableColumn.getTag().getTagWithoutAttribute("table:number-columns-repeated");
                int n2 = Integer.parseInt(xMLIndexedAttribute.getValue());
                while (n2-- > 0) {
                    SimpleTemplatePlainTextSection simpleTemplatePlainTextSection = new SimpleTemplatePlainTextSection((String)object);
                    simpleTemplatePlainTextSection.setStartIndex(templateTableColumn.getTag().getEndIdx());
                    simpleTemplatePlainTextSection.setEndIndex(templateTableColumn.getTag().getEndIdx());
                    if (_B2.A(n)) {
                        SimpleTemplateConditionalSection simpleTemplateConditionalSection = new SimpleTemplateConditionalSection();
                        simpleTemplateConditionalSection.addSection(simpleTemplatePlainTextSection);
                        simpleTemplateConditionalSection.setStartIndex(templateTableColumn.getTag().getEndIdx());
                        simpleTemplateConditionalSection.setEndIndex(templateTableColumn.getTag().getEndIdx());
                        simpleTemplateConditionalSection.setSectionName(_B2.B(n));
                        simpleTemplateConditionalSection.setArtificial(true);
                        ParsedField parsedField = FieldParser.parse(FieldParser.DM_CONDITIONAL_SECTION_START_PREFIX + simpleTemplateConditionalSection.getSectionName());
                        simpleTemplateConditionalSection.setParsedFieldDetails(parsedField);
                        arrayList.add(simpleTemplateConditionalSection);
                    } else {
                        arrayList.add(simpleTemplatePlainTextSection);
                    }
                    ++n;
                }
                continue;
            }
            if (_B2.A(n)) {
                simpleTemplateSection = new SimpleTemplateConditionalSection();
                simpleTemplateSection.addSection(templateTableColumn);
                simpleTemplateSection.setStartIndex(templateTableColumn.getTag().getStartIdx());
                simpleTemplateSection.setEndIndex(templateTableColumn.getTag().getEndIdx());
                ((SimpleTemplateConditionalSection)simpleTemplateSection).setSectionName(_B2.B(n));
                simpleTemplateSection.setArtificial(true);
                object = FieldParser.parse(FieldParser.DM_CONDITIONAL_SECTION_START_PREFIX + ((SimpleTemplateConditionalSection)simpleTemplateSection).getSectionName());
                simpleTemplateSection.setParsedFieldDetails((ParsedField)object);
                arrayList.add(simpleTemplateSection);
            } else {
                arrayList.add(templateTableColumn);
            }
            ++n;
        }
        TemplateSection[] templateSectionArray2 = arrayList.iterator();
        while (templateSectionArray2.hasNext()) {
            if (!(templateSectionArray2.next() instanceof TemplateTableColumn)) continue;
            templateSectionArray2.remove();
        }
        if (arrayList.size() > 0) {
            templateSectionArray2 = new SimpleTemplateSection[arrayList.size()];
            arrayList.toArray(templateSectionArray2);
            simpleTemplateTable.replaceColumns(templateSectionArray2);
        }
    }

    private static int doMarkedUpRepeatingOrConditionalRowAnalysis(SimpleTemplateTable simpleTemplateTable, TemplateSection[] templateSectionArray, int n, SimpleTemplateContainer simpleTemplateContainer, _D _D2, _B _B2, boolean bl) throws TemplateParseException {
        if (n >= templateSectionArray.length) {
            return n;
        }
        for (int i = n; i < templateSectionArray.length; ++i) {
            Object object;
            Object object2;
            int n2;
            int n3;
            TemplateSection[] templateSectionArray2;
            SimpleTemplateTableRow simpleTemplateTableRow = (SimpleTemplateTableRow)templateSectionArray[i];
            _C _C2 = TableAnalyzer.getRowInfo(simpleTemplateTableRow);
            if (_C2.D) {
                templateSectionArray2 = new SimpleTemplateRepeatableSection();
                templateSectionArray2.setSectionName(_C2.E);
                templateSectionArray2.setStartIndex(simpleTemplateTableRow.getStartIndex());
                templateSectionArray2.setPreAmbleEndIdx(simpleTemplateTableRow.getEndIndex());
                templateSectionArray2.setSkipPreAndPostAmble(true);
                templateSectionArray2.setDerivedFromRepeatingTableRow(true);
                ParsedField parsedField = FieldParser.parse(FieldParser.DM_REPEATING_SECTION_START_PREFIX + templateSectionArray2.getSectionName());
                templateSectionArray2.setParsedFieldDetails(parsedField);
                templateSectionArray2.setStepSize(_C2.C);
                templateSectionArray2.setStepDown(_C2.A);
                templateSectionArray2.setArtificialRS(_C2.M);
                templateSectionArray2.setArtificialRSlength(_C2.B);
                templateSectionArray2.setSorted(_C2.I);
                templateSectionArray2.setSorts(_C2.F);
                templateSectionArray2.setFiltered(_C2.H);
                templateSectionArray2.setFilterExpression(_C2.G);
                templateSectionArray2.setGrouped(_C2.J);
                templateSectionArray2.setGroupByExpression(_C2.N);
                simpleTemplateContainer.addSection((SimpleTemplateSection)templateSectionArray2);
                templateSectionArray2.setSubSections(TableAnalyzer.extractHeaderRowDirectivesToKeep(simpleTemplateTableRow));
                i = TableAnalyzer.doMarkedUpRepeatingOrConditionalRowAnalysis(simpleTemplateTable, templateSectionArray, i + 1, (SimpleTemplateContainer)templateSectionArray2, new _D(simpleTemplateTableRow), _B2, bl);
                if (i >= templateSectionArray.length) {
                    throw new TemplateParseException("Cannot find end repeat row for repeating row \"" + _C2.E + "\" ", new String[]{"Check that your repeating or conditional row markers match", "Make sure any repeating or conditional rows are ALL heading rows or ALL NOT heading rows in the table properties in your template."}, _C2.K);
                }
                _C _C3 = TableAnalyzer.getRowInfo((SimpleTemplateTableRow)templateSectionArray[i]);
                if ("".equals(_C3.E) || _C2.E.equals(_C3.E)) continue;
                throw new TemplateParseException("Found  \"" + FieldParser.DM_REPEATING_OR_CONDITIONAL_ROW_END_PREFIX + _C3.E + "\" instead of \"" + FieldParser.DM_REPEATING_OR_CONDITIONAL_ROW_END_PREFIX + _C2.E + "\"", _C3.K);
            }
            if (_C2.L) {
                templateSectionArray2 = new SimpleTemplateConditionalSection();
                templateSectionArray2.setSectionName(_C2.E);
                templateSectionArray2.setStartIndex(simpleTemplateTableRow.getStartIndex());
                templateSectionArray2.setPreAmbleEndIdx(simpleTemplateTableRow.getEndIndex());
                templateSectionArray2.setSkipPreAndPostAmble(true);
                ParsedField parsedField = FieldParser.parse(FieldParser.DM_CONDITIONAL_SECTION_START_PREFIX + templateSectionArray2.getSectionName());
                templateSectionArray2.setParsedFieldDetails(parsedField);
                simpleTemplateContainer.addSection((SimpleTemplateSection)templateSectionArray2);
                templateSectionArray2.setSubSections(TableAnalyzer.extractHeaderRowDirectivesToKeep(simpleTemplateTableRow));
                i = TableAnalyzer.doMarkedUpRepeatingOrConditionalRowAnalysis(simpleTemplateTable, templateSectionArray, i + 1, (SimpleTemplateContainer)templateSectionArray2, null, _B2, bl);
                if (i >= templateSectionArray.length) {
                    throw new TemplateParseException("Cannot find end row for conditional row \"" + _C2.E + "\" ", new String[]{"Check that your repeating or conditional row markers match", "Make sure any repeating or conditional rows are ALL heading rows or ALL NOT heading rows in the table properties in your template."}, _C2.K);
                }
                _C _C4 = TableAnalyzer.getRowInfo((SimpleTemplateTableRow)templateSectionArray[i]);
                if ("".equals(_C4.E) || _C2.E.equals(_C4.E)) continue;
                throw new TemplateParseException("Found  \"" + FieldParser.DM_REPEATING_OR_CONDITIONAL_ROW_END_PREFIX + _C4.E + "\" with no starting repeating or conditional row", _C4.K);
            }
            if (_C2.O) {
                boolean bl2 = simpleTemplateContainer instanceof SimpleTemplateRepeatableSection;
                boolean bl3 = simpleTemplateContainer instanceof SimpleTemplateConditionalSection;
                if (!bl2 && !bl3) {
                    _C _C5 = TableAnalyzer.getRowInfo(simpleTemplateTableRow);
                    throw new TemplateParseException("Found unexpected end sequence in table for conditional/repeating rows named \"" + _C5.E + "\"", new String[]{"Check that your repeating or conditional row markers match", "Make sure any repeating or conditional rows are ALL heading rows or ALL NOT heading rows in the table properties in your template."}, _C5.K);
                }
                simpleTemplateContainer.setPostAmbleStartIdx(simpleTemplateTableRow.getStartIndex());
                simpleTemplateContainer.setEndIndex(simpleTemplateTableRow.getEndIndex());
                if (bl2) {
                    TemplateSection[] templateSectionArray3 = simpleTemplateContainer.getSubSections();
                    boolean bl4 = simpleTemplateTableRow != null && TableAnalyzer.lookAheadForAlternateDisabled(simpleTemplateTableRow.getSubSections());
                    n3 = bl4 || TableAnalyzer.lookAheadForAlternateDisabled(templateSectionArray3) ? 1 : 0;
                    for (n2 = 0; templateSectionArray3 != null && n2 < templateSectionArray3.length; ++n2) {
                        object2 = templateSectionArray3[n2];
                        while (object2 instanceof SimpleTemplateConditionalSection && object2.getSubSections() != null && object2.getSubSections().length > 0) {
                            object2 = object2.getSubSections()[0];
                        }
                        TemplateSection[] templateSectionArray4 = object2.getSubSections();
                        for (int j = 0; templateSectionArray4 != null && j < templateSectionArray4.length; ++j) {
                            String string;
                            String string2;
                            TableCellStyle tableCellStyle;
                            object = null;
                            if (templateSectionArray4[j] instanceof SimpleTemplateTableCell) {
                                object = (SimpleTemplateTableCell)templateSectionArray4[j];
                            } else if (templateSectionArray4[j] instanceof SimpleTemplateConditionalSection && templateSectionArray4[j].getSubSections() != null && templateSectionArray4[j].getSubSections().length > 0 && templateSectionArray4[j].getSubSections()[0] instanceof SimpleTemplateTableCell) {
                                object = (SimpleTemplateTableCell)templateSectionArray4[j].getSubSections()[0];
                            }
                            if (object == null || (tableCellStyle = ((SimpleTemplateTableCell)object).getStyle()) == null) continue;
                            if (!bl && n3 == 0) {
                                String string3 = _D2.A(j);
                                string2 = tableCellStyle.getOrigBgColour();
                                string3 = string3 == null ? B : string3;
                                String string4 = string2 = string2 == null ? B : string2;
                                if (!Equivalence.equivalentObjects(string3, string2)) {
                                    tableCellStyle.setAlternatingBackgroundColours(string3, string2);
                                    simpleTemplateTable.setHasDynamicStyling(true);
                                }
                            }
                            boolean bl5 = false;
                            if (n2 == 0) {
                                string2 = _D2.B(j);
                                bl5 = true;
                            } else {
                                string2 = tableCellStyle.getOrigTopBorder();
                            }
                            if (n2 == templateSectionArray3.length - 1) {
                                string = new _E(simpleTemplateTableRow).A(j);
                                bl5 = true;
                            } else {
                                string = tableCellStyle.getOrigBottomBorder();
                            }
                            if (bl5) {
                                tableCellStyle = new TableCellStyle(tableCellStyle);
                                ((SimpleTemplateTableCell)object).setStyle(tableCellStyle);
                            }
                            tableCellStyle.setBorderStyles(string2, string);
                            if (!tableCellStyle.borderStylesVary()) continue;
                            simpleTemplateTable.setHasDynamicStyling(true);
                        }
                    }
                }
                return i;
            }
            templateSectionArray2 = simpleTemplateTableRow.getSubSections();
            int n4 = 0;
            for (int j = 0; templateSectionArray2 != null && j < templateSectionArray2.length; ++j) {
                if (!(templateSectionArray2[j] instanceof SimpleTemplateTableCell)) continue;
                SimpleTemplateTableCell simpleTemplateTableCell = (SimpleTemplateTableCell)templateSectionArray2[j];
                n3 = simpleTemplateTableCell.getColumnsSpanned();
                if (_B2.A(n4)) {
                    Serializable serializable;
                    n2 = 1;
                    object2 = _B2.C(n4).getFieldName();
                    for (int k = 1; k < n3; ++k) {
                        serializable = _B2.C(n4 + k);
                        if (serializable == null) {
                            throw new TemplateParseException("This column can't be conditioned because there are columns spanning this column in some rows of the table.", _B2.C(n4).getStartIndex());
                        }
                        object = serializable.getFieldName();
                        if (((String)object2).equals(object)) continue;
                        n2 = 0;
                        break;
                    }
                    if (n2 != 0) {
                        SimpleTemplateConditionalSection simpleTemplateConditionalSection = new SimpleTemplateConditionalSection();
                        simpleTemplateConditionalSection.setStartIndex(simpleTemplateTableCell.getStartIndex());
                        simpleTemplateConditionalSection.setEndIndex(simpleTemplateTableCell.getEndIndex());
                        simpleTemplateConditionalSection.setSectionName(_B2.B(n4));
                        simpleTemplateConditionalSection.setSubSections(new TemplateSection[]{simpleTemplateTableCell});
                        simpleTemplateConditionalSection.setArtificial(true);
                        serializable = FieldParser.parse(FieldParser.DM_CONDITIONAL_SECTION_START_PREFIX + simpleTemplateConditionalSection.getSectionName());
                        simpleTemplateConditionalSection.setParsedFieldDetails((ParsedField)serializable);
                        templateSectionArray2[j] = simpleTemplateConditionalSection;
                    }
                }
                n4 += n3;
            }
            simpleTemplateContainer.addSection(simpleTemplateTableRow);
        }
        return templateSectionArray.length;
    }

    private static boolean lookAheadForAlternateDisabled(TemplateSection[] templateSectionArray) {
        for (int i = 0; templateSectionArray != null && i < templateSectionArray.length; ++i) {
            if (!TableAnalyzer.lookAheadForAlternateDisabled2(templateSectionArray[i])) continue;
            return true;
        }
        return false;
    }

    private static boolean lookAheadForAlternateDisabled2(TemplateSection templateSection) {
        if (templateSection instanceof SimpleTemplateTable || templateSection instanceof SimpleTemplateRepeatableSection && ((SimpleTemplateRepeatableSection)templateSection).isDerivedFromRepeatingTableRow()) {
            return false;
        }
        if (templateSection instanceof TemplateNoTableRowAlternateField) {
            return true;
        }
        TemplateSection[] templateSectionArray = templateSection.getSubSections();
        for (int i = 0; templateSectionArray != null && i < templateSectionArray.length; ++i) {
            if (!TableAnalyzer.lookAheadForAlternateDisabled2(templateSectionArray[i])) continue;
            return true;
        }
        return false;
    }

    static TemplateSection[] extractHeaderRowDirectivesToKeep(SimpleTemplateTableRow simpleTemplateTableRow) {
        TemplateSection[] templateSectionArray = simpleTemplateTableRow.getSubSections();
        ArrayList<TemplateSection> arrayList = new ArrayList<TemplateSection>();
        for (int i = 0; templateSectionArray != null && i < templateSectionArray.length; ++i) {
            TemplateSection[] templateSectionArray2 = TableAnalyzer.collectDirectives(templateSectionArray[i].getSubSections());
            if (templateSectionArray2 == null) continue;
            for (int j = 0; j < templateSectionArray2.length; ++j) {
                arrayList.add(templateSectionArray2[j]);
            }
        }
        if (arrayList.isEmpty()) {
            return null;
        }
        TemplateSection[] templateSectionArray3 = new TemplateSection[arrayList.size()];
        arrayList.toArray(templateSectionArray3);
        return templateSectionArray3;
    }

    private static TemplateSection[] collectDirectives(TemplateSection[] templateSectionArray) {
        TemplateSection[] templateSectionArray2 = null;
        if (templateSectionArray != null) {
            ArrayList arrayList = new ArrayList();
            TableAnalyzer.collectDirectives(templateSectionArray, arrayList);
            if (arrayList.size() > 0) {
                templateSectionArray2 = new TemplateSection[arrayList.size()];
                arrayList.toArray(templateSectionArray2);
            }
        }
        return templateSectionArray2;
    }

    private static void collectDirectives(TemplateSection[] templateSectionArray, List list) {
        if (templateSectionArray != null) {
            for (int i = 0; i < templateSectionArray.length; ++i) {
                SimpleTemplateContainer simpleTemplateContainer;
                Object object;
                if (templateSectionArray[i] instanceof SimpleTemplateConditionalSection) {
                    object = TableAnalyzer.collectDirectives(templateSectionArray[i].getSubSections());
                    if (object == null) continue;
                    simpleTemplateContainer = ((SimpleTemplateConditionalSection)templateSectionArray[i]).newShallowCopy();
                    simpleTemplateContainer.setSubSections((TemplateSection[])object);
                    list.add(simpleTemplateContainer);
                    continue;
                }
                if (templateSectionArray[i] instanceof SimpleTemplateRepeatableSection) {
                    object = TableAnalyzer.collectDirectives(templateSectionArray[i].getSubSections());
                    if (object == null) continue;
                    simpleTemplateContainer = ((SimpleTemplateRepeatableSection)templateSectionArray[i]).newShallowCopy();
                    simpleTemplateContainer.setSubSections((TemplateSection[])object);
                    list.add(simpleTemplateContainer);
                    continue;
                }
                if (templateSectionArray[i] instanceof TemplateField) {
                    object = ((TemplateField)templateSectionArray[i]).getParsedFieldDetails();
                    if (!((ParsedField)object).isSetVariable()) continue;
                    list.add(templateSectionArray[i]);
                    continue;
                }
                if (templateSectionArray[i] instanceof SimpleTemplateSkipSection && templateSectionArray[i].getSubSections() != null && templateSectionArray[i].getSubSections().length > 0 && templateSectionArray[i].getSubSections()[0] instanceof TemplateNoTableRowAlternateField) {
                    list.add(templateSectionArray[i].getSubSections()[0]);
                    continue;
                }
                if (!(templateSectionArray[i] instanceof TemplateListSection)) continue;
                TableAnalyzer.collectDirectives(templateSectionArray[i].getSubSections(), list);
            }
        }
    }

    private static _C getRowInfo(SimpleTemplateTableRow simpleTemplateTableRow) throws TemplateParseException {
        TemplateSection[] templateSectionArray = simpleTemplateTableRow.getSubSections();
        _C _C2 = null;
        for (int i = 0; templateSectionArray != null && i < templateSectionArray.length; ++i) {
            TemplateSection[] templateSectionArray2 = templateSectionArray[i].getSubSections();
            _C2 = TableAnalyzer.getRowInfo(templateSectionArray2, _C2);
        }
        if (_C2 == null) {
            _C2 = new _C(0L);
        }
        return _C2;
    }

    private static _C getRowInfo(TemplateSection[] templateSectionArray, _C _C2) throws TemplateParseException {
        if (templateSectionArray != null) {
            int n;
            for (n = 0; n < templateSectionArray.length; ++n) {
                if (!(templateSectionArray[n] instanceof TemplateField)) continue;
                TemplateField templateField = (TemplateField)templateSectionArray[n];
                ParsedField parsedField = templateField.getParsedFieldDetails();
                if (parsedField.isRepeatingTableRowStart()) {
                    boolean bl;
                    boolean bl2;
                    boolean bl3;
                    boolean bl4;
                    if (_C2 != null) {
                        throw new TemplateParseException("Tag \"" + templateField.getFieldName() + "\" can't exist in the same table row as another \"" + FieldParser.DM_REPEATING_ROW_START_PREFIX + "xxx\", \"" + FieldParser.DM_CONDITIONAL_ROW_START_PREFIX + "xxx\" or \"" + FieldParser.DM_REPEATING_OR_CONDITIONAL_ROW_END_PREFIX + "xxx\" tag.", templateField.getStartIndex());
                    }
                    _C2 = new _C(templateField.getStartIndex());
                    _C2.D = true;
                    _C2.E = parsedField.getOriginalFieldTextSansPrefix();
                    int n2 = parsedField.getLastTerm().getStepSize();
                    _C2.C = n2 == -1 ? 1 : n2;
                    _C2.A = parsedField.getLastTerm().getStepDown();
                    _C2.M = bl4 = parsedField.getLastTerm().isArtificialRS();
                    _C2.B = bl4 ? parsedField.getLastTerm().getArtificialRSlength() : null;
                    _C2.I = bl3 = parsedField.getLastTerm().isSorted();
                    _C2.F = parsedField.getLastTerm().getSorts();
                    _C2.H = bl2 = parsedField.getLastTerm().isFiltered();
                    _C2.G = bl2 ? parsedField.getLastTerm().getFilterExpression() : null;
                    _C2.J = bl = parsedField.getLastTerm().isGrouped();
                    _C2.N = bl ? parsedField.getLastTerm().getGroupByExpression() : null;
                    continue;
                }
                if (parsedField.isConditionalTableRowStart()) {
                    if (_C2 != null) {
                        throw new TemplateParseException("Tag \"" + templateField.getFieldName() + "\" can't exist in the same table row as another \"" + FieldParser.DM_REPEATING_ROW_START_PREFIX + "xxx\", \"" + FieldParser.DM_CONDITIONAL_ROW_START_PREFIX + "xxx\" or \"" + FieldParser.DM_REPEATING_OR_CONDITIONAL_ROW_END_PREFIX + "xxx\" tag.", templateField.getStartIndex());
                    }
                    _C2 = new _C(templateField.getStartIndex());
                    _C2.L = true;
                    _C2.E = parsedField.getOriginalFieldTextSansPrefix();
                    continue;
                }
                if (!parsedField.isRepeatingOrConditionalTableRowEnd()) continue;
                if (_C2 != null) {
                    throw new TemplateParseException("Tag \"" + templateField.getFieldName() + "\" can't exist in the same table row as another \"" + FieldParser.DM_REPEATING_ROW_START_PREFIX + "xxx\", \"" + FieldParser.DM_CONDITIONAL_ROW_START_PREFIX + "xxx\" or \"" + FieldParser.DM_REPEATING_OR_CONDITIONAL_ROW_END_PREFIX + "xxx\" tag.", templateField.getStartIndex());
                }
                _C2 = new _C(templateField.getStartIndex());
                _C2.O = true;
                _C2.E = parsedField.getOriginalFieldTextSansPrefix();
            }
            if (_C2 == null) {
                for (n = 0; !(n >= templateSectionArray.length || templateSectionArray[n] instanceof TemplateListSection && (_C2 = TableAnalyzer.getRowInfo(templateSectionArray[n].getSubSections(), _C2)) != null); ++n) {
                }
            }
        }
        return _C2;
    }

    private static class _E {
        String[] A;

        public _E(SimpleTemplateTableRow simpleTemplateTableRow) {
            if (simpleTemplateTableRow == null || simpleTemplateTableRow.getSubSections() == null) {
                return;
            }
            TemplateSection[] templateSectionArray = simpleTemplateTableRow.getSubSections();
            int n = templateSectionArray == null ? 0 : templateSectionArray.length;
            this.A = new String[n];
            for (int i = 0; i < n; ++i) {
                TableCellStyle tableCellStyle = ((SimpleTemplateTableCell)templateSectionArray[i]).getStyle();
                if (tableCellStyle == null) continue;
                this.A[i] = tableCellStyle.getOrigBottomBorder();
            }
        }

        public String A(int n) {
            if (n >= this.A.length) {
                return this.A[this.A.length - 1];
            }
            return this.A[n];
        }
    }

    private static class _D {
        String[] A;
        String[] B;

        public _D(SimpleTemplateTableRow simpleTemplateTableRow) {
            if (simpleTemplateTableRow == null || simpleTemplateTableRow.getSubSections() == null) {
                return;
            }
            TemplateSection[] templateSectionArray = simpleTemplateTableRow.getSubSections();
            int n = templateSectionArray == null ? 0 : templateSectionArray.length;
            this.A = new String[n];
            this.B = new String[n];
            for (int i = 0; i < n; ++i) {
                TableCellStyle tableCellStyle = ((SimpleTemplateTableCell)templateSectionArray[i]).getStyle();
                if (tableCellStyle == null) continue;
                this.A[i] = tableCellStyle.getOrigBgColour();
                this.B[i] = tableCellStyle.getOrigTopBorder();
            }
        }

        public String A(int n) {
            if (n >= this.A.length) {
                return this.A[this.A.length - 1];
            }
            return this.A[n];
        }

        public String B(int n) {
            if (n >= this.B.length) {
                return this.B[this.B.length - 1];
            }
            return this.B[n];
        }
    }

    private static class _A {
        private TemplateField C;
        private String B;
        private static int A;

        public _A(TemplateField templateField) {
            this.C = templateField;
            if (templateField != null) {
                int n = (int)(Math.random() * 99999.0);
                long l = System.currentTimeMillis();
                long l2 = _A.A();
                this.B = "$DM_" + String.valueOf(l2) + "_" + String.valueOf(n) + "_" + l;
            }
        }

        public String C() {
            return this.B;
        }

        public TemplateField B() {
            return this.C;
        }

        private static synchronized int A() {
            return A++;
        }
    }

    private static class _B {
        private ArrayList A;

        private _B() {
        }

        public void A(TemplateField templateField) throws TemplateParseException {
            if (this.A == null) {
                this.A = new ArrayList();
            }
            if (templateField == null) {
                this.A.add(null);
            } else {
                this.A.add(new _A(templateField));
            }
        }

        public String B(int n) {
            _A _A2;
            String string = null;
            if (n < this.A.size() && (_A2 = (_A)this.A.get(n)) != null) {
                string = _A2.C();
            }
            return string;
        }

        public TemplateField C(int n) {
            _A _A2;
            TemplateField templateField = null;
            if (n < this.A.size() && (_A2 = (_A)this.A.get(n)) != null) {
                templateField = _A2.B();
            }
            return templateField;
        }

        public boolean A() {
            boolean bl = false;
            if (this.A != null) {
                Iterator iterator = this.A.iterator();
                while (iterator.hasNext()) {
                    if (iterator.next() == null) continue;
                    bl = true;
                    break;
                }
            }
            return bl;
        }

        public boolean A(int n) {
            return this.A != null && this.A.size() > n && this.A.get(n) != null;
        }

        public int B() {
            return this.A == null ? 0 : this.A.size();
        }
    }

    private static class _C {
        boolean D;
        int C;
        boolean A;
        boolean O;
        boolean L;
        String E;
        final long K;
        boolean M;
        String B;
        boolean I;
        SortDescription[] F;
        boolean H;
        String G;
        boolean J;
        String N;

        public _C(long l) {
            this.K = l;
        }
    }
}

