/*
 * Decompiled with CFR 0.152.
 */
package com.docmosis.template.analysis.openoffice;

import com.docmosis.template.TemplateParseException;
import com.docmosis.template.analysis.SimpleTemplateConditionalSection;
import com.docmosis.template.analysis.SimpleTemplateRepeatableSection;
import com.docmosis.template.analysis.SimpleTemplateRoot;
import com.docmosis.template.analysis.SimpleTemplateSection;
import com.docmosis.template.analysis.SimpleTemplateSkipSection;
import com.docmosis.template.analysis.SimpleTemplateTableCell;
import com.docmosis.template.analysis.SimpleTemplateTableRow;
import com.docmosis.template.analysis.TemplateErrorSection;
import com.docmosis.template.analysis.TemplateListSection;
import com.docmosis.template.analysis.TemplateNamedSection;
import com.docmosis.template.analysis.TemplateSection;
import com.docmosis.template.analysis.openoffice.FieldParser;
import com.docmosis.template.analysis.openoffice.ODFContentAnalyzer;
import com.docmosis.template.analysis.openoffice.ODFHandlerObfImpl;
import com.docmosis.util.StringUtilities;
import java.util.ArrayList;
import java.util.Iterator;

class SectionManager {
    private SimpleTemplateSection A;
    private SimpleTemplateSection D;
    private boolean B;
    private static final String C = "There is an OpenOffice bug that removes fields directly after a table which is inside another table (word templates only).  Insert dummy section fields on a line by itself after the table like this: <<cs_false>><<es_>>.  If OpenOffice strips it, no harm done (Docmosis will strip it otherwise).";

    SectionManager() {
    }

    public void startSection(SimpleTemplateSection simpleTemplateSection) {
        this.startSection(simpleTemplateSection, false, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void startSection(SimpleTemplateSection simpleTemplateSection, boolean bl, boolean bl2) {
        if (this.D != null) {
            if (!this.D.isContainer()) throw new IllegalStateException("Cannot add a section to the current section:" + this.D.getClass().getName());
            if (bl2) {
                this.D.addSectionPositioned(simpleTemplateSection, bl, bl2);
            } else {
                this.D.addSection(simpleTemplateSection);
            }
            this.D = simpleTemplateSection;
            return;
        } else {
            if (this.A == null) {
                this.A = simpleTemplateSection;
            }
            this.D = simpleTemplateSection;
        }
    }

    public TemplateSection endSection(Class clazz, long l, ODFContentAnalyzer.BufferedElementList bufferedElementList) throws TemplateParseException {
        return this.endSection(clazz, l, false, bufferedElementList);
    }

    public TemplateSection endSection(Class clazz, long l, boolean bl, ODFContentAnalyzer.BufferedElementList bufferedElementList) throws TemplateParseException {
        SimpleTemplateSection simpleTemplateSection = this.D;
        if (this.D != null) {
            if (clazz != null && this.D.getClass() != clazz) {
                Object object;
                int n;
                long l2 = 0L;
                if (bufferedElementList != null) {
                    for (n = 0; n < bufferedElementList.size(); n += 1) {
                        object = bufferedElementList.get(n);
                        if (!((ODFContentAnalyzer.BufferedElement)object).isTag || !ODFHandlerObfImpl.O(((ODFContentAnalyzer.BufferedElement)object).data)) continue;
                        l2 = ((ODFContentAnalyzer.BufferedElement)object).endIdx + 1L;
                        break;
                    }
                }
                n = l2 == 0L ? 1 : 0;
                Object object2 = object = this.D instanceof TemplateNamedSection ? ((TemplateNamedSection)((Object)this.D)).getSectionName() : null;
                if (this.D.getClass().equals(SimpleTemplateRepeatableSection.class) && (clazz.equals(SimpleTemplateTableCell.class) || clazz.equals(SimpleTemplateTableRow.class))) {
                    if (!clazz.equals(SimpleTemplateTableRow.class)) {
                        String string = FieldParser.DM_REPEATING_ROW_START_PREFIX;
                        if (object != null) {
                            string = string + (String)object;
                            object = FieldParser.DM_REPEATING_SECTION_START_PREFIX + (String)object;
                        }
                        if (object == null) {
                            object = "Repeating Section";
                        }
                        throw new TemplateParseException("\"" + (String)object + "\" field is not matched.", new String[]{"Close the section using the matching close tag", "Did you mean to use \"" + string + "\"?", C}, l2, n != 0);
                    }
                } else if (this.D.getClass().equals(SimpleTemplateConditionalSection.class) && (clazz.equals(SimpleTemplateTableCell.class) || clazz.equals(SimpleTemplateTableRow.class))) {
                    if (!clazz.equals(SimpleTemplateTableRow.class)) {
                        String string = FieldParser.DM_CONDITIONAL_ROW_START_PREFIX;
                        if (object != null) {
                            string = string + (String)object;
                            object = FieldParser.DM_CONDITIONAL_SECTION_START_PREFIX + (String)object;
                        }
                        if (object == null) {
                            object = "Conditional Section";
                        }
                        throw new TemplateParseException("\"" + (String)object + "\" field is not matched.", new String[]{"Close the section using the matching close tag", "Did you mean to use \"" + string + "\"?", C}, l2, n != 0);
                    }
                } else {
                    if (clazz.equals(TemplateListSection.class) && (this.D instanceof SimpleTemplateConditionalSection || this.D instanceof SimpleTemplateRepeatableSection)) {
                        if (object == null) {
                            object = "Conditional Section";
                        }
                        throw new TemplateParseException("\"" + (String)object + "\" end could not be matched.", new String[]{"Make sure your start and end tags are not numbered or bullet styled"}, l2, n != 0);
                    }
                    String string = "Attempt to end a section of different type (current = " + StringUtilities.getShortPeriodSepName(this.D.getClass().getName()) + ", ending = " + StringUtilities.getShortPeriodSepName(clazz.getName()) + ")";
                    if (SimpleTemplateTableCell.class.equals((Object)clazz)) {
                        String[] stringArray = new String[]{C};
                        throw new TemplateParseException(string, stringArray, l2, n != 0);
                    }
                    throw new TemplateParseException(string, null, l2, n != 0);
                }
            }
            this.D.setEndIndex(l);
            if (!(bl || this.D == this.A || this.D.isPopulable() || this.D.isSkipSection())) {
                this.D.getParentSection().removeSection(this.D);
                simpleTemplateSection = null;
            }
        } else {
            throw new TemplateParseException("Attempt to end a section when none open (class = " + clazz + ")", null, 0L, true);
        }
        this.D = this.D.getParentSection();
        return simpleTemplateSection;
    }

    public void addSection(SimpleTemplateSection simpleTemplateSection, long l, ODFContentAnalyzer.BufferedElementList bufferedElementList) throws TemplateParseException {
        this.addSection(simpleTemplateSection, l, false, bufferedElementList);
    }

    public void addSection(SimpleTemplateSection simpleTemplateSection, long l, boolean bl, ODFContentAnalyzer.BufferedElementList bufferedElementList) throws TemplateParseException {
        this.startSection(simpleTemplateSection);
        this.endSection(null, l, bl, bufferedElementList);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SimpleTemplateSkipSection addSkipSection(long l, long l2) throws IllegalStateException {
        SimpleTemplateSkipSection simpleTemplateSkipSection = new SimpleTemplateSkipSection();
        simpleTemplateSkipSection.setStartIndex(l);
        simpleTemplateSkipSection.setEndIndex(l2);
        SimpleTemplateSection simpleTemplateSection = this.D;
        if (simpleTemplateSection != null) {
            boolean bl = false;
            TemplateSection[] templateSectionArray = this.D.getSubSections();
            if (templateSectionArray != null && templateSectionArray.length > 0) {
                for (int i = 0; i < templateSectionArray.length; ++i) {
                    if (!SectionManager.isAppropriateForSection(l, l2, templateSectionArray[i])) continue;
                    if (templateSectionArray[i] instanceof SimpleTemplateSkipSection && ((SimpleTemplateSkipSection)templateSectionArray[i]).getStartIndex() <= l && ((SimpleTemplateSkipSection)templateSectionArray[i]).getEndIndex() >= l2) {
                        bl = true;
                        continue;
                    }
                    if (!(templateSectionArray[i] instanceof SimpleTemplateSection)) continue;
                    if (!this.isMaskedBySkipSection(l, l2, templateSectionArray[i].getSubSections())) {
                        ((SimpleTemplateSection)templateSectionArray[i]).addSectionPositioned(simpleTemplateSkipSection);
                    }
                    bl = true;
                }
            }
            if (bl) return simpleTemplateSkipSection;
            block1: while (simpleTemplateSection != null && !SectionManager.isAppropriateForSection(l, l2, simpleTemplateSection)) {
                if ((simpleTemplateSection = simpleTemplateSection.getParentSection()) == null || simpleTemplateSection.getSubSections() == null) continue;
                TemplateSection[] templateSectionArray2 = simpleTemplateSection.getSubSections();
                for (int i = 0; i < templateSectionArray2.length; ++i) {
                    SimpleTemplateSection simpleTemplateSection2 = (SimpleTemplateSection)templateSectionArray2[i];
                    if (!SectionManager.isAppropriateForSection(l, l2, simpleTemplateSection2)) continue;
                    simpleTemplateSection = simpleTemplateSection2;
                    continue block1;
                }
            }
            if (simpleTemplateSection == null) throw new IllegalStateException("Cannot add a skip section.  No parent sections appropriate to add it to.");
            if (this.isMaskedBySkipSection(simpleTemplateSkipSection.getStartIndex(), simpleTemplateSkipSection.getEndIndex(), simpleTemplateSection.getSubSections())) return simpleTemplateSkipSection;
            simpleTemplateSection.addSectionPositioned(simpleTemplateSkipSection);
            TemplateSection[] templateSectionArray3 = simpleTemplateSection.getSubSections();
            ArrayList<TemplateSection> arrayList = new ArrayList<TemplateSection>();
            for (int i = 0; i < templateSectionArray3.length; ++i) {
                if (!templateSectionArray3[i].isSkipSection() || !(templateSectionArray3[i] instanceof SimpleTemplateSection)) continue;
                if (templateSectionArray3[i].getStartIndex() > simpleTemplateSkipSection.getStartIndex() && templateSectionArray3[i].getEndIndex() < simpleTemplateSkipSection.getEndIndex()) {
                    arrayList.add(templateSectionArray3[i]);
                    continue;
                }
                if (templateSectionArray3[i].getStartIndex() >= simpleTemplateSkipSection.getStartIndex() || templateSectionArray3[i].getEndIndex() <= simpleTemplateSkipSection.getEndIndex()) continue;
                arrayList.add(simpleTemplateSkipSection);
            }
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                simpleTemplateSection.removeSection((SimpleTemplateSection)iterator.next());
            }
            return simpleTemplateSkipSection;
        } else {
            if (this.A == null) throw new IllegalStateException("Cannot add a skip section.  No parent sections appropriate to add it to.");
            this.A.addSectionPositioned(simpleTemplateSkipSection);
        }
        return simpleTemplateSkipSection;
    }

    private boolean isMaskedBySkipSection(long l, long l2, TemplateSection[] templateSectionArray) {
        int n;
        if (templateSectionArray == null || templateSectionArray.length == 0) {
            return false;
        }
        for (n = 0; n < templateSectionArray.length; ++n) {
            TemplateSection templateSection = templateSectionArray[n];
            if (!(templateSection instanceof SimpleTemplateSkipSection) || templateSection.getStartIndex() > l || templateSection.getEndIndex() < l2) continue;
            return true;
        }
        for (n = 0; n < templateSectionArray.length; ++n) {
            if (!this.isMaskedBySkipSection(l, l2, templateSectionArray[n].getSubSections())) continue;
            return true;
        }
        return false;
    }

    private static boolean isAppropriateForSection(long l, long l2, TemplateSection templateSection) {
        if (templateSection instanceof SimpleTemplateRoot) {
            return true;
        }
        return l >= templateSection.getStartIndex() && (l2 <= templateSection.getEndIndex() || templateSection.getEndIndex() == 0L);
    }

    public void addErrorSection(TemplateErrorSection templateErrorSection) {
        this.A.addSection(templateErrorSection);
        this.B = true;
    }

    public boolean hasErrors() {
        return this.B;
    }

    public SimpleTemplateSection getCurrentSection() {
        return this.D;
    }

    public static SimpleTemplateSection getPreviousSiblingSection(SimpleTemplateSection simpleTemplateSection) {
        SimpleTemplateSection simpleTemplateSection2 = null;
        if (simpleTemplateSection != null && simpleTemplateSection.getParentSection() != null) {
            TemplateSection[] templateSectionArray = simpleTemplateSection.getParentSection().getSubSections();
            for (int i = 0; i < templateSectionArray.length; ++i) {
                if (templateSectionArray[i] != simpleTemplateSection) continue;
                if (i <= 0) break;
                simpleTemplateSection2 = (SimpleTemplateSection)templateSectionArray[i - 1];
                break;
            }
        }
        return simpleTemplateSection2;
    }

    public void wrapOverlapped(SimpleTemplateSection simpleTemplateSection) {
        if (simpleTemplateSection.getParentSection() != null) {
            simpleTemplateSection.getParentSection().wrapOverlappedSections(simpleTemplateSection);
        }
    }

    public SimpleTemplateSection getRootSection() {
        return this.A;
    }
}

