/*
 * Decompiled with CFR 0.152.
 */
package com.docmosis.template.analysis.openoffice;

import com.docmosis.document.ExternalResourceCollection;
import com.docmosis.template.analysis.ImageAnalysis;
import com.docmosis.template.analysis.MessageAndSuggestions;
import com.docmosis.template.analysis.ParsedField;
import com.docmosis.template.analysis.SimpleTemplateImage;
import com.docmosis.template.analysis.SimpleTemplateSection;
import com.docmosis.template.analysis.TemplateAnalysis;
import com.docmosis.template.analysis.TemplateErrorSection;
import com.docmosis.template.analysis.TemplateField;
import com.docmosis.template.analysis.TemplateSection;
import com.docmosis.template.analysis.TextWritableSafeAreas;
import com.docmosis.template.analysis.fontmapping.FontInfo;
import com.docmosis.template.analysis.list.ListStyles;
import com.docmosis.template.analysis.list.ListTree;
import com.docmosis.template.analysis.openoffice.ODFManifestAnalysis;
import com.docmosis.template.analysis.sensitivitylabel.SensitivityLabelInfo;
import com.docmosis.util.Equivalence;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class ODFTemplateAnalysis
implements TemplateAnalysis {
    private TemplateSection[] W;
    private TemplateField[] X;
    private long K;
    private TemplateAnalysis P;
    private TemplateAnalysis F;
    private ODFManifestAnalysis Q;
    private String I;
    private boolean d;
    private boolean a;
    private char[] Z;
    private HashMap T;
    private ImageAnalysis G;
    private boolean Y;
    private boolean L;
    private boolean b;
    private boolean U;
    private ListTree J;
    private ListStyles O;
    private final TextWritableSafeAreas H = new TextWritableSafeAreas();
    private boolean e;
    private boolean M;
    private FontInfo N;
    private SensitivityLabelInfo R;
    private ExternalResourceCollection c;
    private boolean V;
    private String S;
    private String _;

    public void setSections(TemplateSection[] templateSectionArray) {
        this.W = templateSectionArray;
        this.setFieldsFromSections();
    }

    @Override
    public TemplateSection[] getSections() {
        return this.W;
    }

    @Override
    public TemplateField[] getFields() {
        return this.X;
    }

    private void setFieldsFromSections() {
        TemplateField[] templateFieldArray = null;
        if (this.W != null && this.W.length > 0) {
            ArrayList arrayList = new ArrayList();
            for (int i = 0; i < this.W.length; ++i) {
                arrayList.addAll(this.getFieldsFromSection(this.W[i]));
            }
            if (arrayList.size() > 0) {
                templateFieldArray = new TemplateField[arrayList.size()];
                arrayList.toArray(templateFieldArray);
            }
        }
        this.X = templateFieldArray;
    }

    private List getFieldsFromSection(TemplateSection templateSection) {
        ArrayList<TemplateSection> arrayList = new ArrayList<TemplateSection>();
        if (templateSection != null) {
            TemplateSection[] templateSectionArray;
            if (templateSection instanceof TemplateField) {
                arrayList.add(templateSection);
            } else if (templateSection.isContainer() && (templateSectionArray = templateSection.getSubSections()) != null) {
                for (int i = 0; i < templateSectionArray.length; ++i) {
                    arrayList.addAll(this.getFieldsFromSection(templateSectionArray[i]));
                }
            }
        }
        return arrayList;
    }

    @Override
    public long getLength() {
        return this.K;
    }

    public void setLength(long l) {
        this.K = l;
    }

    @Override
    public boolean hasTOC() {
        return this.Y;
    }

    public void setHasTOC(boolean bl) {
        this.Y = bl;
    }

    @Override
    public TemplateAnalysis getStyleAnalysis() {
        return this.P;
    }

    public void setStyleAnalysis(TemplateAnalysis templateAnalysis) {
        this.P = templateAnalysis;
    }

    @Override
    public TemplateAnalysis getMetaAnalysis() {
        return this.F;
    }

    public void setMetaAnalysis(TemplateAnalysis templateAnalysis) {
        this.F = templateAnalysis;
    }

    @Override
    public boolean hasDynamicTableStyling() {
        return this.d;
    }

    public void setHasDynamicTableStyling(boolean bl) {
        this.d = bl;
    }

    @Override
    public char[] getStaticNewStyles() {
        return this.Z;
    }

    public void setStaticNewStyles(char[] cArray) {
        this.Z = cArray;
    }

    @Override
    public HashMap getStyleRegistry() {
        return this.T;
    }

    public void setStyleRegistry(HashMap hashMap) {
        this.T = hashMap;
    }

    public ODFManifestAnalysis getManifestAnalysis() {
        return this.Q;
    }

    public void setManifestAnalysis(ODFManifestAnalysis oDFManifestAnalysis) {
        this.Q = oDFManifestAnalysis;
    }

    @Override
    public boolean getProcessedWithExternalConverter() {
        return this.b;
    }

    public void setProcessedWithExternalConverter(boolean bl) {
        this.b = bl;
    }

    @Override
    public boolean getProcessedAllowingPaddedFields() {
        return this.U;
    }

    public void setProcessedAllowingPaddedFields(boolean bl) {
        this.U = bl;
    }

    @Override
    public FontInfo getFontInfo() {
        return this.N;
    }

    public void setFontInfo(FontInfo fontInfo) {
        this.N = fontInfo;
    }

    @Override
    public SensitivityLabelInfo getSensitivityLabelInfo() {
        return this.R;
    }

    public void setSensitivityLabelInfo(SensitivityLabelInfo sensitivityLabelInfo) {
        this.R = sensitivityLabelInfo;
    }

    public void setExternalResources(ExternalResourceCollection externalResourceCollection) {
        this.c = externalResourceCollection;
    }

    @Override
    public ExternalResourceCollection getExternalResources() {
        return this.c;
    }

    public void setHasExternalResourcesPermissionFailures(boolean bl) {
        this.V = bl;
    }

    @Override
    public boolean hasExternalResourcesPermisionFailures() {
        return this.V;
    }

    public boolean equals(Object object) {
        int n;
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof ODFTemplateAnalysis)) {
            return false;
        }
        ODFTemplateAnalysis oDFTemplateAnalysis = (ODFTemplateAnalysis)object;
        if (this.K != oDFTemplateAnalysis.K || this.d != oDFTemplateAnalysis.d || this.a != oDFTemplateAnalysis.a || this.L != oDFTemplateAnalysis.L || this.b != oDFTemplateAnalysis.b || this.U != oDFTemplateAnalysis.U) {
            return false;
        }
        if (this.Y != oDFTemplateAnalysis.Y) {
            return false;
        }
        if (this.e != oDFTemplateAnalysis.e) {
            return false;
        }
        if (this.M != oDFTemplateAnalysis.M) {
            return false;
        }
        if (!Equivalence.equivalentObjects(this.I, oDFTemplateAnalysis.getOriginalMD5())) {
            return false;
        }
        if (!Equivalence.equivalentObjects(this.S, oDFTemplateAnalysis.S)) {
            return false;
        }
        if (!Equivalence.equivalentObjects(this._, oDFTemplateAnalysis._)) {
            return false;
        }
        if (!Equivalence.bothNullOrBothNotNull(this.W, oDFTemplateAnalysis.W)) {
            return false;
        }
        if (this.W != null) {
            if (this.W.length != oDFTemplateAnalysis.W.length) {
                return false;
            }
            for (n = 0; n < this.W.length; ++n) {
                if (Equivalence.equivalentObjects(this.W[n], oDFTemplateAnalysis.W[n])) continue;
                return false;
            }
        }
        if (!Equivalence.bothNullOrBothNotNull(this.X, oDFTemplateAnalysis.X)) {
            return false;
        }
        if (this.getFields() != null) {
            if (this.X.length != oDFTemplateAnalysis.X.length) {
                return false;
            }
            for (n = 0; n < this.X.length; ++n) {
                if (Equivalence.equivalentObjects(this.X[n], oDFTemplateAnalysis.X[n])) continue;
                return false;
            }
        }
        if (!Equivalence.equivalentObjects(this.Z, oDFTemplateAnalysis.Z)) {
            return false;
        }
        if (!Equivalence.equivalentObjects(this.Q, oDFTemplateAnalysis.Q)) {
            return false;
        }
        if (!Equivalence.equivalentObjects(this.G, oDFTemplateAnalysis.G)) {
            return false;
        }
        if (!Equivalence.equivalentObjects(this.H, oDFTemplateAnalysis.H)) {
            return false;
        }
        if (!Equivalence.equivalentObjects(this.J, oDFTemplateAnalysis.J)) {
            return false;
        }
        if (!Equivalence.equivalentObjects(this.O, oDFTemplateAnalysis.O)) {
            return false;
        }
        if (this.N == null ? oDFTemplateAnalysis.N != null : !this.N.equals(oDFTemplateAnalysis.N)) {
            return false;
        }
        if (this.R == null ? oDFTemplateAnalysis.R != null : !this.R.equals(oDFTemplateAnalysis.R)) {
            return false;
        }
        if (!Equivalence.equivalentObjects(this.c, oDFTemplateAnalysis.c)) {
            return false;
        }
        return this.V == oDFTemplateAnalysis.V;
    }

    public int hashCode() {
        return (int)(this.K + (long)(this.d ? 141 : 155581) + (long)(this.a ? 5341 : 3445587) + (long)(this.L ? 235 : 156124) + (long)(this.I == null ? 11 : this.I.hashCode()) + (long)(this.W == null ? 15 : this.W.length) + (long)(this.X == null ? 121 : this.X.length) + (long)(this.Y ? 2346 : 636) + (long)(this.b ? 2246346 : 63663465) + (long)(this.U ? 75657 : 5678567) + (long)(this.Z == null ? 51523431 : this.Z.hashCode()) + (long)(this.Q == null ? 21252345 : this.Q.hashCode()) + (long)(this.S == null ? 23523461 : this.S.hashCode()) + (long)(this._ == null ? 562345621 : this._.hashCode()) + (long)this.H.hashCode() + (long)(this.J == null ? 262345 : this.J.hashCode()) + (this.O == null ? 823452L : (long)this.O.hashCode()) + (this.e ? 2388523L : 12344L) + (this.M ? 4572190L : 63421L) + (this.N == null ? 563489L : (long)this.N.hashCode()) + (this.R == null ? 489523L : (long)this.R.hashCode()) + (this.c == null ? 258674L : (long)this.c.hashCode()) + (long)(this.V ? 523 : 6324));
    }

    @Override
    public String getOriginalMD5() {
        return this.I;
    }

    public void setOriginalMD5(String string) {
        this.I = string;
    }

    @Override
    public boolean hasTemplateErrors() {
        return this.a || this.F != null && this.F.hasTemplateErrors() || this.P != null && this.P.hasTemplateErrors();
    }

    public void setTemplateErrors(boolean bl) {
        this.a = bl;
    }

    public void linkBarcodesToImages(final List list) {
        this.walkSections(new _A(){

            @Override
            public void A(TemplateSection templateSection) {
                if (templateSection instanceof SimpleTemplateImage) {
                    SimpleTemplateImage simpleTemplateImage = (SimpleTemplateImage)templateSection;
                    String string = simpleTemplateImage.getLookupName();
                    boolean bl = false;
                    if (string.startsWith("$")) {
                        bl = true;
                        string = string.substring(1);
                    } else if (string.startsWith("var_")) {
                        bl = true;
                        string = string.substring(4);
                    }
                    Iterator iterator = list.iterator();
                    while (iterator.hasNext()) {
                        ParsedField parsedField = (ParsedField)iterator.next();
                        String string2 = parsedField.getLastTerm().getLookupName();
                        if (!string.equals(string2) || bl != parsedField.getLastTerm().isVariable()) continue;
                        simpleTemplateImage.setBarcodeInfo(parsedField.getBarcodeInfo());
                        iterator.remove();
                        break;
                    }
                }
            }
        });
    }

    private void walkSections(_A _A2) {
        this.walkSections(this.W, _A2);
    }

    private void walkSections(TemplateSection[] templateSectionArray, _A _A2) {
        if (templateSectionArray == null) {
            return;
        }
        for (int i = 0; i < templateSectionArray.length; ++i) {
            _A2.A(templateSectionArray[i]);
            this.walkSections(templateSectionArray[i].getSubSections(), _A2);
        }
    }

    @Override
    public MessageAndSuggestions[] getTemplateErrorMessages() {
        MessageAndSuggestions[] messageAndSuggestionsArray = null;
        if (this.W[0] != null && this.W[0].getSubSections() != null && this.W[0].getSubSections().length > 0) {
            ArrayList<MessageAndSuggestions> arrayList = new ArrayList<MessageAndSuggestions>();
            TemplateSection[] templateSectionArray = this.W[0].getSubSections();
            for (int i = 0; i < templateSectionArray.length; ++i) {
                if (!(templateSectionArray[i] instanceof TemplateErrorSection)) continue;
                TemplateErrorSection templateErrorSection = (TemplateErrorSection)templateSectionArray[i];
                arrayList.add(new MessageAndSuggestions(templateErrorSection.getMessage(), templateErrorSection.getSuggestions()));
            }
            if (arrayList.size() > 0) {
                messageAndSuggestionsArray = new MessageAndSuggestions[arrayList.size()];
                arrayList.toArray(messageAndSuggestionsArray);
            }
        }
        return messageAndSuggestionsArray;
    }

    public String getPlainTextFieldPrefix() {
        return this.S;
    }

    public void setPlainTextFieldPrefix(String string) {
        this.S = string;
    }

    public String getPlainTextFieldSuffix() {
        return this._;
    }

    public void setPlainTextFieldSuffix(String string) {
        this._ = string;
    }

    @Override
    public ImageAnalysis getTemplateImages() {
        return this.G;
    }

    public void setTemplateImages(ImageAnalysis imageAnalysis) {
        this.G = imageAnalysis;
    }

    @Override
    public boolean hasTableWithMergedNonBreakingRows() {
        return this.L;
    }

    public void setHasTableWithMergedNonBreakingRows(boolean bl) {
        this.L = bl;
    }

    public void addWritableArea(long l, long l2, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this.H.add(l, l2, bl, bl2, bl3, bl4);
    }

    @Override
    public TextWritableSafeAreas getWritableSafeAreas() {
        return this.H;
    }

    public String toString() {
        return this.toDebugString();
    }

    public String toDebugString() {
        return this.toDebugString(0);
    }

    @Override
    public ListTree getListTree() {
        return this.J;
    }

    public void setListTree(ListTree listTree) {
        this.J = listTree;
    }

    @Override
    public ListStyles getListStyles() {
        return this.O;
    }

    public void setListStyles(ListStyles listStyles) {
        this.O = listStyles;
    }

    @Override
    public boolean isCoordinatorTemplate() {
        return this.e;
    }

    public void setCoordinatorTemplate(boolean bl) {
        this.e = bl;
    }

    @Override
    public boolean hasFieldStyleOverride() {
        return this.M;
    }

    public void setHasFieldStyleOverride(boolean bl) {
        this.M = bl;
    }

    protected String toDebugString(int n) {
        int n2;
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append("  ");
        }
        String string = stringBuffer.toString();
        StringBuffer stringBuffer2 = new StringBuffer();
        if (n == 0) {
            stringBuffer2.append("*** ODFTemplateAnalysis ***");
        }
        stringBuffer2.append("\n");
        stringBuffer2.append(string);
        stringBuffer2.append("Length: ");
        stringBuffer2.append(this.K);
        stringBuffer2.append("\n");
        stringBuffer2.append(string);
        stringBuffer2.append("dynamicTableCellStyling: ");
        stringBuffer2.append(this.d);
        stringBuffer2.append("\n");
        stringBuffer2.append(string);
        stringBuffer2.append("templateErrors: ");
        stringBuffer2.append(this.a);
        stringBuffer2.append("\n");
        stringBuffer2.append(string);
        stringBuffer2.append("hasTOC: ");
        stringBuffer2.append(this.Y);
        stringBuffer2.append("\n");
        stringBuffer2.append(string);
        stringBuffer2.append("processedWithExternalConverter: ");
        stringBuffer2.append(this.b);
        stringBuffer2.append("\n");
        stringBuffer2.append(string);
        stringBuffer2.append("processedAllowingPaddedFields: ");
        stringBuffer2.append(this.U);
        stringBuffer2.append("\n");
        stringBuffer2.append(string);
        stringBuffer2.append("isCoordinator: ");
        stringBuffer2.append(this.e);
        stringBuffer2.append("\n");
        stringBuffer2.append(string);
        stringBuffer2.append("hasFieldStyleOverride: ");
        stringBuffer2.append(this.M);
        stringBuffer2.append("\n");
        stringBuffer2.append(string);
        stringBuffer2.append("Original MD5: ");
        stringBuffer2.append(this.I);
        stringBuffer2.append('\n');
        stringBuffer2.append(string);
        stringBuffer2.append("Plain text field prefix: [").append(this.S).append(']');
        stringBuffer2.append('\n');
        stringBuffer2.append(string);
        stringBuffer2.append("Plain text field suffix: [").append(this._).append(']');
        stringBuffer2.append("\n");
        stringBuffer2.append(string);
        stringBuffer2.append("New Styles: ");
        stringBuffer2.append(this.Z == null ? "<null>" : String.valueOf(this.Z));
        stringBuffer2.append("\n");
        stringBuffer2.append(string);
        if (this.P != null) {
            stringBuffer2.append("Style Analysis: {");
            if (this.P instanceof ODFTemplateAnalysis) {
                stringBuffer2.append(((ODFTemplateAnalysis)this.P).toDebugString(n + 1));
            } else {
                stringBuffer2.append(this.P.toString());
            }
            stringBuffer2.append("\n");
            stringBuffer2.append(string);
            stringBuffer2.append("}");
        } else {
            stringBuffer2.append("Style Analysis: null");
        }
        stringBuffer2.append("\n");
        stringBuffer2.append(string);
        if (this.F != null) {
            stringBuffer2.append("Meta Analysis: {");
            if (this.F instanceof ODFTemplateAnalysis) {
                stringBuffer2.append(((ODFTemplateAnalysis)this.F).toDebugString(n + 1));
            } else {
                stringBuffer2.append(this.F.toString());
            }
            stringBuffer2.append("\n");
            stringBuffer2.append(string);
            stringBuffer2.append("}");
        } else {
            stringBuffer2.append("Meta Analysis: null");
        }
        stringBuffer2.append("\n");
        stringBuffer2.append(string);
        if (this.Q != null) {
            stringBuffer2.append("Manifest Analysis: {");
            if (this.Q instanceof ODFTemplateAnalysis) {
                stringBuffer2.append(((ODFTemplateAnalysis)this.Q).toDebugString(n + 1));
            } else {
                stringBuffer2.append(this.Q.toString());
            }
            stringBuffer2.append("\n");
            stringBuffer2.append(string);
            stringBuffer2.append("}");
        } else {
            stringBuffer2.append("Manifest Analysis: null");
        }
        if (this.X != null) {
            for (n2 = 0; n2 < this.X.length; ++n2) {
                stringBuffer2.append("\n");
                stringBuffer2.append(string);
                stringBuffer2.append("Field Name [");
                stringBuffer2.append(n2);
                stringBuffer2.append("]: ");
                if (this.X[n2] != null) {
                    stringBuffer2.append(this.X[n2].getFieldName());
                    continue;
                }
                stringBuffer2.append("\n");
                stringBuffer2.append(string);
                stringBuffer2.append("null");
            }
        }
        if (this.W != null) {
            for (n2 = 0; n2 < this.W.length; ++n2) {
                stringBuffer2.append("\n");
                stringBuffer2.append(string);
                if (this.W[n2] != null) {
                    stringBuffer2.append("Section: {");
                    if (this.W[n2] instanceof SimpleTemplateSection) {
                        stringBuffer2.append(((SimpleTemplateSection)this.W[n2]).toDebugString(n + 1));
                    } else {
                        stringBuffer2.append(this.W[n2].toString());
                    }
                    stringBuffer2.append("\n");
                    stringBuffer2.append(string);
                    stringBuffer2.append("}");
                    continue;
                }
                stringBuffer2.append("Section: null");
            }
        }
        return stringBuffer2.toString();
    }

    private static interface _A {
        public void A(TemplateSection var1);
    }
}

