/*
 * Decompiled with CFR 0.152.
 */
package com.docmosis.template.analysis.openoffice;

import com.docmosis.template.TemplateParseException;
import com.docmosis.template.analysis.TemplateAnalysis;
import com.docmosis.template.analysis.list.ListStyles;
import com.docmosis.template.analysis.openoffice.ODFHandlerObfImpl;
import com.docmosis.template.analysis.openoffice.ODFTemplateAnalysis;
import com.docmosis.template.analysis.openoffice.ProcessingContentFile;
import com.docmosis.template.analysis.openoffice.XMLComponentHandler;
import com.docmosis.util.DMProperties;
import com.docmosis.util.J;
import com.docmosis.util.properties.PropertiesProvider;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Iterator;

public class ODFContentAnalyzer {
    private static final int F = DMProperties.getInt("docmosis.stream.buffer.size");
    private final int B = DMProperties.getInt("docmosis.analyzer.history.size", 10);
    private XMLStreamReader A = new XMLStreamReader();
    private final ProcessingContentFile E;
    private final TemplateAnalysis C;
    private J D;
    private ListStyles G;

    public ODFContentAnalyzer(ProcessingContentFile processingContentFile, TemplateAnalysis templateAnalysis) {
        this.E = processingContentFile;
        this.C = templateAnalysis;
    }

    public ODFTemplateAnalysis process(InputStream inputStream, boolean bl, String string, String string2, boolean bl2, PropertiesProvider propertiesProvider) throws IOException, TemplateParseException {
        return this.process(inputStream, bl, string, string2, false, bl2, propertiesProvider);
    }

    public ODFTemplateAnalysis process(InputStream inputStream, boolean bl, String string, String string2, boolean bl2, boolean bl3, PropertiesProvider propertiesProvider) throws IOException, TemplateParseException {
        ODFTemplateAnalysis oDFTemplateAnalysis = new ODFTemplateAnalysis();
        if (this.C != null) {
            oDFTemplateAnalysis.setExternalResources(this.C.getExternalResources());
            oDFTemplateAnalysis.setHasExternalResourcesPermissionFailures(this.C.hasExternalResourcesPermisionFailures());
        }
        _A _A2 = new _A(new ODFHandlerObfImpl(oDFTemplateAnalysis, this.E, bl, string, string2, bl3, propertiesProvider), this.B);
        _A2.setSkipFinalAnalysisValidation(bl2);
        if (this.E.isStyles()) {
            _A2.setStylesToPromoteToStylesXml(this.getStylesToPromoteToStylesXml());
            _A2.setListStylesOfInterest(this.getListStylesOfInterest());
        }
        this.A.process(inputStream, _A2);
        if (!this.E.isStyles()) {
            this.D = _A2.getStylesToPromoteToStylesXml();
            this.setListStylesOfInterest(_A2.getListStylesOfInterest());
        }
        oDFTemplateAnalysis.setListStyles(this.getListStylesOfInterest());
        return oDFTemplateAnalysis;
    }

    public J getStylesToPromoteToStylesXml() {
        return this.D;
    }

    public void setStylesToPromoteToStylesXml(J j) {
        this.D = j;
    }

    public ListStyles getListStylesOfInterest() {
        return this.G;
    }

    public void setListStylesOfInterest(ListStyles listStyles) {
        this.G = listStyles;
    }

    static /* synthetic */ int access$000() {
        return F;
    }

    public static class BufferedElement {
        final J data;
        final long endIdx;
        final boolean isTag;

        public BufferedElement(J j, long l, boolean bl) {
            this.data = j;
            this.isTag = bl;
            this.endIdx = l;
        }

        public long getStartIdx() {
            return this.endIdx - (long)this.data.E() + 1L;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.isTag ? "TAG   " : "CHUNK ");
            stringBuffer.append("[end:").append(this.endIdx).append("]");
            stringBuffer.append(" [").append(this.data == null ? "<NULL>" : this.data.toString()).append(']');
            return stringBuffer.toString();
        }
    }

    public static class BufferedElementList {
        private final ArrayList A;

        public int size() {
            return this.A.size();
        }

        public BufferedElementList() {
            this.A = new ArrayList();
        }

        public BufferedElementList(BufferedElementList bufferedElementList) {
            this.A = bufferedElementList == null ? new ArrayList() : new ArrayList(bufferedElementList.A);
        }

        public BufferedElement get(int n) {
            return (BufferedElement)this.A.get(n);
        }

        public BufferedElement remove(int n) {
            return (BufferedElement)this.A.remove(n);
        }

        public void add(BufferedElement bufferedElement) {
            this.A.add(bufferedElement);
        }

        public void add(int n, BufferedElement bufferedElement) {
            this.A.add(n, bufferedElement);
        }

        public Iterator iterator() {
            return new _A(this);
        }

        public String toString() {
            if (this.A == null) {
                return "<null>";
            }
            if (this.A.isEmpty()) {
                return "<empty>";
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("list=");
            Iterator iterator = this.A.iterator();
            while (iterator.hasNext()) {
                stringBuffer.append(iterator.next().toString());
                stringBuffer.append('\n');
            }
            return stringBuffer.toString();
        }

        private static class _A
        implements Iterator {
            private BufferedElementList B;
            private int A = -1;

            public _A(BufferedElementList bufferedElementList) {
                this.B = bufferedElementList;
            }

            @Override
            public boolean hasNext() {
                return this.A < this.B.size() - 1;
            }

            public Object next() {
                return this.B.get(++this.A);
            }

            @Override
            public void remove() {
                this.B.remove(this.A--);
            }
        }
    }

    private static class _A
    implements XMLComponentHandler {
        private final BufferedElementList c = new BufferedElementList();
        private final BufferedElementList _ = new BufferedElementList();
        private final XMLComponentHandler b;
        private final int a;

        public _A(XMLComponentHandler xMLComponentHandler, int n) {
            this.b = xMLComponentHandler;
            this.a = n;
        }

        @Override
        public void contentChunk(J j, long l, BufferedElementList bufferedElementList, BufferedElementList bufferedElementList2) throws IOException, TemplateParseException {
            this.A(j, l, false);
        }

        @Override
        public void tag(J j, long l, BufferedElementList bufferedElementList, BufferedElementList bufferedElementList2) throws IOException, TemplateParseException {
            this.A(j, l, true);
        }

        @Override
        public void setSkipFinalAnalysisValidation(boolean bl) {
            this.b.setSkipFinalAnalysisValidation(bl);
        }

        private void A(J j, long l, boolean bl) throws IOException, TemplateParseException {
            this._.add(new BufferedElement(J.B(j), l, bl));
            if (this._.size() == this.a) {
                BufferedElement bufferedElement = this._.remove(0);
                this.A(bufferedElement);
                this.c.add(0, bufferedElement);
                if (this.c.size() > this.a) {
                    this.c.remove(this.c.size() - 1);
                }
            }
        }

        private void A(BufferedElement bufferedElement) throws IOException, TemplateParseException {
            if (bufferedElement.isTag) {
                this.b.tag(bufferedElement.data, bufferedElement.endIdx, this.c, this._);
            } else {
                this.b.contentChunk(bufferedElement.data, bufferedElement.endIdx, this.c, this._);
            }
        }

        @Override
        public void finish(long l, BufferedElementList bufferedElementList) throws IOException, TemplateParseException {
            while (this._.size() > 0) {
                BufferedElement bufferedElement = this._.remove(0);
                this.A(bufferedElement);
                this.c.add(0, bufferedElement);
                if (this.c.size() <= this.a) continue;
                this.c.remove(this.c.size() - 1);
            }
            this.b.finish(l, this.c);
        }

        @Override
        public J getStylesToPromoteToStylesXml() {
            return this.b.getStylesToPromoteToStylesXml();
        }

        @Override
        public void setStylesToPromoteToStylesXml(J j) {
            this.b.setStylesToPromoteToStylesXml(j);
        }

        @Override
        public ListStyles getListStylesOfInterest() {
            return this.b.getListStylesOfInterest();
        }

        @Override
        public void setListStylesOfInterest(ListStyles listStyles) {
            this.b.setListStylesOfInterest(listStyles);
        }
    }

    public static class XMLStreamReader {
        private final J B = new J(ODFContentAnalyzer.access$000());
        private char[] A = new char[ODFContentAnalyzer.access$000()];

        public void process(InputStream inputStream, XMLComponentHandler xMLComponentHandler) throws IOException, TemplateParseException {
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream, Charset.forName("UTF-8"));
            boolean bl = false;
            long l = 0L;
            int n = 0;
            long l2 = 0L;
            l2 = inputStreamReader.read(this.A);
            while (l2 != -1L) {
                char c;
                while ((c = this.A[n++]) != '\uffffffff') {
                    if (bl) {
                        if (c == '>') {
                            this.B.B('>');
                            xMLComponentHandler.tag(this.B, l, null, null);
                            this.B.B();
                            bl = false;
                        } else {
                            this.B.B(c);
                        }
                    } else if (c == '<') {
                        if (this.B.E() != 0) {
                            xMLComponentHandler.contentChunk(this.B, l - 1L, null, null);
                            this.B.B();
                        }
                        bl = true;
                        this.B.B('<');
                    } else {
                        this.B.B(c);
                    }
                    ++l;
                    if ((long)n < l2) continue;
                }
                l2 = inputStreamReader.read(this.A);
                n = 0;
            }
            if (bl) {
                throw new IOException("EOF while tag open");
            }
            xMLComponentHandler.finish(l, null);
        }
    }
}

