/*
 * Decompiled with CFR 0.152.
 */
package com.docmosis.template.analysis.openoffice;

import com.docmosis.template.TemplateParseException;
import com.docmosis.template.analysis.ParsedField;
import com.docmosis.template.analysis.barcode.BarcodeException;
import com.docmosis.template.analysis.barcode.BarcodeInfo;
import com.docmosis.template.analysis.barcode.BarcodeInfoFactory;
import com.docmosis.template.analysis.barcode.BarcodeType;
import com.docmosis.template.analysis.openoffice.ODFHandlerObfImpl;
import com.docmosis.template.analysis.openoffice.expression.DocmosisExpression;
import com.docmosis.template.analysis.parsing.FieldParserCommon;
import com.docmosis.template.analysis.sorting.SortDescription;
import com.docmosis.template.analysis.sorting.SortDescriptionAlphaNum;
import com.docmosis.template.analysis.sorting.SortDescriptionDate;
import com.docmosis.template.analysis.sorting.SortDescriptionNumber;
import com.docmosis.template.analysis.sorting.SortDescriptionString;
import com.docmosis.template.population.openoffice.ContentStreamPopulatorObfImpl;
import com.docmosis.util.DMProperties;
import com.docmosis.util.StringUtilities;
import com.docmosis.util.xml.XMLUtilities;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import net.sourceforge.jeval.com.docmosis.EvaluationException;
import net.sourceforge.jeval.com.docmosis.Evaluator;

public class FieldParser {
    public static final String DM_REPEATING_SECTION_START_PREFIX = DMProperties.getString("docmosis.analyzer.section.repeating.start.prefix");
    public static final String DM_CONDITIONAL_SECTION_START_PREFIX = DMProperties.getString("docmosis.analyzer.section.conditional.start.prefix");
    public static final String DM_CONDITIONAL_SECTION_ELSECS_START_PREFIX = DMProperties.getString("docmosis.analyzer.section.conditional.elsecs.start.prefix");
    public static final String DM_CONDITIONAL_SECTION_ELSE_START_PREFIX = DMProperties.getString("docmosis.analyzer.section.conditional.else.start.prefix");
    public static final String DM_SECTION_END_PREFIX = DMProperties.getString("docmosis.analyzer.section.end.prefix");
    public static final String DM_REPEATING_ROW_START_PREFIX = DMProperties.getString("docmosis.analyzer.row.repeating.start.prefix");
    public static final String DM_CONDITIONAL_ROW_START_PREFIX = DMProperties.getString("docmosis.analyzer.row.conditional.start.prefix");
    public static final String DM_REPEATING_OR_CONDITIONAL_ROW_END_PREFIX = DMProperties.getString("docmosis.analyzer.row.repeatingOrConditional.end.prefix");
    public static final String DM_CONDITIONAL_COLUMN_PREFIX = DMProperties.getString("docmosis.analyzer.column.conditional.prefix");
    public static final String DM_HYPERLINK_FIELD_PREFIX = DMProperties.getString("docmosis.analyzer.field.hyperlink.prefix");
    public static final String DM_HYPERLINK_FIELD_PREFIX_LEGACY = DMProperties.getString("docmosis.analyzer.field.hyperlink.prefix.legacy");
    public static final String DM_TEMPLATE_REF_PREFIX = DMProperties.getString("docmosis.analyzer.field.templateRef.prefix");
    public static final String DM_TEMPLATE_REFLOOKUP_PREFIX = DMProperties.getString("docmosis.analyzer.field.templateRefLookup.prefix");
    public static final String DM_TEMPLATE_REFLOOKUP_OPTIONAL_PREFIX = DMProperties.getString("docmosis.analyzer.field.templateRefOptionalLookup.prefix");
    public static final String DM_PAGE_BREAK = "pageBreak";
    public static final String DM_PAGE_BREAK_NOT_LAST = "pageBreakNotLast";
    public static final String DM_COLUMN_BREAK = "columnBreak";
    public static final String DM_COLUMN_BREAK_NOT_LAST = "columnBreakNotLast";
    public static final String NO_TABLE_ROW_ALTERNATE = "noTableRowAlternate";
    public static final String DM_TEMPLATE_HTML_INJECT_LOOKUP_PREFIX = DMProperties.getString("docmosis.analyzer.field.templateHtmlInjectLookup.prefix");
    public static final String DM_BARCODE_FIELD = DMProperties.getString("docmosis.analyzer.field.barcode.prefix");
    public static final String DM_COORDINATOR_FIELD = "coordinator:";
    public static final String DM_COORDINATOR_PARAM_PAD_TO_EVEN_PAGE = "padToEvenPage";
    public static final String DM_COORDINATOR_PARAM_PAD_TO_ODD_PAGE = "padToOddPage";
    public static final String DM_COORDINATOR_PARAM_NEW_FILE = "newFile";
    public static final String DM_QRCODE_FIELD = DMProperties.getString("docmosis.analyzer.field.qrcode.prefix");
    public static final String DM_DUMP_FIELD = DMProperties.getString("docmosis.analyzer.field.dump.prefix");
    public static final String DM_DUMP_VERSIONS_FIELD = DMProperties.getString("docmosis.analyzer.field.dumpVersions.prefix");
    public static final String DM_FIELD_STYLE_SETTING_TEXT_COLOUR_PREFIX = DMProperties.getString("docmosis.analyzer.field.styleSettingOverrides.textColour.prefix");
    private static final int N = DMProperties.getInt("docmosis.analyzer.repeating.stepSize.min", 1);
    private static final int V = DMProperties.getInt("docmosis.analyzer.repeating.stepSize.max", 200000);
    private static final int E = DMProperties.getInt("docmosis.populator.functions.arrays.maxLen", 10000);
    private static final String C = ":step";
    private static final String B = "down";
    private static final String W = ":array";
    private static final String X = ":sort";
    private static final String P = ":sortStr";
    private static final String Z = ":sortNum";
    private static final String D = ":sortDate";
    private static final String[] M = new String[]{":sort", ":sortStr", ":sortNum", ":sortDate"};
    private static final String L = "ASC";
    private static final String J = "DESC";
    private static final String G = "NULLS_FIRST";
    private static final String H = "NULLS_LAST";
    private static final String _ = "CASE_SENSITIVE";
    private static final String O = "CASE_INSENSITIVE";
    private static final String K = ":filter";
    private static final String R = ":group";
    private static final String T = "section";
    private static final String Q = "renderer";
    private static final String U = "id";
    private static final String Y = "var_";
    private static final String I = "var_forgiving_";
    private static final String S = DMProperties.getString("docmosis.analyzer.field.listContinue");
    private static final String F = DMProperties.getString("docmosis.analyzer.field.listReset");
    public static final char CHAR_DODGY_WORD_SINGLE_OPEN_QUOTE = '\u2018';
    public static final char CHAR_DODGY_WORD_SINGLE_CLOSE_QUOTE = '\u2019';
    public static final char CHAR_DODGY_WORD_DOUBLE_OPEN_QUOTE = '\u201c';
    public static final char CHAR_DODGY_WORD_DOUBLE_CLOSE_QUOTE = '\u201d';
    public static final char CHAR_DODGY_WORD_LONG_HYPHEN = '\u2013';
    public static final char CHAR_OTHER_DODGY_WORD_LONG_HYPHEN = '\u2014';
    private static final String A = BarcodeInfoFactory.BARCODE_SETTING_SEPARATOR;
    public static final String VARIABLE_GROUP_ITEMS = "groupItems";

    public static ParsedField parse(String string) throws TemplateParseException {
        return FieldParser.parse(string, false);
    }

    public static ParsedField parse(String string, boolean bl) throws TemplateParseException {
        ParsedField parsedField;
        string = XMLUtilities.decode(string);
        string = string.replace('\u2018', '\'');
        if (StringUtilities.isEmpty(string = string.replace('\u2019', '\''))) {
            parsedField = new ParsedField(ParsedField.FieldType.OF_NO_INTEREST, string);
        } else if (string.charAt(0) == '{') {
            parsedField = FieldParser.parseExpressionField(string);
        } else if (string.startsWith(DM_REPEATING_SECTION_START_PREFIX)) {
            String string2 = string.substring(DM_REPEATING_SECTION_START_PREFIX.length());
            parsedField = new ParsedField(ParsedField.FieldType.REPEATING_SECTION_START, string, string2);
            parsedField.setTerms(FieldParser.parseName(string2, false, true));
        } else if (string.startsWith(DM_CONDITIONAL_SECTION_START_PREFIX)) {
            String string3 = string.substring(DM_CONDITIONAL_SECTION_START_PREFIX.length());
            parsedField = new ParsedField(ParsedField.FieldType.CONDITIONAL_SECTION_START, string, string3);
            FieldParser.parseNameOrExpr(string3, parsedField, false, false);
        } else if (string.startsWith(DM_CONDITIONAL_SECTION_ELSECS_START_PREFIX)) {
            String string4 = string.substring(DM_CONDITIONAL_SECTION_ELSECS_START_PREFIX.length());
            parsedField = new ParsedField(ParsedField.FieldType.CONDITIONAL_SECTION_ELSECS_START, string, string4);
            FieldParser.parseNameOrExpr(string4, parsedField, false, false);
        } else if (string.startsWith(DM_CONDITIONAL_SECTION_ELSE_START_PREFIX)) {
            String string5 = string.substring(DM_CONDITIONAL_SECTION_ELSE_START_PREFIX.length());
            parsedField = new ParsedField(ParsedField.FieldType.CONDITIONAL_SECTION_ELSE_START, string, string5);
            FieldParser.parseNameOrExpr(string5, parsedField, false, false);
        } else if (string.startsWith(DM_SECTION_END_PREFIX)) {
            String string6 = string.substring(DM_SECTION_END_PREFIX.length());
            parsedField = new ParsedField(ParsedField.FieldType.SECTION_END, string, string6);
            FieldParser.parseNameOrExpr(string6, parsedField, false, true);
        } else if (string.startsWith(DM_REPEATING_ROW_START_PREFIX)) {
            String string7 = string.substring(DM_REPEATING_ROW_START_PREFIX.length());
            parsedField = new ParsedField(ParsedField.FieldType.REPEATING_TABLE_ROW_START, string, string7);
            parsedField.setTerms(FieldParser.parseName(string7, false, true));
        } else if (string.startsWith(DM_CONDITIONAL_ROW_START_PREFIX)) {
            String string8 = string.substring(DM_CONDITIONAL_ROW_START_PREFIX.length());
            parsedField = new ParsedField(ParsedField.FieldType.CONDITIONAL_TABLE_ROW_START, string, string8);
            FieldParser.parseNameOrExpr(string8, parsedField, false, false);
        } else if (string.startsWith(DM_REPEATING_OR_CONDITIONAL_ROW_END_PREFIX)) {
            String string9 = string.substring(DM_REPEATING_OR_CONDITIONAL_ROW_END_PREFIX.length());
            parsedField = new ParsedField(ParsedField.FieldType.REPEATING_OR_CONDITIONAL_TABLE_ROW_END, string, string9);
            FieldParser.parseNameOrExpr(string9, parsedField, false, true);
        } else if (string.startsWith(DM_CONDITIONAL_COLUMN_PREFIX)) {
            String string10 = string.substring(DM_CONDITIONAL_COLUMN_PREFIX.length());
            parsedField = new ParsedField(ParsedField.FieldType.CONDITIONAL_COLUMN, string, string10);
            FieldParser.parseNameOrExpr(string10, parsedField, false, false);
        } else if (FieldParser.isSetVariableField(string)) {
            parsedField = FieldParser.parseSetVariableField(string);
            FieldParser.validateSetVariableField(parsedField, string);
        } else if (string.startsWith("$") || string.startsWith(Y)) {
            parsedField = FieldParser.parseLookupField(string, ParsedField.FieldType.GET_VARIABLE, ParsedField.StripParagraphMode.STRIP_NEVER);
            FieldParser.validateLookupField(parsedField, string, bl);
        } else if (string.startsWith(DM_HYPERLINK_FIELD_PREFIX) || string.startsWith(DM_HYPERLINK_FIELD_PREFIX_LEGACY)) {
            String string11 = string.startsWith(DM_HYPERLINK_FIELD_PREFIX) ? DM_HYPERLINK_FIELD_PREFIX : DM_HYPERLINK_FIELD_PREFIX_LEGACY;
            String string12 = string.substring(string11.length());
            parsedField = new ParsedField(ParsedField.FieldType.HYPERLINK, string, string12);
            FieldParser.parseNameOrExpr(string12, parsedField, false, false);
            FieldParser.validateLookupField(parsedField, string12, bl);
        } else if (string.startsWith(DM_TEMPLATE_REF_PREFIX)) {
            String string13 = string.substring(DM_TEMPLATE_REF_PREFIX.length());
            parsedField = new ParsedField(ParsedField.FieldType.TEMPLATE_REF, string, string13);
            FieldParser.validateLookupField(parsedField, string13, bl);
        } else if (string.startsWith(DM_TEMPLATE_REFLOOKUP_PREFIX)) {
            String string14 = string.substring(DM_TEMPLATE_REFLOOKUP_PREFIX.length());
            parsedField = new ParsedField(ParsedField.FieldType.TEMPLATE_LOOKUP_REF, string, string14);
            FieldParser.parseNameOrExpr(string14, parsedField, false, false);
            FieldParser.validateLookupField(parsedField, string14, bl);
        } else if (string.startsWith(DM_TEMPLATE_REFLOOKUP_OPTIONAL_PREFIX)) {
            String string15 = string.substring(DM_TEMPLATE_REFLOOKUP_OPTIONAL_PREFIX.length());
            parsedField = new ParsedField(ParsedField.FieldType.TEMPLATE_LOOKUP_REF_OPTIONAL, string, string15);
            FieldParser.parseNameOrExpr(string15, parsedField, false, false);
            FieldParser.validateLookupField(parsedField, string15, bl);
        } else if (string.equals(DM_PAGE_BREAK)) {
            parsedField = new ParsedField(ParsedField.FieldType.BREAK_PAGE, string);
        } else if (string.equals(DM_PAGE_BREAK_NOT_LAST)) {
            parsedField = new ParsedField(ParsedField.FieldType.BREAK_PAGE_NOT_LAST, string);
        } else if (string.equals(DM_COLUMN_BREAK)) {
            parsedField = new ParsedField(ParsedField.FieldType.BREAK_COLUMN, string);
        } else if (string.equals(DM_COLUMN_BREAK_NOT_LAST)) {
            parsedField = new ParsedField(ParsedField.FieldType.BREAK_COLUMN_NOT_LAST, string);
        } else if (string.equals(NO_TABLE_ROW_ALTERNATE)) {
            parsedField = new ParsedField(ParsedField.FieldType.NO_TABLE_ROW_ALTERNATE, string);
        } else if (string.startsWith(DM_TEMPLATE_HTML_INJECT_LOOKUP_PREFIX)) {
            String string16 = string.substring(DM_TEMPLATE_HTML_INJECT_LOOKUP_PREFIX.length());
            parsedField = new ParsedField(ParsedField.FieldType.HTML_INJECT_LOOKUP_REF, string, string16);
            FieldParser.parseNameOrExpr(string16, parsedField, false, false);
            FieldParser.validateLookupField(parsedField, string16, bl);
        } else if (string.startsWith(DM_BARCODE_FIELD)) {
            String string17 = string.substring(DM_BARCODE_FIELD.length());
            String string18 = string17;
            if (string18.indexOf(A) != -1) {
                string18 = string18.substring(0, string18.indexOf(58));
            }
            if ((string17 = string17.substring(string18.length())).startsWith(A)) {
                string17 = string17.substring(A.length());
            }
            parsedField = new ParsedField(ParsedField.FieldType.BARCODE_FIELD, string, string17);
            FieldParser.parseNameOrExpr(string18, parsedField, false, false);
            FieldParser.parseBarcodeField(parsedField);
        } else if (string.startsWith(DM_QRCODE_FIELD)) {
            String string19 = string.substring(DM_QRCODE_FIELD.length());
            String string20 = string19;
            if (string20.indexOf(A) != -1) {
                string20 = string20.substring(0, string20.indexOf(58));
            }
            if ((string19 = string19.substring(string20.length())).startsWith(A)) {
                string19 = string19.substring(A.length());
            }
            parsedField = new ParsedField(ParsedField.FieldType.BARCODE_FIELD, string, string19);
            FieldParser.parseNameOrExpr(string20, parsedField, false, false);
            FieldParser.parseQRcodeField(parsedField, string20);
        } else if (string.startsWith(DM_DUMP_FIELD)) {
            String string21 = string.substring(DM_DUMP_FIELD.length());
            parsedField = FieldParser.parseLookupField(string21, ParsedField.FieldType.DUMP_FIELD, ParsedField.StripParagraphMode.STRIP_NEVER);
            FieldParser.validateLookupField(parsedField, string21, bl);
        } else if (string.startsWith(DM_DUMP_VERSIONS_FIELD)) {
            String string22 = string.substring(DM_DUMP_VERSIONS_FIELD.length());
            parsedField = new ParsedField(ParsedField.FieldType.DUMP_VERSIONS_FIELD, string, string22);
        } else if (string.startsWith(ODFHandlerObfImpl.\u0140)) {
            string = string.substring(ODFHandlerObfImpl.\u0140.length());
            parsedField = FieldParser.parseLookupField(string, ParsedField.FieldType.GET_DATA, ParsedField.StripParagraphMode.STRIP_IF_BLANK);
            FieldParser.validateLookupField(parsedField, string, bl);
        } else if (string.equals(S)) {
            parsedField = new ParsedField(ParsedField.FieldType.LIST_CONTINUE, string);
        } else if (string.equals(F)) {
            parsedField = new ParsedField(ParsedField.FieldType.LIST_RESET, string);
        } else if (string.startsWith(DM_FIELD_STYLE_SETTING_TEXT_COLOUR_PREFIX)) {
            String string23 = string.substring(DM_FIELD_STYLE_SETTING_TEXT_COLOUR_PREFIX.length());
            parsedField = new ParsedField(ParsedField.FieldType.FIELD_TEXT_COLOUR_OVERRIDE, string, string23);
            FieldParser.parseNameOrExpr(string23, parsedField, true, false);
        } else if (string.startsWith(DM_COORDINATOR_FIELD)) {
            String string24 = string.substring(DM_COORDINATOR_FIELD.length());
            parsedField = new ParsedField(ParsedField.FieldType.COORDINATOR_FIELD, string, string24);
            FieldParser.parseCoordinatorField(parsedField);
        } else if (string.startsWith(ODFHandlerObfImpl.\u0132)) {
            parsedField = FieldParser.parseLookupField(string, ParsedField.FieldType.GET_DATA, ParsedField.StripParagraphMode.STRIP_NEVER);
            FieldParser.validateLookupField(parsedField, string, bl);
        } else {
            parsedField = new ParsedField(ParsedField.FieldType.OF_NO_INTEREST, string);
        }
        FieldParser.validateCompleteField(parsedField, string, bl);
        return parsedField;
    }

    public static boolean isSetVariableField(String string) {
        int n = string.indexOf(61);
        int n2 = string.indexOf(123);
        boolean bl = n != -1 && (n2 == -1 || n2 > n);
        return string.startsWith("$") && bl;
    }

    public static boolean isBarcodeField(String string) {
        return string.startsWith(DM_BARCODE_FIELD);
    }

    public static boolean isQRCodeField(String string) {
        return string.startsWith(DM_QRCODE_FIELD);
    }

    private static ParsedField parseLookupField(String string, ParsedField.FieldType fieldType, ParsedField.StripParagraphMode stripParagraphMode) throws TemplateParseException {
        String string2 = string;
        if (FieldParserCommon.isFieldNameBracketingEnabled() && string.startsWith("[")) {
            string2 = FieldParserCommon.unbracket(string);
        }
        int n = string2.indexOf(123);
        String string3 = string2;
        ParsedField.FieldQualifiers fieldQualifiers = null;
        if (n != -1) {
            string3 = string2.substring(0, n);
            String string4 = string2.substring(n);
            fieldQualifiers = FieldParser.parseFieldQualifiers(string4, string2);
        }
        boolean bl = string3.startsWith("$") || string3.startsWith(Y);
        ParsedField parsedField = new ParsedField(fieldType, string);
        parsedField.setQualifiers(fieldQualifiers);
        parsedField.setTerms(FieldParser.parseName(string3, false, false));
        parsedField.setStripParagraphMode(stripParagraphMode);
        if (bl) {
            ParsedField.NameTerm[] nameTermArray = parsedField.getTerms();
            parsedField.setVariableName(nameTermArray[0].getLookupName());
        }
        return parsedField;
    }

    private static ParsedField parseNameOrExpr(String string, ParsedField parsedField, boolean bl, boolean bl2) throws TemplateParseException {
        if (!"".equals(string = string.trim())) {
            if (string.charAt(0) == '{') {
                if (string.charAt(string.length() - 1) != '}') {
                    throw new TemplateParseException("Field \"" + string + "\" is missing the '}' character to complete the expression.", new String[]{"Make sure your field has no spaces."});
                }
                String string2 = string.substring(1, string.length() - 1);
                parsedField.setExpression(FieldParser.parseExpression(string2, string));
            } else {
                parsedField.setTerms(FieldParser.parseName(string, bl, bl2));
            }
        }
        return parsedField;
    }

    private static ParsedField parseSetVariableField(String string) throws TemplateParseException {
        string = string.trim();
        int n = string.indexOf(61);
        ParsedField parsedField = new ParsedField(ParsedField.FieldType.SET_VARIABLE, string);
        String string2 = string.substring(1, n).trim();
        parsedField.setVariableName(string2);
        if (n == string.length() - 1) {
            throw new TemplateParseException("Field \"" + string + "\" must have a name or expression immediately following the = symbol.", new String[]{"Make sure your field has no spaces."});
        }
        String string3 = string.substring(n + 1).trim();
        FieldParser.parseNameOrExpr(string3, parsedField, true, false);
        return parsedField;
    }

    private static ParsedField parseExpressionField(String string) throws TemplateParseException {
        if ((string = string.trim()).charAt(string.length() - 1) != '}') {
            throw new TemplateParseException("Field \"" + string + "\" is missing the closing } character.");
        }
        String string2 = string.substring(1, string.length() - 1);
        ParsedField.Expression expression = FieldParser.parseExpression(string2, string);
        ParsedField parsedField = new ParsedField(ParsedField.FieldType.EXPRESSION_FIELD, string);
        parsedField.setExpression(expression);
        return parsedField;
    }

    private static ParsedField.NameTerm[] parseName(String string, boolean bl, boolean bl2) throws TemplateParseException {
        if (string == null || "".equals(string.trim())) {
            throw new TemplateParseException("Invalid empty field", new String[]{"Make sure your field has no spaces."});
        }
        string = string.trim();
        if (FieldParserCommon.isFieldNameBracketingEnabled() && string.startsWith("[")) {
            string = FieldParserCommon.unbracket(string);
        }
        if (string.charAt(0) == '.' || string.charAt(string.length() - 1) == '.') {
            throw new TemplateParseException("Field \"" + string + "\" cannot start or end with a . (period)", new String[]{"Make sure your field has no spaces."});
        }
        List<String> list = FieldParser.splitNameTerm(string, bl2);
        ArrayList<ParsedField.NameTerm> arrayList = new ArrayList<ParsedField.NameTerm>();
        ParsedField.NameTerm[] nameTermArray = list.iterator();
        while (nameTermArray.hasNext()) {
            String string2 = nameTermArray.next();
            boolean bl3 = bl2 && !nameTermArray.hasNext();
            arrayList.add(FieldParser.parseNameTerm(string2, string, bl, bl3));
        }
        nameTermArray = new ParsedField.NameTerm[arrayList.size()];
        arrayList.toArray(nameTermArray);
        return nameTermArray;
    }

    private static List<String> splitNameTerm(String string, boolean bl) {
        int n;
        StringUtilities.StringToken[] stringTokenArray;
        ArrayList<String> arrayList = new ArrayList<String>();
        if (string.length() >= 2 && FieldParser.isSingleQuote(string.charAt(0)) && FieldParser.isSingleQuote(string.charAt(string.length() - 1))) {
            arrayList.add(string);
            return arrayList;
        }
        if (bl && string.indexOf(58) != -1) {
            String[] stringArray = string.split(":", 2);
            stringTokenArray = StringUtilities.tokenizeQuoteAware(stringArray[0], ".");
            n = stringTokenArray.length - 1;
            stringTokenArray[n] = new StringUtilities.StringToken(stringTokenArray[n].text + ":" + stringArray[1], stringTokenArray[n].isToken);
        } else {
            stringTokenArray = StringUtilities.tokenizeQuoteAware(string, ".");
        }
        boolean bl2 = false;
        for (n = 0; n < stringTokenArray.length; ++n) {
            String string2 = stringTokenArray[n].text;
            if (bl2) {
                arrayList.set(arrayList.size() - 1, arrayList.get(arrayList.size() - 1) + "." + string2);
            } else {
                arrayList.add(string2);
            }
            bl2 = FieldParser.isLong(string2);
        }
        return arrayList;
    }

    private static boolean isLong(String string) {
        try {
            new Long(string);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    private static int getDirectiveEndPosition(String string, int n) {
        String[] stringArray;
        int n2 = -1;
        for (String string2 : stringArray = new String[]{C, W, X, P, Z, D, K, R}) {
            int n3 = string.indexOf(string2, n);
            if (n3 == -1 || n2 != -1 && n3 >= n2) continue;
            n2 = n3;
        }
        if (n2 == -1) {
            return string.length();
        }
        return n2;
    }

    private static ParsedField.NameTerm parseNameTerm(String string, String string2, boolean bl, boolean bl2) throws TemplateParseException {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8 = string.length();
        if (n8 < 1) {
            throw new TemplateParseException("Field contains an empty term (two '.' characters).", new String[]{"Make sure your field has no spaces."});
        }
        if (n8 == 1 && string.charAt(0) == '$') {
            throw new TemplateParseException("Field term cannot contain only \"$\"", new String[]{"Make sure your field has no spaces."});
        }
        int[] nArray = StringUtilities.getMultipleIndexOfs(string, C);
        if (nArray.length > 1) {
            throw new TemplateParseException("Field term \"" + string + "\" multiple step directives found.", new String[]{"Remove additional step directive(s)"});
        }
        int n9 = nArray.length == 1 ? nArray[0] : -1;
        int n10 = FieldParser.getDirectiveEndPosition(string, n9 + 1);
        String string3 = n9 == -1 ? null : string.substring(n9, n10).trim();
        int[] nArray2 = StringUtilities.getMultipleIndexOfs(string, W);
        if (nArray2.length > 1) {
            throw new TemplateParseException("Field term \"" + string + "\" multiple array directives found.", new String[]{"Remove additional array directive(s)"});
        }
        int n11 = nArray2.length == 1 ? nArray2[0] : -1;
        int n12 = FieldParser.getDirectiveEndPosition(string, n11 + 1);
        String string4 = n11 == -1 ? null : string.substring(n11, n12).trim();
        int[] nArray3 = StringUtilities.getMultipleIndexOfs(string, M);
        int[] nArray4 = new int[nArray3.length];
        String[] stringArray = nArray3.length > 0 ? new String[nArray3.length] : new String[]{};
        for (int i = 0; i < nArray3.length; ++i) {
            n7 = nArray3[i];
            nArray4[i] = n6 = FieldParser.getDirectiveEndPosition(string, n7 + 1);
            stringArray[i] = n7 == -1 ? null : string.substring(n7, n6).trim();
        }
        int[] nArray5 = StringUtilities.getMultipleIndexOfs(string, K);
        if (nArray5.length > 1) {
            throw new TemplateParseException("Field term \"" + string + "\" multiple filter directives found.", new String[]{"Remove additional filter directive(s)"});
        }
        n7 = nArray5.length == 1 ? nArray5[0] : -1;
        n6 = FieldParser.getDirectiveEndPosition(string, n7 + 1);
        String string5 = n7 == -1 ? null : string.substring(n7, n6).trim();
        int[] nArray6 = StringUtilities.getMultipleIndexOfs(string, R);
        if (nArray6.length > 1) {
            throw new TemplateParseException("Field term \"" + string + "\" multiple group by directives found.", new String[]{"Remove additional group by directive(s)"});
        }
        int n13 = nArray6.length == 1 ? nArray6[0] : -1;
        int n14 = FieldParser.getDirectiveEndPosition(string, n13 + 1);
        String string6 = n13 == -1 ? null : string.substring(n13, n14).trim();
        for (n5 = 0; n5 < nArray6.length; ++n5) {
            n4 = 0;
            for (n3 = 0; n3 < nArray3.length; ++n3) {
                if (nArray3[n3] <= nArray6[n5]) continue;
                n4 = 1;
                break;
            }
            if (n4 == 0) {
                for (n3 = 0; n3 < nArray5.length; ++n3) {
                    if (nArray5[n3] <= nArray6[n5]) continue;
                    n4 = 1;
                    break;
                }
            }
            if (n4 == 0) continue;
            throw new TemplateParseException("Field term \"" + string + "\" sort and filter directives must be before the group directive.", new String[]{"Sort and Filter before the group directive"});
        }
        if (n9 != -1) {
            n5 = 0;
            for (n4 = 0; n4 < nArray3.length; ++n4) {
                if (nArray3[n4] <= n9) continue;
                n5 = 1;
                break;
            }
            if (n5 == 0) {
                for (n4 = 0; n4 < nArray5.length; ++n4) {
                    if (nArray5[n4] <= n9) continue;
                    n5 = 1;
                    break;
                }
            }
            if (n5 == 0) {
                for (n4 = 0; n4 < nArray6.length; ++n4) {
                    if (nArray6[n4] <= n9) continue;
                    n5 = 1;
                    break;
                }
            }
            if (n5 == 0 && n11 > n9) {
                n5 = 1;
            }
            if (n5 != 0) {
                throw new TemplateParseException("Field term \"" + string + "\" step directives must be the last directive.", new String[]{"Move the step directive to the end of the field"});
            }
        }
        int[] nArray7 = new int[]{n9, n11, n7, n13};
        int[] nArray8 = new int[]{n10, n12, n6, n14};
        n3 = Integer.MAX_VALUE;
        int n15 = -1;
        for (n2 = 0; n2 < nArray7.length; ++n2) {
            if (nArray7[n2] > -1 && nArray7[n2] < n3) {
                n3 = nArray7[n2];
            }
            if (nArray8[n2] <= n15) continue;
            n15 = nArray8[n2];
        }
        for (n2 = 0; n2 < nArray3.length; ++n2) {
            if (nArray3[n2] > -1 && nArray3[n2] < n3) {
                n3 = nArray3[n2];
            }
            if (nArray4[n2] <= n15) continue;
            n15 = nArray4[n2];
        }
        if (n3 == Integer.MAX_VALUE) {
            n3 = -1;
        }
        n2 = n3;
        int n16 = n15;
        boolean bl3 = string.charAt(0) == '$' || string.startsWith(Y);
        boolean bl4 = FieldParser.isSingleQuote(string.charAt(0));
        Number number = FieldParser.getNumericValue(string);
        boolean bl5 = number != null;
        boolean bl6 = Character.isLetter(string.charAt(0));
        boolean bl7 = StringUtilities.validateHexColourFormat(string);
        if (bl) {
            if (!(bl3 || bl6 || bl5 || bl4 || bl7)) {
                throw new TemplateParseException("Field term \"" + string + "\" must start with a letter or digit, $ or ' (quote)", new String[]{"Make sure your field has no spaces."});
            }
        } else if (!bl3 && !bl6 && n11 == -1) {
            throw new TemplateParseException("Field term \"" + string + "\" must start with an Alphabetic letter or $", new String[]{"Make sure your field has no spaces."});
        }
        if (n11 > -1 && (stringArray.length > 0 || n7 > -1 || n13 > -1)) {
            throw new TemplateParseException("Field term \"" + string + "\"array directive can only be used in conjunction with the step directive\"", new String[]{"Remove other directives."});
        }
        int n17 = 1;
        if (string.startsWith("$?")) {
            n17 = 2;
        }
        while (n17 < n8) {
            char c = string.charAt(n17);
            if (bl4) {
                if (c == '\'' || c == '\u2019') {
                    break;
                }
            } else if (bl5) {
                if (!Character.isDigit(c) && c != '.' && !FieldParserCommon.isHyphen(c) && c != 'e' && c != 'E') {
                    break;
                }
            } else if (FieldParserCommon.isHyphen(c) && n17 != n8 - 1) {
                if (!FieldParserCommon.isFieldNameBracketingHyphenAllowed()) {
                    throw new TemplateParseException("Field term \"" + string + "\" cannot contain a hyphen.", new String[]{"Remove the hyphen from the name.", "Enable hyphens in field names"});
                }
            } else if (!Character.isLetterOrDigit(c) && c != '_') break;
            ++n17;
        }
        if (FieldParserCommon.isFieldNameBracketingHyphenAllowed()) {
            string = string.replace('\u2013', '-').replace('\u2014', '-');
        }
        ParsedField.MutableNameTerm mutableNameTerm = new ParsedField.MutableNameTerm(string);
        String string7 = null;
        boolean bl8 = false;
        if (bl4) {
            string7 = string.substring(1, n17);
        } else if (bl3) {
            if (string.startsWith("$?")) {
                string7 = string.substring(2, n17);
                bl8 = true;
            } else if (string.startsWith("$")) {
                string7 = string.substring(1, n17);
            } else if (string.startsWith(I)) {
                string7 = string.substring(I.length(), n17);
                bl8 = true;
            } else {
                string7 = string.substring(Y.length(), n17);
            }
        } else {
            string7 = string.substring(0, n17);
        }
        mutableNameTerm.setTerm(string7);
        mutableNameTerm.setVariable(bl3);
        mutableNameTerm.setVariableForgiving(bl8);
        if (bl3 && string7.contentEquals(VARIABLE_GROUP_ITEMS)) {
            mutableNameTerm.setGroupItems(true);
        }
        if (bl4) {
            mutableNameTerm.setLiteral(true, string7);
        } else if ("null".equals(string)) {
            mutableNameTerm.setLiteral(true, null);
        } else if (string.equals(Boolean.TRUE.toString()) || string.equals(Boolean.FALSE.toString())) {
            mutableNameTerm.setLiteral(true, new Boolean(string));
        } else if (bl5) {
            mutableNameTerm.setLiteral(true, number);
        } else if (bl7) {
            mutableNameTerm.setLiteral(true, string7);
        }
        if (bl4 && n17 == n8) {
            throw new TemplateParseException("Field term \"" + string + "\" is missing a quote(').", new String[]{"Make sure your field has no spaces."});
        }
        if (bl5 && n17 < n8) {
            throw new TemplateParseException("Field term \"" + string + "\" starts as numeric but has trailing non-numeric characters.", new String[]{"Make sure your field has no spaces."});
        }
        if (bl4) {
            ++n17;
        }
        while (n17 < n8 && (n2 == -1 || n17 < n2)) {
            char c = string.charAt(n17);
            if (n17 == n8 - 1) {
                throw new TemplateParseException("Field term \"" + string + "\" terminates with an invalid character: '" + c + "'", new String[]{"Make sure your field has no spaces."});
            }
            if (c == '(') {
                String[] stringArray2;
                n = string.indexOf(41, n17);
                if (n == -1) {
                    stringArray2 = string.trim().substring(0, n17);
                    throw new TemplateParseException("Field term \"" + string + "\" is missing closing bracket: ')'.", new String[]{"Make sure your field has no spaces.", "Check \"" + (String)stringArray2 + "\" is correct"});
                }
                mutableNameTerm.setMethodName(true);
                if (n17 + 1 < n) {
                    stringArray2 = FieldParser.tokenizeParams(string.substring(n17 + 1, n), string2);
                    mutableNameTerm.setMethodParams(stringArray2);
                }
                n17 = n + 1;
                continue;
            }
            if (c == '[') {
                if (n2 == -1) {
                    mutableNameTerm.setRange(FieldParser.parseRangeSpec(string.substring(n17), string2));
                    break;
                }
                mutableNameTerm.setRange(FieldParser.parseRangeSpec(string.substring(n17, n2), string2));
                break;
            }
            throw new TemplateParseException("Field term \"" + string + "\" has an invalid character following the name: '" + c + "'", new String[]{"Make sure your field has no spaces."});
        }
        if (n2 != -1 && !bl2) {
            if (n17 != n2) {
                throw new TemplateParseException("Field term \"" + string + "\" is not allowed to have a suffix directive.", new String[]{"Remove the suffix (eg :stepN) part of the field"});
            }
        } else if (bl2) {
            if (n16 < string.length()) {
                throw new TemplateParseException("Field term \"" + string + "\" has invalid characters following the suffix(es): '" + string.substring(n16, string.length()) + "'", new String[]{"Make sure your suffixes are spelled correctly", "Make sure your field has no spaces."});
            }
            if (n2 != -1) {
                if (n9 != -1) {
                    if (C.equals(string3)) {
                        throw new TemplateParseException("Field term \"" + string + "\" step directive is missing the value.", new String[]{"Add the step size number eg :step2 or :step4"});
                    }
                    if (":stepdown".equals(string3)) {
                        throw new TemplateParseException("Field term \"" + string + "\" step directive is missing the value.", new String[]{"Add the step size number eg :step2down or :step4down"});
                    }
                    String string8 = string3.substring(C.length());
                    n = 0;
                    if (string8.endsWith(B)) {
                        n = 1;
                        string8 = string8.substring(0, string8.length() - B.length());
                    }
                    try {
                        int n18 = Integer.parseInt(string8);
                        if (n18 < N || n18 > V) {
                            String string9 = N + "-" + V;
                            throw new TemplateParseException("Field term \"" + string + "\" step directive number is invalid:\"", new String[]{"Set the step size to a valid number in the range " + string9 + ". eg " + C + "2 or " + C + "4"});
                        }
                        mutableNameTerm.setStepSize(n18);
                        mutableNameTerm.setStepDown(n != 0);
                    }
                    catch (NumberFormatException numberFormatException) {
                        String string10 = N + "-" + V;
                        throw new TemplateParseException("Field term \"" + string + "\" step directive number is invalid:\"", new String[]{"Set the step size to a valid number in the range " + string10 + ". eg " + C + "2 or " + C + "4"});
                    }
                }
                if (n11 != -1) {
                    String string11 = string4.substring(W.length());
                    if (string11.length() == 0) {
                        throw new TemplateParseException("Field term \"" + string + "\" array directive invalid, no array size supplied:\"", new String[]{"Set the size of the array. eg :array10 or :array$myNumber"});
                    }
                    try {
                        double d = Double.parseDouble(string11);
                        if (d < 0.0 || d > (double)E) {
                            throw new TemplateParseException("Field term \"" + string + "\" array directive invalid, array size supplied must be between 0 and " + E + ":\"", new String[]{"Set the size of the array. eg :array10 or :array$myNumber"});
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        FieldParser.parseExpression(string11, string11);
                    }
                    mutableNameTerm.setArtificialRS(true);
                    mutableNameTerm.setArtificialRSlength(string11);
                }
                if (stringArray.length > 0) {
                    ArrayList<Object> arrayList = new ArrayList<Object>();
                    for (int i = 0; i < stringArray.length; ++i) {
                        Object object;
                        StringUtilities.StringToken[] stringTokenArray;
                        boolean bl9;
                        String string12 = stringArray[i];
                        if (StringUtilities.isEmpty(string12)) continue;
                        String string13 = null;
                        Object object2 = "???";
                        for (String string14 : M) {
                            if (!string12.matches("^" + string14 + "\\s*\\(.*")) continue;
                            string13 = string14;
                            object2 = string12.substring(string14.length()).trim();
                            break;
                        }
                        if (!object2.startsWith("(") || !object2.endsWith(")")) {
                            throw new TemplateParseException("Field term \"" + string + "\" sort directive invalid, no parameters supplied:\"", new String[]{"Set the name of the field/expression to sort by. eg " + (String)object2 + "MyField"});
                        }
                        object2 = object2.substring(1, object2.length() - 1);
                        Object object3 = null;
                        Boolean bl10 = null;
                        Boolean bl11 = null;
                        do {
                            object2 = object2.trim();
                            bl9 = false;
                            if (object2.startsWith(J) || object2.startsWith(J.toLowerCase())) {
                                object3 = false;
                                bl9 = true;
                                if ((object2 = object2.substring(J.length()).trim()).startsWith(",")) {
                                    object2 = object2.substring(1);
                                }
                            }
                            if (object2.startsWith(L) || object2.startsWith(L.toLowerCase())) {
                                object2 = object2.substring(L.length()).trim();
                                object3 = true;
                                bl9 = true;
                                if (object2.startsWith(",")) {
                                    object2 = object2.substring(1);
                                }
                            }
                            if (object2.startsWith(G) || object2.startsWith(G.toLowerCase())) {
                                object2 = object2.substring(G.length()).trim();
                                bl10 = true;
                                bl9 = true;
                                if (object2.startsWith(",")) {
                                    object2 = object2.substring(1);
                                }
                            }
                            if (object2.startsWith(H) || object2.startsWith(H.toLowerCase())) {
                                object2 = object2.substring(H.length()).trim();
                                bl10 = false;
                                bl9 = true;
                                if (object2.startsWith(",")) {
                                    object2 = object2.substring(1);
                                }
                            }
                            if (object2.startsWith(_) || object2.startsWith(_.toLowerCase())) {
                                object2 = object2.substring(_.length()).trim();
                                bl11 = true;
                                bl9 = true;
                                if (object2.startsWith(",")) {
                                    object2 = object2.substring(1);
                                }
                            }
                            if (!object2.startsWith(O) && !object2.startsWith(O.toLowerCase())) continue;
                            object2 = object2.substring(O.length()).trim();
                            bl11 = false;
                            bl9 = true;
                            if (!object2.startsWith(",")) continue;
                            object2 = object2.substring(1);
                        } while (bl9);
                        String string15 = null;
                        String string16 = null;
                        String string17 = null;
                        if (string13.equals(D)) {
                            stringTokenArray = StringUtilities.tokenizeQuoteAware((String)object2, ",");
                            if (object2.length() == 0 || stringTokenArray == null || stringTokenArray.length == 0) {
                                throw new TemplateParseException("Field term \"" + string + "\" sort directive invalid, no DATE parameters supplied:\"");
                            }
                            if (stringTokenArray.length > 4) {
                                throw new TemplateParseException("Field term \"" + string + "\" sort directive invalid, only 1 to 4 parameters required:\"", new String[]{"Remove the additional parameters. eg: (...,dd/MM/yyyy, en_us, false)"});
                            }
                            object = stringTokenArray[0].text;
                            if (StringUtilities.isEmpty((String)object)) {
                                throw new TemplateParseException("Field term \"" + string + "\" sort directive empty first parameter");
                            }
                            string15 = stringTokenArray.length > 1 ? stringTokenArray[1].text : null;
                            string16 = stringTokenArray.length > 2 ? stringTokenArray[2].text : null;
                            string17 = stringTokenArray.length > 3 ? stringTokenArray[3].text : null;
                            object2 = object;
                        }
                        stringTokenArray = object2;
                        FieldParser.parseExpression((String)stringTokenArray, (String)stringTokenArray);
                        if (X.equals(string13)) {
                            if (object3 == null) {
                                object3 = true;
                            }
                            if (bl10 == null) {
                                Boolean bl12 = bl10 = ((Boolean)object3).booleanValue() ? Boolean.TRUE : Boolean.FALSE;
                            }
                            if (bl11 == null) {
                                bl11 = false;
                            }
                            object = new SortDescriptionAlphaNum((Boolean)object3, bl10, bl11, (String)stringTokenArray);
                        } else if (P.equals(string13)) {
                            if (object3 == null) {
                                object3 = true;
                            }
                            if (bl10 == null) {
                                Boolean bl13 = bl10 = ((Boolean)object3).booleanValue() ? Boolean.TRUE : Boolean.FALSE;
                            }
                            if (bl11 == null) {
                                bl11 = false;
                            }
                            object = new SortDescriptionString((Boolean)object3, bl10, bl11, (String)stringTokenArray);
                        } else if (Z.equals(string13)) {
                            if (object3 == null) {
                                object3 = true;
                            }
                            if (bl10 == null) {
                                bl10 = ((Boolean)object3).booleanValue() ? Boolean.TRUE : Boolean.FALSE;
                            }
                            object = new SortDescriptionNumber((Boolean)object3, bl10, (String)stringTokenArray);
                        } else if (D.equals(string13)) {
                            if (object3 == null) {
                                object3 = true;
                            }
                            if (bl10 == null) {
                                bl10 = ((Boolean)object3).booleanValue() ? Boolean.TRUE : Boolean.FALSE;
                            }
                            object = new SortDescriptionDate((Boolean)object3, bl10, (String)stringTokenArray, string15, string16, string17);
                        } else {
                            object = null;
                        }
                        if (object == null) {
                            throw new TemplateParseException("Field term \"" + string + "\" sort directive invalid, unknown type \"" + string13 + "\"");
                        }
                        arrayList.add(object);
                    }
                    if (arrayList.size() > 0) {
                        mutableNameTerm.setSorted(true);
                        mutableNameTerm.setSorts(arrayList.toArray(new SortDescription[arrayList.size()]));
                    }
                }
                if (n7 != -1) {
                    String string18 = string5.substring(K.length());
                    if (string18.length() == 0) {
                        throw new TemplateParseException("Field term \"" + string + "\" filter directive invalid, no filter expression supplied:\"", new String[]{"Set the expression to filter by. eg :filtermyID=1 or :filterstartsWith(myField,'PO*')"});
                    }
                    if (!string18.startsWith("(") || !string18.endsWith(")")) {
                        throw new TemplateParseException("Field term \"" + string + "\" filter directive invalid, no parameters supplied:\"", new String[]{"Set the name of the field/expression to sort by. eg " + string18 + "MyField"});
                    }
                    string18 = string18.substring(1, string18.length() - 1);
                    FieldParser.parseExpression(string18, string18);
                    mutableNameTerm.setFiltered(true);
                    mutableNameTerm.setFilterExpression(string18);
                }
                if (n13 != -1) {
                    String string19 = string6.substring(R.length());
                    if (string19.length() == 0) {
                        throw new TemplateParseException("Field term \"" + string + "\" group by directive invalid, no group by expression supplied:\"", new String[]{"Set the expression to group by. eg :groupmyID or :groupdateFormat(date,'MM')"});
                    }
                    if (!string19.startsWith("(") || !string19.endsWith(")")) {
                        throw new TemplateParseException("Field term \"" + string + "\" group directive invalid, no parameters supplied:\"", new String[]{"Set the name of the field/expression to group on. eg " + string19 + "MyField"});
                    }
                    string19 = string19.substring(1, string19.length() - 1);
                    FieldParser.parseExpression(string19, string19);
                    mutableNameTerm.setGrouped(true);
                    mutableNameTerm.setGroupByExpression(string19);
                }
            }
        }
        return new ParsedField.NameTerm(mutableNameTerm);
    }

    private static Number getNumericValue(String string) {
        if (string != null && !string.trim().equals("")) {
            try {
                return new Long(string);
            }
            catch (NumberFormatException numberFormatException) {
                try {
                    return new Double(string);
                }
                catch (NumberFormatException numberFormatException2) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    private static ParsedField.FieldQualifiers parseFieldQualifiers(String string, String string2) throws TemplateParseException {
        string = string.trim();
        ParsedField.FieldQualifiers fieldQualifiers = new ParsedField.FieldQualifiers();
        if (!string.startsWith("{") || !string.endsWith("}")) {
            throw new TemplateParseException("Field \"" + string2 + "\" has a qualifier " + "that is not well formed.", new String[]{"Make sure your field has no spaces.", "Make sure the qualifier format is \"{key=value[,key=value[,...]]}\""});
        }
        String[] stringArray = FieldParser.tokenizeQualifiers(string = string.substring(1, string.length() - 1), string2);
        if (stringArray == null) {
            throw new TemplateParseException("Field \"" + string2 + "\" has a qualifier " + "that is not well formed.", new String[]{"Make sure your field has no spaces. ", "Make sure the qualifier format is \"{key=value[,key=value[,...]]}\""});
        }
        boolean bl = false;
        for (int i = 0; i < stringArray.length; ++i) {
            String string3 = stringArray[i];
            if (string3 == null || string3.indexOf(61) == -1) {
                throw new TemplateParseException("Field \"" + string2 + "\" has a qualifier " + "that is not well formed.", new String[]{"Make sure your field has no spaces. ", "Make sure the qualifier format is \"{key=value[,key=value[,...]]}\""});
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string3, "=");
            if (stringTokenizer.countTokens() == 0) {
                throw new TemplateParseException("Field \"" + string2 + "\" has a qualifier " + "that is not well formed.", new String[]{"Make sure your field has no spaces. ", "Make sure the qualifier format is \"{key=value[,key=value[,...]]}\""});
            }
            while (stringTokenizer.hasMoreTokens()) {
                if (stringTokenizer.countTokens() < 2) {
                    throw new TemplateParseException("Field \"" + string2 + "\" has a qualifier " + "that is not well formed.", new String[]{"Make sure your field has no spaces. ", "Make sure the qualifier format is \"{key=value[,key=value[,...]]}\""});
                }
                String string4 = stringTokenizer.nextToken();
                String string5 = stringTokenizer.nextToken();
                if (string4 == null || string5 == null) {
                    throw new TemplateParseException("Field \"" + string2 + "\" has a qualifier " + "that is not well formed.", new String[]{"Make sure your field has no spaces. ", "Make sure the qualifier format is \"{key=value[,key=value[,...]]}\""});
                }
                string4 = string4.trim();
                string5 = string5.trim();
                if ("".equals(string4) || "".equals(string5)) {
                    throw new TemplateParseException("Field \"" + string2 + "\" has a qualifier " + "that is not well formed.", new String[]{"Make sure your field has no spaces. ", "Make sure the qualifier format is \"{key=value[,key=value[,...]]}\""});
                }
                if (T.equals(string4)) {
                    bl = true;
                    fieldQualifiers.setSection(string5);
                    continue;
                }
                if (Q.equals(string4)) {
                    bl = true;
                    _A _A2 = _A.A(string5, string2, true);
                    fieldQualifiers.setRenderer(_A2.A, _A2.B);
                    continue;
                }
                if (U.equals(string4)) {
                    bl = true;
                    fieldQualifiers.setId(string5);
                    continue;
                }
                throw new TemplateParseException("Field \"" + string2 + "\" has an unknown " + "qualifier \"" + string4 + "\".", new String[]{"Make sure your field has no spaces. ", "Make sure the qualifier format is \"{key=value[,key=value[,...]]}\""});
            }
        }
        if (!bl) {
            fieldQualifiers = null;
        }
        return fieldQualifiers;
    }

    static ParsedField.RangeSpecifier parseRangeSpec(String string, String string2) throws TemplateParseException {
        ParsedField.Range[] rangeArray;
        if (!(string = string.trim()).startsWith("[") || !string.endsWith("]")) {
            throw new TemplateParseException("Field \"" + string2 + "\" has a range " + "specifier that is not well formed.", new String[]{"Make sure your field has no spaces. ", "Make sure the range format is of the form \"[0,1,2,...]\", \"[0-3,4-5,...]\", \"[F2] \""});
        }
        string = string.substring(1, string.length() - 1);
        ArrayList<ParsedField.Range> arrayList = new ArrayList<ParsedField.Range>();
        if (string.trim().startsWith("$")) {
            FieldParser.validateRangeExpression(string, string2);
            arrayList.add(new ParsedField.Range(string));
        } else {
            if (string.trim().length() == 0) {
                throw new TemplateParseException("Field \"" + string2 + "\" has a blank range " + "specifier.", new String[]{"Make sure the range format is of the form \"[0,1,2,...]\", \"[0-3,4-5,...]\", \"[F2] \""});
            }
            rangeArray = new StringTokenizer(string, ",");
            while (rangeArray.hasMoreTokens()) {
                int n;
                String string3 = rangeArray.nextToken().trim();
                if (string3.indexOf(45) != -1) {
                    String[] stringArray = string3.split("-");
                    if (stringArray.length != 2) {
                        throw new TemplateParseException("Field \"" + string2 + "\" has a range " + "specifier that is not well formed.", new String[]{"Make sure your field has no spaces. ", "Make sure the range format is of the form \"[0,1,2,...]\", \"[0-3,4-5,...]\", \"[F2] \""});
                    }
                    String string4 = stringArray[0].trim();
                    String string5 = stringArray[1].trim();
                    try {
                        _B _B2 = FieldParser.parseRangeElement(string4, _C.B);
                        _B _B3 = FieldParser.parseRangeElement(string5, _C.E);
                        arrayList.add(new ParsedField.Range(_B2.A, _B3.A, _B2.B || _B3.B));
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new TemplateParseException("Field \"" + string2 + "\" has a range " + "specifier that is not well formed: \"" + string3 + "\" which must be two positive integers.", new String[]{"Make sure your field has no spaces. ", "Make sure the range format is of the form \"[0,1,2,...]\", \"[0-3,4-5,...]\", \"[F2] \""});
                    }
                }
                if ("*".equals(string3)) {
                    arrayList.add(new ParsedField.Range(0, -1, true));
                    continue;
                }
                if (string3.startsWith("L")) {
                    try {
                        _B _B4 = FieldParser.parseRangeElement(string3, _C.D);
                        if (_B4.A == 0) {
                            throw new TemplateParseException("Field \"" + string2 + "\" has a range " + "specifier that is not well formed: \"" + string3 + "\" since \"L0\" (zero) is not valid.", new String[]{"Make sure your field has no spaces. ", "Make sure the range format is of the form \"[0,1,2,...]\", \"[0-3,4-5,...]\", \"[F2] \""});
                        }
                        arrayList.add(new ParsedField.Range(_B4.A, -1, true));
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new TemplateParseException("Field \"" + string2 + "\" has a range " + "specifier that is not well formed: \"" + string3 + "\" since \"L0\" (zero) is not valid.");
                    }
                }
                if (string3.startsWith("F")) {
                    try {
                        _B _B5 = FieldParser.parseRangeElement(string3, _C.D);
                        if ("F0".equals(string3)) {
                            throw new TemplateParseException("Field \"" + string2 + "\" has a range " + "specifier that is not well formed: \"" + string3 + "\" since \"F0\" (zero) is not valid.", new String[]{"Make sure your field has no spaces. ", "Make sure the range format is of the form \"[0,1,2,...]\", \"[0-3,4-5,...]\", \"[F2] \""});
                        }
                        arrayList.add(new ParsedField.Range(0, _B5.A, true));
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new TemplateParseException("Field \"" + string2 + "\" has a range " + "specifier that is not well formed: \"" + string3 + "\" since \"L0\" (zero) is not valid.");
                    }
                }
                try {
                    n = Integer.parseInt(string3.trim());
                }
                catch (NumberFormatException numberFormatException) {
                    throw new TemplateParseException("Field \"" + string2 + "\" has a range " + "specifier that is not well formed: \"" + string3 + "\" which must start with \"F\", \"L\" or be a postive integer.  ", new String[]{"Make sure your field has no spaces. ", "Make sure the range format is of the form \"[0,1,2,...]\", \"[0-3,4-5,...]\", \"[F2] \""});
                }
                arrayList.add(new ParsedField.Range(n, n, false));
            }
        }
        rangeArray = null;
        if (!arrayList.isEmpty()) {
            rangeArray = new ParsedField.Range[arrayList.size()];
            arrayList.toArray(rangeArray);
        }
        return new ParsedField.RangeSpecifier(string, rangeArray);
    }

    private static ParsedField.Expression parseExpression(String string, String string2) throws TemplateParseException {
        ParsedField.Expression expression = null;
        if ((string = XMLUtilities.decode(string)) == null || "".equals(string.trim())) {
            throw new TemplateParseException("Field \"" + string2 + "\" has an empty expression");
        }
        expression = new ParsedField.Expression(string);
        try {
            Evaluator evaluator = DocmosisExpression.constructParsingEvaluator();
            evaluator.parse(string);
            Evaluator.DocmosisOperand[] docmosisOperandArray = evaluator.getOperands();
            for (int i = 0; i < docmosisOperandArray.length; ++i) {
                try {
                    ParsedField.NameTerm[] nameTermArray = FieldParser.parseName(docmosisOperandArray[i].getValue(), true, false);
                    expression.addTerms(nameTermArray);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        catch (EvaluationException evaluationException) {
            throw new TemplateParseException("Expression error for [" + string + "]:" + evaluationException.getMessage());
        }
        return expression;
    }

    private static _B parseRangeElement(String string, _C _C2) throws NumberFormatException {
        if ((string = string.trim()).startsWith("F")) {
            if (string.length() == 1) {
                return new _B(0, true);
            }
            int n = Integer.parseInt(string.substring(1));
            if (_C.B.equals(_C2)) {
                return new _B(n, true);
            }
            return new _B(n - 1, true);
        }
        if (string.startsWith("L")) {
            if (string.length() == 1) {
                if (_C.E.equals(_C2)) {
                    return new _B(-1, true);
                }
                return new _B(-1, true);
            }
            int n = Integer.parseInt(string.substring(1));
            if (_C.E.equals(_C2)) {
                return new _B(-n - 1, true);
            }
            return new _B(-n, true);
        }
        return new _B(Integer.parseInt(string), false);
    }

    private static void validateCompleteField(ParsedField parsedField, String string, boolean bl) throws TemplateParseException {
        if (parsedField.isOfNoInterest()) {
            return;
        }
        ParsedField.NameTerm[] nameTermArray = parsedField.getTerms();
        if (parsedField.isTemplateRef()) {
            FieldParser.validatePathForm(parsedField.getOriginalFieldTextSansPrefix(), string);
        } else {
            if ((parsedField.isRepeatingSectionStart() || parsedField.isRepeatingTableRowStart()) && parsedField.getTerms() != null && parsedField.getTerms().length > 0 && parsedField.getTerms()[0].isVariable() && parsedField.getTerms()[0].getLookupName().equals(VARIABLE_GROUP_ITEMS) && (parsedField.getTerms()[0].isFiltered() || parsedField.getTerms()[0].isSorted() || parsedField.getTerms()[0].isGrouped())) {
                throw new TemplateParseException("Field \"" + string + "\" $" + VARIABLE_GROUP_ITEMS + " cannot have a sort, filter or group applied to it", new String[]{"Apply the sort with the outer repeating group() directive."});
            }
            if (nameTermArray != null) {
                int n = FieldParser.getMultiValuedRangeCount(nameTermArray);
                if (n > 1) {
                    throw new TemplateParseException("Field \"" + string + "\" has more than one range inside \"[ ]\" covering multiple values. Only one " + "range can be more than a single value.");
                }
                if (n > 0 && !parsedField.allowsMultiRanges() && !bl) {
                    throw new TemplateParseException("Field \"" + string + "\" has a range inside \"[ ]\" covering multiple values. This type of " + "field can only have single-value range fields such as \"[0]\" and \"[F]\".");
                }
            } else if (!(parsedField.getExpression() != null || parsedField.isSectionEnd() || parsedField.isRepeatingOrConditionalTableRowEnd() || parsedField.isBreakField() || parsedField.isNoTableAlternating() || parsedField.isConditionalSectionElseStart() || parsedField.isListContinue() || parsedField.isListReset() || parsedField.isCoordinator() || parsedField.isDumpVersionsField())) {
                throw new TemplateParseException("Field \"" + string + "\" is not complete.", new String[]{"Make sure your field does not contain spaces"});
            }
        }
    }

    private static void validatePathForm(String string, String string2) throws TemplateParseException {
        if (string == null || "".equals(string.trim())) {
            throw new TemplateParseException("Field \"" + string2 + "\" is not complete.", new String[]{"Make sure your field does not contain spaces"});
        }
        if (string.startsWith(" ") || string.endsWith(" ") || string.startsWith("\t") || string.endsWith("\t")) {
            throw new TemplateParseException("Field \"" + string2 + "\" contains leading or trailing whitespace.", new String[]{"Remove the leading and trailing spaces from the field reference"});
        }
    }

    private static void validateLookupField(ParsedField parsedField, String string, boolean bl) throws TemplateParseException {
        int n;
        ParsedField.NameTerm[] nameTermArray;
        if (!bl && (nameTermArray = parsedField.getTerms()) != null && (n = FieldParser.getMultiValuedRangeCount(nameTermArray)) > 0) {
            throw new TemplateParseException("Field \"" + string + "\" is a data lookup field and has a range inside \"[ ]\" covering multiple values." + "  A data lookup field can only be a single value.");
        }
    }

    private static int getMultiValuedRangeCount(ParsedField.NameTerm[] nameTermArray) {
        int n = 0;
        for (int i = 0; i < nameTermArray.length; ++i) {
            ParsedField.NameTerm nameTerm = nameTermArray[i];
            if (nameTerm.getRange() == null) continue;
            n += nameTerm.getRange().isMultiValued() ? 1 : 0;
        }
        return n;
    }

    private static void validateSetVariableField(ParsedField parsedField, String string) throws TemplateParseException {
        int n;
        String string2 = parsedField.getVariableName();
        for (n = 0; n < string2.length(); ++n) {
            char c = string2.charAt(n);
            if (Character.isLetterOrDigit(c) || c == '_') continue;
            throw new TemplateParseException("Field \"" + string + "\" is a set-variable field and can only have a simple name using alpha-numerics " + "and the '_' character");
        }
        n = 0;
        if (!parsedField.isExpression()) {
            n = FieldParser.getMultiValuedRangeCount(parsedField.getTerms());
        }
        if (n > 0) {
            throw new TemplateParseException("Field \"" + string + "\" is a set-variable field and has a range inside \"[ ]\" covering multiple values." + "  A set-variable field can only be a single value.");
        }
    }

    private static String[] tokenizeQualifiers(String string, String string2) throws TemplateParseException {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        boolean bl = false;
        string = XMLUtilities.decode(string);
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '(') {
                if (bl) {
                    throw new TemplateParseException("Field \"" + string2 + "\" is not valid - an open bracket '(' was found inside brackets.", new String[]{"Make sure brackets are not nested."});
                }
                bl = true;
                continue;
            }
            if (c == ')') {
                if (!bl) {
                    throw new TemplateParseException("Field \"" + string2 + "\" is not valid - a close bracket ')' was found with no open bracket.", new String[]{"Make sure brackets are correct."});
                }
                bl = false;
                continue;
            }
            if (c != ',' || bl) continue;
            String string3 = string.substring(n, i);
            arrayList.add(string3.trim());
            n = i + 1;
        }
        if (n < string.length()) {
            arrayList.add(string.substring(n, string.length()));
        }
        String[] stringArray = null;
        if (!arrayList.isEmpty()) {
            stringArray = new String[arrayList.size()];
            arrayList.toArray(stringArray);
        }
        return stringArray;
    }

    private static String[] tokenizeParams(String string, String string2) throws TemplateParseException {
        ArrayList<String> arrayList = new ArrayList<String>();
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer();
        if (string != null) {
            string = XMLUtilities.decode(string);
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (FieldParser.isSingleQuote(c)) {
                    if (!bl) {
                        bl = true;
                        continue;
                    }
                    FieldParser.replaceUnderscores(stringBuffer);
                    arrayList.add(stringBuffer.toString());
                    stringBuffer.setLength(0);
                    bl = false;
                    continue;
                }
                if (c == ',' || !bl) continue;
                stringBuffer.append(c);
            }
        }
        if (bl) {
            throw new TemplateParseException("Field \"" + string2 + "\"" + " is not of an acceptable format.  There is an unclosed literal.", new String[]{"Check all the quote (') characters are matched.", "Make sure your field contains no spaces."});
        }
        String[] stringArray = null;
        if (!arrayList.isEmpty()) {
            stringArray = new String[arrayList.size()];
            arrayList.toArray(stringArray);
        }
        return stringArray;
    }

    private static boolean isSingleQuote(char c) {
        return c == '\'' || c == '\u2018' || c == '\u2019';
    }

    private static void replaceUnderscores(StringBuffer stringBuffer) {
        for (int i = 0; i < stringBuffer.length(); ++i) {
            if (stringBuffer.charAt(i) != '_') continue;
            if (i > 0 && stringBuffer.charAt(i - 1) == '\\') {
                stringBuffer.replace(i - 1, i + 1, "_");
                continue;
            }
            stringBuffer.setCharAt(i, ' ');
        }
    }

    private static void parseBarcodeField(ParsedField parsedField) throws TemplateParseException {
        String string = parsedField.getOriginalFieldTextSansPrefix();
        if ("".equals(string.trim())) {
            throw new TemplateParseException("Barcode field format is " + DM_BARCODE_FIELD + "imageRef" + A + "type" + A + "key=value...", new String[]{"eg. " + DM_BARCODE_FIELD + "barcodeImg1" + A + "code39", "eg. " + DM_BARCODE_FIELD + "barcodeImg1" + A + "code128" + A + "dpi=600" + A + "orientation=90"});
        }
        try {
            BarcodeInfo barcodeInfo = BarcodeInfoFactory.generate(string);
            parsedField.setBarcodeInfo(barcodeInfo);
        }
        catch (BarcodeException barcodeException) {
            throw new TemplateParseException(barcodeException.getMessage(), barcodeException.getSuggestions());
        }
    }

    private static void parseQRcodeField(ParsedField parsedField, String string) throws TemplateParseException {
        if ("".equals(string)) {
            throw new TemplateParseException("QRcode field format is " + DM_QRCODE_FIELD + "imageRef" + A + "key=value...", new String[]{"eg. " + DM_QRCODE_FIELD + "myQrCode1", "eg. " + DM_QRCODE_FIELD + "myQrCode1" + A + "dpi=300;ec=H"});
        }
        String string2 = parsedField.getOriginalFieldTextSansPrefix();
        try {
            BarcodeInfo barcodeInfo = BarcodeInfoFactory.generate(BarcodeType.QR_CODE, string2);
            parsedField.setBarcodeInfo(barcodeInfo);
        }
        catch (BarcodeException barcodeException) {
            throw new TemplateParseException(barcodeException.getMessage(), barcodeException.getSuggestions());
        }
    }

    private static void parseCoordinatorField(ParsedField parsedField) throws TemplateParseException {
        String string = parsedField.getOriginalFieldTextSansPrefix().trim();
        if (!("".equals(string) || DM_COORDINATOR_PARAM_PAD_TO_EVEN_PAGE.equals(string) || DM_COORDINATOR_PARAM_PAD_TO_ODD_PAGE.equals(string) || DM_COORDINATOR_PARAM_NEW_FILE.equals(string) || string.startsWith("newFile:"))) {
            throw new TemplateParseException("Coordinator field format is coordinator: or coordinator:<option>", new String[]{"eg. coordinator:", "eg. coordinator:padToEvenPage", "eg. coordinator:padToOddPage", "eg. coordinator:newFile"});
        }
    }

    private static void validateRangeExpression(String string, String string2) throws TemplateParseException {
        ParsedField.Expression expression = FieldParser.parseExpression(string, string2);
        if (expression.getTerms() != null) {
            ParsedField.NameTerm[][] nameTermArray = expression.getTerms();
            int n = nameTermArray.length;
            for (int i = 0; i < n; ++i) {
                ParsedField.NameTerm[] nameTermArray2;
                for (ParsedField.NameTerm nameTerm : nameTermArray2 = nameTermArray[i]) {
                    String string3 = nameTerm.getFullTerm();
                    if (!string3.startsWith("$") || !ContentStreamPopulatorObfImpl.B(string3)) continue;
                    throw new TemplateParseException("References to built in variables in a [range] must be via a custom variable", new String[]{"Define a new template-variable, set it to the value required then use it inside the range []"});
                }
            }
        }
    }

    private static class _C {
        private static final Set<String> A = new HashSet<String>();
        public static final _C B = new _C("lhs");
        public static final _C E = new _C("rhs");
        public static final _C D = new _C("full");
        private final String C;

        private _C(String string) {
            if (A.contains(string)) {
                throw new IllegalStateException(string + " is already registered");
            }
            this.C = string;
            A.add(this.C);
        }
    }

    private static class _A {
        private String A;
        private String[] B;

        private _A(String string) {
            this(string, null);
        }

        private _A(String string, String[] stringArray) {
            this.A = string;
            this.B = stringArray;
        }

        public static _A A(String string, String string2, boolean bl) throws TemplateParseException {
            if (string == null || "".equals(string.trim())) {
                throw new TemplateParseException("Field \"" + string2 + "\"" + " is missing the name of the item to lookup", new String[]{"Make sure your field contains no spaces."});
            }
            string = string.trim();
            int n = string.indexOf(40);
            int n2 = string.indexOf(41);
            if (n == -1) {
                return new _A(string);
            }
            if (n2 == n + 1) {
                return new _A(string.substring(0, n));
            }
            if (n2 == -1) {
                throw new TemplateParseException("Field \"" + string2 + "\"" + " is missing the close bracket.", new String[]{"Make sure your field contains no spaces."});
            }
            String string3 = string.substring(0, n);
            if (string3 == null || "".equals(string3.trim())) {
                String string4 = bl ? FieldParser.Q : "method";
                throw new TemplateParseException("Field \"" + string2 + "\"" + " is not of an acceptable format.  The " + string4 + " signature " + "must be of the form \"name\", \"name()\" or \"name('param1','param2'...)\".", new String[]{"Make sure your field contains no spaces."});
            }
            String string5 = string.substring(n + 1);
            ArrayList<String> arrayList = new ArrayList<String>();
            boolean bl2 = false;
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < string5.length(); ++i) {
                char c = string5.charAt(i);
                if (FieldParser.isSingleQuote(c)) {
                    bl2 = !bl2;
                    continue;
                }
                if (bl2) {
                    stringBuffer.append(c);
                    continue;
                }
                if (c == ' ') continue;
                if (c == ',') {
                    FieldParser.replaceUnderscores(stringBuffer);
                    arrayList.add(stringBuffer.toString());
                    stringBuffer.setLength(0);
                    continue;
                }
                if (c == ')') break;
                String string6 = bl ? FieldParser.Q : "method";
                throw new TemplateParseException("Field \"" + string2 + "\"" + " is not of an acceptable format.  Each parameter to a " + string6 + " must be in single quotes (').", new String[]{"Check all the quote (') characters are matched.", "Make sure your field contains no spaces."});
            }
            if (bl2) {
                throw new TemplateParseException("Field \"" + string2 + "\"" + " is not of an acceptable format.  There is an unclosed literal.", new String[]{"Check all the quote (') characters are matched.", "Make sure your field contains no spaces."});
            }
            FieldParser.replaceUnderscores(stringBuffer);
            arrayList.add(stringBuffer.toString());
            String[] stringArray = new String[arrayList.size()];
            arrayList.toArray(stringArray);
            return new _A(string3, stringArray);
        }
    }

    private static class _B {
        int A;
        boolean B;

        public _B(int n, boolean bl) {
            this.A = n;
            this.B = bl;
        }
    }
}

