/*
 * Decompiled with CFR 0.152.
 */
package com.docmosis.template.analysis.barcode.impl;

import com.docmosis.template.analysis.barcode.BarcodeException;
import com.docmosis.template.analysis.barcode.BarcodeGenerator;
import com.docmosis.template.analysis.barcode.BarcodeInfo;
import com.docmosis.template.analysis.barcode.BarcodeInfoQR;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.QRCodeWriter;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.Hashtable;
import javax.imageio.ImageIO;

public class BarcodeGeneratorQR
implements BarcodeGenerator {
    private static final double A = 0.03937007874015748;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream generate(BarcodeInfo barcodeInfo) throws BarcodeException {
        if (!(barcodeInfo instanceof BarcodeInfoQR)) {
            throw new BarcodeException("Program error - expected qr code info but got [" + barcodeInfo.getClass().getName(), null);
        }
        BarcodeInfoQR barcodeInfoQR = (BarcodeInfoQR)barcodeInfo;
        String string = barcodeInfoQR.getBarcodeValue();
        String string2 = "png";
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            int n;
            Hashtable<EncodeHintType, Object> hashtable = new Hashtable<EncodeHintType, Object>();
            hashtable.put(EncodeHintType.ERROR_CORRECTION, ErrorCorrectionLevel.valueOf((String)barcodeInfoQR.getErrorCorrectionLevel()));
            hashtable.put(EncodeHintType.CHARACTER_SET, barcodeInfoQR.getEncoding());
            hashtable.put(EncodeHintType.MARGIN, 0);
            QRCodeWriter qRCodeWriter = new QRCodeWriter();
            int n2 = n = (int)(barcodeInfoQR.getHeight() * (double)barcodeInfoQR.getDpi() * 0.03937007874015748);
            BitMatrix bitMatrix = qRCodeWriter.encode(string, BarcodeFormat.QR_CODE, n2, n, hashtable);
            int n3 = bitMatrix.getWidth();
            BufferedImage bufferedImage = new BufferedImage(n3, n3, 1);
            bufferedImage.createGraphics();
            Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
            try {
                graphics2D.setColor(Color.WHITE);
                graphics2D.fillRect(0, 0, n3, n3);
                graphics2D.setColor(Color.BLACK);
                for (int i = 0; i < n3; ++i) {
                    for (int j = 0; j < n3; ++j) {
                        if (!bitMatrix.get(i, j)) continue;
                        graphics2D.fillRect(i, j, 1, 1);
                    }
                }
                ImageIO.write((RenderedImage)bufferedImage, string2, byteArrayOutputStream);
            }
            finally {
                graphics2D.dispose();
            }
            return new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        }
        catch (Exception exception) {
            throw new BarcodeException("Error generating image " + exception.getMessage(), exception, null);
        }
    }
}

