/*
 * Decompiled with CFR 0.152.
 */
package com.docmosis.template.analysis.barcode.impl;

import com.docmosis.template.analysis.barcode.BarcodeException;
import com.docmosis.template.analysis.barcode.BarcodeInfo;
import com.docmosis.template.analysis.barcode.BarcodeInfoPdf417;
import com.docmosis.template.analysis.barcode.impl.BasicBarcodeGenerator;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.krysalis.barcode4j.impl.AbstractBarcodeBean;
import org.krysalis.barcode4j.impl.pdf417.PDF417Bean;
import org.krysalis.barcode4j.output.CanvasProvider;
import org.krysalis.barcode4j.output.bitmap.BitmapCanvasProvider;

public class BarcodeGeneratorPdf417
extends BasicBarcodeGenerator {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream generate(BarcodeInfo barcodeInfo) throws BarcodeException {
        ByteArrayInputStream byteArrayInputStream;
        if (!(barcodeInfo instanceof BarcodeInfoPdf417)) {
            throw new BarcodeException("Program error - expected pdf 417 info but got [" + barcodeInfo.getClass().getName(), null);
        }
        BarcodeInfoPdf417 barcodeInfoPdf417 = (BarcodeInfoPdf417)barcodeInfo;
        PDF417Bean pDF417Bean = new PDF417Bean();
        super.setCommonSettings(barcodeInfoPdf417, (AbstractBarcodeBean)pDF417Bean);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            BitmapCanvasProvider bitmapCanvasProvider = new BitmapCanvasProvider((OutputStream)byteArrayOutputStream, "image/png", barcodeInfoPdf417.getDpi(), 12, false, barcodeInfoPdf417.getOrientation());
            pDF417Bean.generateBarcode((CanvasProvider)bitmapCanvasProvider, barcodeInfoPdf417.getBarcodeValue());
            bitmapCanvasProvider.finish();
            byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        }
        catch (Throwable throwable) {
            try {
                byteArrayOutputStream.close();
                throw throwable;
            }
            catch (Exception exception) {
                throw new BarcodeException("Error generating image " + exception.getMessage(), exception, null);
            }
        }
        byteArrayOutputStream.close();
        return byteArrayInputStream;
    }
}

