/*
 * Decompiled with CFR 0.152.
 */
package com.docmosis.template.analysis.barcode.impl;

import com.docmosis.template.analysis.barcode.BarcodeException;
import com.docmosis.template.analysis.barcode.BarcodeInfo;
import com.docmosis.template.analysis.barcode.BarcodeInfoItf14;
import com.docmosis.template.analysis.barcode.impl.BasicBarcodeGenerator;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.krysalis.barcode4j.ChecksumMode;
import org.krysalis.barcode4j.impl.AbstractBarcodeBean;
import org.krysalis.barcode4j.impl.int2of5.ITF14Bean;
import org.krysalis.barcode4j.output.CanvasProvider;
import org.krysalis.barcode4j.output.bitmap.BitmapCanvasProvider;

public class BarcodeGeneratorItf14
extends BasicBarcodeGenerator {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream generate(BarcodeInfo barcodeInfo) throws BarcodeException {
        ByteArrayInputStream byteArrayInputStream;
        Object object;
        if (!(barcodeInfo instanceof BarcodeInfoItf14)) {
            throw new BarcodeException("Program error - expected itf 14 info but got [" + barcodeInfo.getClass().getName(), null);
        }
        BarcodeInfoItf14 barcodeInfoItf14 = (BarcodeInfoItf14)barcodeInfo;
        ITF14Bean iTF14Bean = new ITF14Bean();
        super.setCommonSettings(barcodeInfoItf14, (AbstractBarcodeBean)iTF14Bean);
        iTF14Bean.setWideFactor(barcodeInfoItf14.getWideFactor());
        if (barcodeInfoItf14.getChecksumMode() != null) {
            object = barcodeInfoItf14.getChecksumMode();
            if (((String)object).equalsIgnoreCase("add")) {
                iTF14Bean.setChecksumMode(ChecksumMode.CP_ADD);
            } else if (((String)object).equalsIgnoreCase("auto")) {
                iTF14Bean.setChecksumMode(ChecksumMode.CP_AUTO);
            } else if (((String)object).equalsIgnoreCase("check")) {
                iTF14Bean.setChecksumMode(ChecksumMode.CP_CHECK);
            } else if (((String)object).equalsIgnoreCase("ignore")) {
                iTF14Bean.setChecksumMode(ChecksumMode.CP_IGNORE);
            }
        }
        if (barcodeInfoItf14.getDisplayChecksum() != null) {
            iTF14Bean.setDisplayChecksum(Boolean.TRUE.equals(barcodeInfoItf14.getDisplayChecksum()));
        }
        iTF14Bean.setBearerBarWidth(barcodeInfoItf14.getBearerBarWidth());
        object = new ByteArrayOutputStream();
        try {
            BitmapCanvasProvider bitmapCanvasProvider = new BitmapCanvasProvider((OutputStream)object, "image/png", barcodeInfoItf14.getDpi(), 12, false, barcodeInfoItf14.getOrientation());
            iTF14Bean.generateBarcode((CanvasProvider)bitmapCanvasProvider, barcodeInfoItf14.getBarcodeValue());
            bitmapCanvasProvider.finish();
            byteArrayInputStream = new ByteArrayInputStream(((ByteArrayOutputStream)object).toByteArray());
        }
        catch (Throwable throwable) {
            try {
                ((ByteArrayOutputStream)object).close();
                throw throwable;
            }
            catch (Exception exception) {
                throw new BarcodeException("Error generating image " + exception.getMessage(), exception, null);
            }
        }
        ((ByteArrayOutputStream)object).close();
        return byteArrayInputStream;
    }
}

