/*
 * Decompiled with CFR 0.152.
 */
package com.docmosis.template.analysis.barcode.impl;

import com.docmosis.template.analysis.barcode.BarcodeException;
import com.docmosis.template.analysis.barcode.BarcodeInfo;
import com.docmosis.template.analysis.barcode.BarcodeInfoIMb;
import com.docmosis.template.analysis.barcode.impl.BasicBarcodeGenerator;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.krysalis.barcode4j.ChecksumMode;
import org.krysalis.barcode4j.impl.AbstractBarcodeBean;
import org.krysalis.barcode4j.impl.fourstate.USPSIntelligentMailBean;
import org.krysalis.barcode4j.output.CanvasProvider;
import org.krysalis.barcode4j.output.bitmap.BitmapCanvasProvider;

public class BarcodeGeneratorIMb
extends BasicBarcodeGenerator {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream generate(BarcodeInfo barcodeInfo) throws BarcodeException {
        ByteArrayInputStream byteArrayInputStream;
        Object object;
        if (!(barcodeInfo instanceof BarcodeInfoIMb)) {
            throw new BarcodeException("Program error - expected IMb info but got [" + barcodeInfo.getClass().getName(), null);
        }
        BarcodeInfoIMb barcodeInfoIMb = (BarcodeInfoIMb)barcodeInfo;
        USPSIntelligentMailBean uSPSIntelligentMailBean = new USPSIntelligentMailBean();
        super.setCommonSettings(barcodeInfoIMb, (AbstractBarcodeBean)uSPSIntelligentMailBean);
        if (barcodeInfoIMb.getChecksumMode() != null) {
            object = barcodeInfoIMb.getChecksumMode();
            if (((String)object).equalsIgnoreCase("add")) {
                uSPSIntelligentMailBean.setChecksumMode(ChecksumMode.CP_ADD);
            } else if (((String)object).equalsIgnoreCase("auto")) {
                uSPSIntelligentMailBean.setChecksumMode(ChecksumMode.CP_AUTO);
            } else if (((String)object).equalsIgnoreCase("check")) {
                uSPSIntelligentMailBean.setChecksumMode(ChecksumMode.CP_CHECK);
            } else if (((String)object).equalsIgnoreCase("ignore")) {
                uSPSIntelligentMailBean.setChecksumMode(ChecksumMode.CP_IGNORE);
            }
        }
        if (barcodeInfoIMb.getIntercharGapWidth() != null) {
            uSPSIntelligentMailBean.setIntercharGapWidth(barcodeInfoIMb.getIntercharGapWidth().doubleValue());
        }
        if (barcodeInfoIMb.getTrackHeight() != null) {
            uSPSIntelligentMailBean.setTrackHeight(barcodeInfoIMb.getTrackHeight().doubleValue());
        }
        if (barcodeInfoIMb.getAscenderHeight() != null) {
            uSPSIntelligentMailBean.setAscenderHeight(barcodeInfoIMb.getAscenderHeight().doubleValue());
        }
        object = new ByteArrayOutputStream();
        try {
            BitmapCanvasProvider bitmapCanvasProvider = new BitmapCanvasProvider((OutputStream)object, "image/png", barcodeInfoIMb.getDpi(), 12, false, barcodeInfoIMb.getOrientation());
            uSPSIntelligentMailBean.generateBarcode((CanvasProvider)bitmapCanvasProvider, barcodeInfoIMb.getBarcodeValue());
            bitmapCanvasProvider.finish();
            byteArrayInputStream = new ByteArrayInputStream(((ByteArrayOutputStream)object).toByteArray());
        }
        catch (Throwable throwable) {
            try {
                ((ByteArrayOutputStream)object).close();
                throw throwable;
            }
            catch (Exception exception) {
                throw new BarcodeException("Error generating image " + exception.getMessage(), exception, null);
            }
        }
        ((ByteArrayOutputStream)object).close();
        return byteArrayInputStream;
    }
}

