/*
 * Decompiled with CFR 0.152.
 */
package com.docmosis.template.analysis.barcode.impl;

import com.docmosis.template.analysis.barcode.BarcodeException;
import com.docmosis.template.analysis.barcode.BarcodeInfo;
import com.docmosis.template.analysis.barcode.BarcodeInfoCode39;
import com.docmosis.template.analysis.barcode.impl.BasicBarcodeGenerator;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.krysalis.barcode4j.ChecksumMode;
import org.krysalis.barcode4j.impl.AbstractBarcodeBean;
import org.krysalis.barcode4j.impl.code39.Code39Bean;
import org.krysalis.barcode4j.output.CanvasProvider;
import org.krysalis.barcode4j.output.bitmap.BitmapCanvasProvider;

public class BarcodeGeneratorCode39
extends BasicBarcodeGenerator {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream generate(BarcodeInfo barcodeInfo) throws BarcodeException {
        ByteArrayInputStream byteArrayInputStream;
        Object object;
        if (!(barcodeInfo instanceof BarcodeInfoCode39)) {
            throw new BarcodeException("Program error - expected code 39 info but got [" + barcodeInfo.getClass().getName(), null);
        }
        BarcodeInfoCode39 barcodeInfoCode39 = (BarcodeInfoCode39)barcodeInfo;
        Code39Bean code39Bean = new Code39Bean();
        super.setCommonSettings(barcodeInfoCode39, (AbstractBarcodeBean)code39Bean);
        code39Bean.setWideFactor(barcodeInfoCode39.getWideFactor());
        code39Bean.setExtendedCharSetEnabled(barcodeInfoCode39.isExtendedCharsetEnabled());
        if (barcodeInfoCode39.getChecksumMode() != null) {
            object = barcodeInfoCode39.getChecksumMode();
            if (((String)object).equalsIgnoreCase("add")) {
                code39Bean.setChecksumMode(ChecksumMode.CP_ADD);
            } else if (((String)object).equalsIgnoreCase("auto")) {
                code39Bean.setChecksumMode(ChecksumMode.CP_AUTO);
            } else if (((String)object).equalsIgnoreCase("check")) {
                code39Bean.setChecksumMode(ChecksumMode.CP_CHECK);
            } else if (((String)object).equalsIgnoreCase("ignore")) {
                code39Bean.setChecksumMode(ChecksumMode.CP_IGNORE);
            }
        }
        if (barcodeInfoCode39.getDisplayChecksum() != null) {
            code39Bean.setDisplayChecksum(Boolean.TRUE.equals(barcodeInfoCode39.getDisplayChecksum()));
        }
        if (barcodeInfoCode39.getDisplayStartStop() != null) {
            code39Bean.setDisplayStartStop(Boolean.TRUE.equals(barcodeInfoCode39.getDisplayStartStop()));
        }
        if (barcodeInfoCode39.getIntercharGapWidth() != null) {
            code39Bean.setIntercharGapWidth(barcodeInfoCode39.getIntercharGapWidth().doubleValue());
        }
        object = new ByteArrayOutputStream();
        try {
            BitmapCanvasProvider bitmapCanvasProvider = new BitmapCanvasProvider((OutputStream)object, "image/png", barcodeInfoCode39.getDpi(), 12, false, barcodeInfoCode39.getOrientation());
            code39Bean.generateBarcode((CanvasProvider)bitmapCanvasProvider, barcodeInfoCode39.getBarcodeValue());
            bitmapCanvasProvider.finish();
            byteArrayInputStream = new ByteArrayInputStream(((ByteArrayOutputStream)object).toByteArray());
        }
        catch (Throwable throwable) {
            try {
                ((ByteArrayOutputStream)object).close();
                throw throwable;
            }
            catch (Exception exception) {
                throw new BarcodeException("Error generating image " + exception.getMessage(), exception, null);
            }
        }
        ((ByteArrayOutputStream)object).close();
        return byteArrayInputStream;
    }
}

