/*
 * Decompiled with CFR 0.152.
 */
package com.docmosis.template.analysis.barcode.impl;

import com.docmosis.template.analysis.barcode.BarcodeException;
import com.docmosis.template.analysis.barcode.BarcodeInfo;
import com.docmosis.template.analysis.barcode.BarcodeInfoCode128;
import com.docmosis.template.analysis.barcode.impl.BasicBarcodeGenerator;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.krysalis.barcode4j.impl.AbstractBarcodeBean;
import org.krysalis.barcode4j.impl.code128.Code128Bean;
import org.krysalis.barcode4j.output.CanvasProvider;
import org.krysalis.barcode4j.output.bitmap.BitmapCanvasProvider;

public class BarcodeGeneratorCode128
extends BasicBarcodeGenerator {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream generate(BarcodeInfo barcodeInfo) throws BarcodeException {
        ByteArrayInputStream byteArrayInputStream;
        if (!(barcodeInfo instanceof BarcodeInfoCode128)) {
            throw new BarcodeException("Program error - expected code 128 info but got [" + barcodeInfo.getClass().getName(), null);
        }
        BarcodeInfoCode128 barcodeInfoCode128 = (BarcodeInfoCode128)barcodeInfo;
        Code128Bean code128Bean = new Code128Bean();
        super.setCommonSettings(barcodeInfoCode128, (AbstractBarcodeBean)code128Bean);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            BitmapCanvasProvider bitmapCanvasProvider = new BitmapCanvasProvider((OutputStream)byteArrayOutputStream, "image/png", barcodeInfoCode128.getDpi(), 12, false, barcodeInfoCode128.getOrientation());
            code128Bean.generateBarcode((CanvasProvider)bitmapCanvasProvider, barcodeInfoCode128.getBarcodeValue());
            bitmapCanvasProvider.finish();
            byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        }
        catch (Throwable throwable) {
            try {
                byteArrayOutputStream.close();
                throw throwable;
            }
            catch (Exception exception) {
                throw new BarcodeException("Error generating image " + exception.getMessage(), exception, null);
            }
        }
        byteArrayOutputStream.close();
        return byteArrayInputStream;
    }
}

