/*
 * Decompiled with CFR 0.152.
 */
package com.docmosis.template.analysis.barcode;

import com.docmosis.util.DMProperties;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class BarcodeType
implements Serializable {
    private static final int E = DMProperties.getInt("docmosis.populator.barcode.value.maxLen", 200);
    private static final Map<String, BarcodeType> C = new HashMap<String, BarcodeType>();
    private static String[] F;
    public static final BarcodeType CODE_39;
    public static final BarcodeType CODE_128;
    public static final BarcodeType PDF_417;
    public static final BarcodeType ITF_14;
    public static final BarcodeType IMb;
    public static final BarcodeType QR_CODE;
    private final String A;
    private final boolean D;
    private final int B;

    private BarcodeType(String string, boolean bl, int n) {
        this.A = string;
        this.D = bl;
        this.B = n;
    }

    private static BarcodeType register(String string, boolean bl, int n) {
        BarcodeType barcodeType = new BarcodeType(string, bl, n);
        C.put(string, barcodeType);
        F = new String[C.size()];
        C.keySet().toArray(F);
        return barcodeType;
    }

    public static BarcodeType forName(String string) {
        return C.get(string);
    }

    public static String[] getNames() {
        return F;
    }

    private static int getMaxDataLen(String string) {
        return DMProperties.getInt(string, E);
    }

    public int hashCode() {
        int n = 31;
        int n2 = 1;
        n2 = 31 * n2 + (this.D ? 1231 : 1237);
        n2 = 31 * n2 + this.B;
        n2 = 31 * n2 + (this.A == null ? 0 : this.A.hashCode());
        return n2;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        BarcodeType barcodeType = (BarcodeType)object;
        if (this.D != barcodeType.D) {
            return false;
        }
        if (this.B != barcodeType.B) {
            return false;
        }
        return !(this.A == null ? barcodeType.A != null : !this.A.equals(barcodeType.A));
    }

    public String getName() {
        return this.A;
    }

    public boolean isQRCode() {
        return this.D;
    }

    public String toString() {
        return this.getName();
    }

    public int getMaxDataLen() {
        return this.B;
    }

    static {
        CODE_39 = BarcodeType.register("code39", false, E);
        CODE_128 = BarcodeType.register("code128", false, E);
        PDF_417 = BarcodeType.register("pdf417", false, E);
        ITF_14 = BarcodeType.register("itf14", false, E);
        IMb = BarcodeType.register("imb", false, E);
        QR_CODE = BarcodeType.register("qrcode", true, BarcodeType.getMaxDataLen("docmosis.populator.barcode.qrcode.value.maxLen"));
    }
}

