/*
 * Decompiled with CFR 0.152.
 */
package com.docmosis.template.analysis.barcode;

import com.docmosis.template.analysis.barcode.BarcodeException;
import com.docmosis.template.analysis.barcode.BarcodeInfo;
import com.docmosis.util.DMProperties;
import com.docmosis.util.StringUtilities;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class BarcodeInfoQR
extends BarcodeInfo {
    private static final String \u00b5 = "L";
    private static final String \u00aa = "M";
    private static final String \u00c7 = "Q";
    private static final String \u00c0 = "H";
    private static final String[] \u00c6 = new String[]{"H", "L", "M", "Q"};
    private static final Set<String> \u00c3 = new HashSet<String>(Arrays.asList(\u00c6));
    private static final String \u00c1 = StringUtilities.arrayToString(\u00c6, "|", null);
    private static final String \u00c8 = "docmosis.populator.barcode.qrcode.errorCorrection.default";
    private static final String \u00c5 = DMProperties.getString("docmosis.populator.barcode.qrcode.errorCorrection.default", "L");
    protected static final String[] BARCODE_ERROR_CORRECTION_NAME = DMProperties.getStringArray("docmosis.populator.barcode.qrcode.errorCorrection.name", BarcodeInfo.BARCODE_KEY_SEPARATOR);
    private static final String \u00c2 = "docmosis.populator.barcode.qrcode.encoding.default";
    private static final String \u00c9 = DMProperties.getString("docmosis.populator.barcode.qrcode.encoding.default", "UTF-8");
    protected static final String[] BARCODE_ENCODING_DEFAULT_NAME = DMProperties.getStringArray("docmosis.populator.barcode.qrcode.encoding.name", BarcodeInfo.BARCODE_KEY_SEPARATOR);
    private static final String[][] \u00c4 = new String[][]{BARCODE_DPI_NAME, BARCODE_ENCODING_DEFAULT_NAME, BARCODE_ERROR_CORRECTION_NAME};
    protected static final String[] BARCODE_SETTING_NAMES_FLAT = BarcodeInfoQR.flattenNames(\u00c4);
    private String \u00a5 = \u00c5;
    private String \u00ba = \u00c9;

    public BarcodeInfoQR(BarcodeInfo barcodeInfo) {
        super(barcodeInfo);
        if (barcodeInfo instanceof BarcodeInfoQR) {
            // empty if block
        }
    }

    public String getErrorCorrectionLevel() {
        return this.\u00a5;
    }

    public void setErrorCorrectionLevel(String string) {
        this.\u00a5 = string;
    }

    public String getEncoding() {
        return this.\u00ba;
    }

    public void setEncoding(String string) {
        this.\u00ba = string;
    }

    @Override
    protected boolean setField(String string, String string2) throws BarcodeException {
        boolean bl = false;
        if (BarcodeInfoQR.isKey(BARCODE_ERROR_CORRECTION_NAME, string)) {
            bl = true;
            string2 = string2.trim();
            this.validateErrorCorrection(string2);
            this.setErrorCorrectionLevel(string2);
        } else if (BarcodeInfoQR.isKey(BARCODE_ENCODING_DEFAULT_NAME, string)) {
            bl = true;
            string2 = string2.trim();
            this.setEncoding(string2);
        }
        return bl;
    }

    private void validateErrorCorrection(String string) throws BarcodeException {
        if (!\u00c3.contains(string)) {
            throw new BarcodeException("Invalid error correction mode [" + string + "].  Must be one of " + \u00c1, new String[]{"Choose one of " + \u00c1});
        }
    }

    @Override
    protected String[][] getSupportedSettingNames() {
        return \u00c4;
    }

    @Override
    protected String[] getSupportedSettingNamesFlattened() {
        return BARCODE_SETTING_NAMES_FLAT;
    }
}

