/*
 * Decompiled with CFR 0.152.
 */
package com.docmosis.template.analysis.barcode;

import com.docmosis.template.analysis.barcode.BarcodeException;
import com.docmosis.template.analysis.barcode.BarcodeInfo;
import com.docmosis.util.DMProperties;

public class BarcodeInfoItf14
extends BarcodeInfo {
    public static final String CHECKSUM_MODE_ADD = "add";
    public static final String CHECKSUM_MODE_AUTO = "auto";
    public static final String CHECKSUM_MODE_CHECK = "check";
    public static final String CHECKSUM_MODE_IGNORE = "ignore";
    private static final String c = "docmosis.populator.barcode.itf14.wideFactor.default";
    private static final double g = DMProperties.getDouble("docmosis.populator.barcode.itf14.wideFactor.default", 2.2);
    private static final double _ = DMProperties.getDouble("docmosis.populator.barcode.itf14.moduleWidth.default", 1.1);
    private static final double a = DMProperties.getDouble("docmosis.populator.barcode.itf14.quietZone.default", 12.0);
    private static final double U = DMProperties.getDouble("docmosis.populator.barcode.itf14.height.default", 40.0);
    private static final double e = DMProperties.getDouble("docmosis.populator.barcode.itf14.bearerBarWidth.default", 1.0);
    private static final String[] W = DMProperties.getStringArray("docmosis.populator.barcode.itf14.bearerBarWidth.name", BarcodeInfo.BARCODE_KEY_SEPARATOR);
    private static final String[] d = DMProperties.getStringArray("docmosis.populator.barcode.itf14.checksumMode.name", BarcodeInfo.BARCODE_KEY_SEPARATOR);
    private static final String[] V = DMProperties.getStringArray("docmosis.populator.barcode.itf14.wideFactor.name", BarcodeInfo.BARCODE_KEY_SEPARATOR);
    private static final String[] b = DMProperties.getStringArray("docmosis.populator.barcode.itf14.displayChecksum.name", BarcodeInfo.BARCODE_KEY_SEPARATOR);
    private double X = g;
    private double f = e;
    private String Y;
    private Boolean h;
    private static final String[][] Z = new String[][]{BARCODE_DPI_NAME, BARCODE_MODULE_WIDTH_NAME, BARCODE_DO_QUIET_ZONE_NAME, BARCODE_HEIGHT_NAME, BARCODE_ORIENTATION_NAME, BARCODE_FONT_SIZE_NAME, BARCODE_QUIET_ZONE_WIDTH_NAME, BARCODE_QUIET_ZONE_HEIGHT_NAME, d, b, W, V};
    protected static final String[] BARCODE_SETTING_NAMES_FLAT = BarcodeInfoItf14.flattenNames(Z);

    public BarcodeInfoItf14(BarcodeInfo barcodeInfo) {
        super(barcodeInfo);
        if (barcodeInfo instanceof BarcodeInfoItf14) {
            BarcodeInfoItf14 barcodeInfoItf14 = (BarcodeInfoItf14)barcodeInfo;
            this.X = barcodeInfoItf14.X;
            this.f = barcodeInfoItf14.f;
            this.Y = barcodeInfoItf14.Y;
            this.h = barcodeInfoItf14.h;
        } else {
            this.setModuleWidth(_);
            this.setQuietZoneWidth(new Double(a));
            this.setHeight(U);
        }
        this.setDoQuietZone(true);
    }

    @Override
    protected boolean setField(String string, String string2) throws BarcodeException {
        boolean bl = false;
        if (BarcodeInfoItf14.isKey(V, string)) {
            bl = true;
            try {
                this.setWideFactor(Double.parseDouble(string2));
            }
            catch (NumberFormatException numberFormatException) {
                throw new BarcodeException("invalid wide factor setting [" + string2 + "]", new String[]{"The value must be a double value and should be between 2.0 and 3.0"});
            }
        }
        if (BarcodeInfoItf14.isKey(d, string)) {
            bl = true;
            string2 = string2.trim();
            this.validateChecksumMode(string2);
            try {
                this.setChecksumMode(string2);
            }
            catch (NumberFormatException numberFormatException) {
                throw new BarcodeException("invalid display checksum setting [" + string2 + "]", new String[]{"Must be true or false"});
            }
        }
        if (BarcodeInfoItf14.isKey(b, string)) {
            bl = true;
            try {
                this.setBearerBarWidth(new Double(string2));
            }
            catch (NumberFormatException numberFormatException) {
                throw new BarcodeException("invalid bearer bar width setting [" + string2 + "]", new String[]{"The value must be a double value"});
            }
        }
        if (BarcodeInfoItf14.isKey(W, string)) {
            bl = true;
            try {
                this.setDisplayChecksum(Boolean.valueOf(string2));
            }
            catch (NumberFormatException numberFormatException) {
                throw new BarcodeException("invalid display checksum setting [" + string2 + "]", new String[]{"Must be true or false"});
            }
        }
        return bl;
    }

    private void validateChecksumMode(String string) throws BarcodeException {
        String string2 = "add|auto|check|ignore";
        String[] stringArray = "add|auto|check|ignore".split("\\|");
        boolean bl = false;
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string.equalsIgnoreCase(stringArray[i])) continue;
            bl = true;
            break;
        }
        if (!bl) {
            throw new BarcodeException("Invalid checksum mode [" + string + "].  Must be one of " + "add|auto|check|ignore", new String[]{"Choose one of add|auto|check|ignore"});
        }
    }

    @Override
    protected String[][] getSupportedSettingNames() {
        return Z;
    }

    @Override
    protected String[] getSupportedSettingNamesFlattened() {
        return BARCODE_SETTING_NAMES_FLAT;
    }

    public Boolean getDisplayChecksum() {
        return this.h;
    }

    public void setDisplayChecksum(Boolean bl) {
        this.h = bl;
    }

    public String getChecksumMode() {
        return this.Y;
    }

    public void setChecksumMode(String string) {
        this.Y = string;
    }

    public double getBearerBarWidth() {
        return this.f;
    }

    public void setBearerBarWidth(double d) {
        this.f = d;
    }

    public double getWideFactor() {
        return this.X;
    }

    public void setWideFactor(double d) {
        this.X = d;
    }

    @Override
    public String toString() {
        return "BarcodeInfoItf14 [bearerBarWidth=" + this.f + ", checksumMode=" + this.Y + ", displayChecksum=" + this.h + "]";
    }
}

