/*
 * Decompiled with CFR 0.152.
 */
package com.docmosis.template.analysis.barcode;

import com.docmosis.template.analysis.barcode.BarcodeException;
import com.docmosis.template.analysis.barcode.BarcodeInfo;
import com.docmosis.util.DMProperties;

public class BarcodeInfoIMb
extends BarcodeInfo {
    public static final String CHECKSUM_MODE_ADD = "add";
    public static final String CHECKSUM_MODE_AUTO = "auto";
    public static final String CHECKSUM_MODE_CHECK = "check";
    public static final String CHECKSUM_MODE_IGNORE = "ignore";
    private static final double m = DMProperties.getDouble("docmosis.populator.barcode.imb.moduleWidth.default", 1.1);
    private static final double o = DMProperties.getDouble("docmosis.populator.barcode.imb.quietZone.default", 12.0);
    private static final double r = DMProperties.getDouble("docmosis.populator.barcode.imb.height.default", 40.0);
    protected static final String[] BARCODE_CHECKSUM_MODE_NAME = DMProperties.getStringArray("docmosis.populator.barcode.imb.checksumMode.name", BarcodeInfo.BARCODE_KEY_SEPARATOR);
    protected static final String[] BARCODE_INTERCHAR_GAP_WIDTH_NAME = DMProperties.getStringArray("docmosis.populator.barcode.imb.intercharGapWidth.name", BarcodeInfo.BARCODE_KEY_SEPARATOR);
    protected static final String[] BARCODE_TRACK_HEIGHT_NAME = DMProperties.getStringArray("docmosis.populator.barcode.imb.trackHeight.name", BarcodeInfo.BARCODE_KEY_SEPARATOR);
    protected static final String[] BARCODE_ASCENDER_HEIGHT_NAME = DMProperties.getStringArray("docmosis.populator.barcode.imb.ascenderHeight.name", BarcodeInfo.BARCODE_KEY_SEPARATOR);
    private String l;
    private Double p;
    private Double q;
    private Double k;
    private static final String[][] n = new String[][]{BARCODE_DPI_NAME, BARCODE_MODULE_WIDTH_NAME, BARCODE_DO_QUIET_ZONE_NAME, BARCODE_HEIGHT_NAME, BARCODE_ORIENTATION_NAME, BARCODE_FONT_SIZE_NAME, BARCODE_QUIET_ZONE_WIDTH_NAME, BARCODE_QUIET_ZONE_HEIGHT_NAME, BARCODE_CHECKSUM_MODE_NAME, BARCODE_INTERCHAR_GAP_WIDTH_NAME, BARCODE_TRACK_HEIGHT_NAME, BARCODE_ASCENDER_HEIGHT_NAME};
    protected static final String[] BARCODE_SETTING_NAMES_FLAT = BarcodeInfoIMb.flattenNames(n);

    public BarcodeInfoIMb(BarcodeInfo barcodeInfo) {
        super(barcodeInfo);
        if (barcodeInfo instanceof BarcodeInfoIMb) {
            BarcodeInfoIMb barcodeInfoIMb = (BarcodeInfoIMb)barcodeInfo;
            this.l = barcodeInfoIMb.l;
            this.p = barcodeInfoIMb.p;
            this.q = barcodeInfoIMb.q;
            this.k = barcodeInfoIMb.k;
        } else {
            this.setModuleWidth(m);
            this.setQuietZoneWidth(new Double(o));
            this.setHeight(r);
        }
    }

    @Override
    protected boolean setField(String string, String string2) throws BarcodeException {
        boolean bl = false;
        if (BarcodeInfoIMb.isKey(BARCODE_CHECKSUM_MODE_NAME, string)) {
            bl = true;
            string2 = string2.trim();
            this.validateChecksumMode(string2);
            try {
                this.setChecksumMode(string2);
            }
            catch (NumberFormatException numberFormatException) {
                throw new BarcodeException("invalid display checksum setting [" + string2 + "]", new String[]{"Must be true or false"});
            }
        }
        if (BarcodeInfoIMb.isKey(BARCODE_INTERCHAR_GAP_WIDTH_NAME, string)) {
            bl = true;
            try {
                this.setIntercharGapWidth(new Double(string2));
            }
            catch (NumberFormatException numberFormatException) {
                throw new BarcodeException("invalid interchar gap width setting [" + string2 + "]", new String[]{"The value must be a double value"});
            }
        }
        if (BarcodeInfoIMb.isKey(BARCODE_TRACK_HEIGHT_NAME, string)) {
            bl = true;
            try {
                this.setTrackHeight(new Double(string2));
            }
            catch (NumberFormatException numberFormatException) {
                throw new BarcodeException("invalid track height setting [" + string2 + "]", new String[]{"The value must be a double value"});
            }
        }
        if (BarcodeInfoIMb.isKey(BARCODE_ASCENDER_HEIGHT_NAME, string)) {
            bl = true;
            try {
                this.setAscenderHeight(new Double(string2));
            }
            catch (NumberFormatException numberFormatException) {
                throw new BarcodeException("invalid ascender height setting [" + string2 + "]", new String[]{"The value must be a double value"});
            }
        }
        return bl;
    }

    private void validateChecksumMode(String string) throws BarcodeException {
        String string2 = "add|auto|check|ignore";
        String[] stringArray = "add|auto|check|ignore".split("\\|");
        boolean bl = false;
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string.equalsIgnoreCase(stringArray[i])) continue;
            bl = true;
            break;
        }
        if (!bl) {
            throw new BarcodeException("Invalid checksum mode [" + string + "].  Must be one of " + "add|auto|check|ignore", new String[]{"Choose one of add|auto|check|ignore"});
        }
    }

    @Override
    protected String[][] getSupportedSettingNames() {
        return n;
    }

    @Override
    protected String[] getSupportedSettingNamesFlattened() {
        return BARCODE_SETTING_NAMES_FLAT;
    }

    public String getChecksumMode() {
        return this.l;
    }

    public void setChecksumMode(String string) {
        this.l = string;
    }

    public Double getIntercharGapWidth() {
        return this.p;
    }

    public void setIntercharGapWidth(Double d) {
        this.p = d;
    }

    public Double getTrackHeight() {
        return this.q;
    }

    public void setTrackHeight(Double d) {
        this.q = d;
    }

    public Double getAscenderHeight() {
        return this.k;
    }

    public void setAscenderHeight(Double d) {
        this.k = d;
    }

    @Override
    public String toString() {
        return "BarcodeInfoIMb [checksumMode=" + this.l + ", intercharGapWidth=" + this.p + ", trackHeight=" + this.q + ", ascenderHeight=" + this.k + "]";
    }
}

