/*
 * Decompiled with CFR 0.152.
 */
package com.docmosis.template.analysis.barcode;

import com.docmosis.template.analysis.barcode.BarcodeException;
import com.docmosis.template.analysis.barcode.BarcodeGeneratorFactory;
import com.docmosis.template.analysis.barcode.BarcodeInfo;
import com.docmosis.template.analysis.barcode.BarcodeInfoCode128;
import com.docmosis.template.analysis.barcode.BarcodeInfoCode39;
import com.docmosis.template.analysis.barcode.BarcodeInfoIMb;
import com.docmosis.template.analysis.barcode.BarcodeInfoItf14;
import com.docmosis.template.analysis.barcode.BarcodeInfoPdf417;
import com.docmosis.template.analysis.barcode.BarcodeInfoQR;
import com.docmosis.template.analysis.barcode.BarcodeParsedValue;
import com.docmosis.template.analysis.barcode.BarcodeType;
import com.docmosis.template.analysis.barcode.BarcodeValueParser;
import com.docmosis.util.DMProperties;
import com.docmosis.util.StringUtilities;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class BarcodeInfoFactory {
    public static final String BARCODE_SETTING_SEPARATOR = DMProperties.getString("docmosis.populator.barcode.separator.setting");
    public static final Set<String> ALL_BARCODE_SETTING_NAMES_AND_ALIASES = BarcodeInfoFactory.combine(new String[][]{BarcodeInfoCode39.BARCODE_SETTING_NAMES_FLAT, BarcodeInfoCode128.BARCODE_SETTING_NAMES_FLAT, BarcodeInfoPdf417.BARCODE_SETTING_NAMES_FLAT, BarcodeInfoItf14.BARCODE_SETTING_NAMES_FLAT, BarcodeInfoIMb.BARCODE_SETTING_NAMES_FLAT, BarcodeInfoQR.BARCODE_SETTING_NAMES_FLAT});

    private static Set<String> combine(String[][] stringArray) {
        HashSet<String> hashSet = new HashSet<String>();
        for (String[] stringArray2 : stringArray) {
            hashSet.addAll(Arrays.asList(stringArray2));
        }
        return Collections.unmodifiableSet(hashSet);
    }

    public static BarcodeInfo generate(BarcodeType barcodeType) throws BarcodeException {
        BarcodeInfo barcodeInfo = BarcodeInfoFactory.combine(barcodeType, null, null, null);
        barcodeInfo.validate(true);
        return barcodeInfo;
    }

    public static BarcodeInfo generate(String string) throws BarcodeException {
        BarcodeParsedValue barcodeParsedValue = BarcodeValueParser.parseBarcodeDetails(string);
        BarcodeInfo barcodeInfo = BarcodeInfoFactory.combine(barcodeParsedValue.type, null, barcodeParsedValue.value, barcodeParsedValue.settings);
        barcodeInfo.validate(true);
        return barcodeInfo;
    }

    public static BarcodeInfo generate(BarcodeType barcodeType, String string) throws BarcodeException {
        BarcodeParsedValue barcodeParsedValue = BarcodeValueParser.parseBarcodeDetails(string);
        BarcodeInfo barcodeInfo = BarcodeInfoFactory.combine(barcodeType, null, barcodeParsedValue.value, barcodeParsedValue.settings);
        barcodeInfo.validate(true);
        return barcodeInfo;
    }

    public static BarcodeInfo generate(BarcodeInfo barcodeInfo, String string) throws BarcodeException {
        BarcodeInfo barcodeInfo2 = null;
        if (string == null) {
            string = barcodeInfo.getBarcodeValue();
        }
        if (!StringUtilities.isEmpty(string)) {
            BarcodeParsedValue barcodeParsedValue = BarcodeValueParser.parseBarcodeDetails(string);
            BarcodeType barcodeType = BarcodeInfoFactory.getType(barcodeInfo, barcodeParsedValue.type);
            if (barcodeType == null) {
                throw new BarcodeException("No type information available for barcode", new String[]{"The template or the data must specify a known barcode type: " + BarcodeGeneratorFactory.getKnownTypes()});
            }
            barcodeInfo2 = BarcodeInfoFactory.combine(barcodeType, barcodeInfo, barcodeParsedValue.value, barcodeParsedValue.settings);
            barcodeInfo2.validate(false);
        }
        return barcodeInfo2;
    }

    public static BarcodeType getBarcodeType(String string) {
        BarcodeType barcodeType = null;
        if (string != null) {
            barcodeType = BarcodeValueParser.parseBarcodeDetails((String)string).type;
        }
        return barcodeType;
    }

    private static BarcodeInfo combine(BarcodeType barcodeType, BarcodeInfo barcodeInfo, String string, List<String[]> list) throws BarcodeException {
        BarcodeInfo barcodeInfo2;
        if (BarcodeType.CODE_39.equals(barcodeType)) {
            barcodeInfo2 = new BarcodeInfoCode39(barcodeInfo);
            barcodeInfo2.setValuesFrom(string, barcodeType, list);
        } else if (BarcodeType.CODE_128.equals(barcodeType)) {
            barcodeInfo2 = new BarcodeInfoCode128(barcodeInfo);
            barcodeInfo2.setValuesFrom(string, barcodeType, list);
        } else if (BarcodeType.PDF_417.equals(barcodeType)) {
            barcodeInfo2 = new BarcodeInfoPdf417(barcodeInfo);
            barcodeInfo2.setValuesFrom(string, barcodeType, list);
        } else if (BarcodeType.ITF_14.equals(barcodeType)) {
            barcodeInfo2 = new BarcodeInfoItf14(barcodeInfo);
            barcodeInfo2.setValuesFrom(string, barcodeType, list);
        } else if (BarcodeType.IMb.equals(barcodeType)) {
            barcodeInfo2 = new BarcodeInfoIMb(barcodeInfo);
            barcodeInfo2.setValuesFrom(string, barcodeType, list);
        } else if (BarcodeType.QR_CODE.equals(barcodeType)) {
            barcodeInfo2 = new BarcodeInfoQR(barcodeInfo);
            barcodeInfo2.setValuesFrom(string, barcodeType, list);
        } else {
            throw new BarcodeException("Unknown barcode type [" + barcodeType + "]", new String[]{"Specify a known barcode type: " + BarcodeGeneratorFactory.getKnownTypes()});
        }
        return barcodeInfo2;
    }

    private static BarcodeType getType(BarcodeInfo barcodeInfo, BarcodeType barcodeType) {
        BarcodeType barcodeType2 = null;
        if (barcodeInfo != null) {
            barcodeType2 = barcodeInfo.getType();
        }
        if (barcodeType != null) {
            barcodeType2 = barcodeType;
        }
        return barcodeType2;
    }
}

