/*
 * Decompiled with CFR 0.152.
 */
package com.docmosis.template.analysis.barcode;

import com.docmosis.template.analysis.barcode.BarcodeException;
import com.docmosis.template.analysis.barcode.BarcodeInfo;
import com.docmosis.util.DMProperties;

public class BarcodeInfoCode39
extends BarcodeInfo {
    public static final String CHECKSUM_MODE_ADD = "add";
    public static final String CHECKSUM_MODE_AUTO = "auto";
    public static final String CHECKSUM_MODE_CHECK = "check";
    public static final String CHECKSUM_MODE_IGNORE = "ignore";
    private static final String y = "docmosis.populator.barcode.code39.wideFactor.default";
    private static final double \u00a2 = DMProperties.getDouble("docmosis.populator.barcode.code39.wideFactor.default", 2.2);
    protected static final String[] BARCODE_WIDE_FACTOR_NAME = DMProperties.getStringArray("docmosis.populator.barcode.code39.wideFactor.name", BarcodeInfo.BARCODE_KEY_SEPARATOR);
    private static final String x = "docmosis.populator.barcode.code39.extendedCharsetEnabled.default";
    private static final boolean s = DMProperties.getBoolean("docmosis.populator.barcode.code39.extendedCharsetEnabled.default", true);
    protected static final String[] BARCODE_EXTENDED_CHARSET_ENABLED_NAME = DMProperties.getStringArray("docmosis.populator.barcode.code39.extendedCharsetEnabled.name", BarcodeInfo.BARCODE_KEY_SEPARATOR);
    protected static final String[] BARCODE_CHECKSUM_MODE_NAME = DMProperties.getStringArray("docmosis.populator.barcode.code39.checksumMode.name", BarcodeInfo.BARCODE_KEY_SEPARATOR);
    protected static final String[] BARCODE_DISPLAY_CHECKSUM_NAME = DMProperties.getStringArray("docmosis.populator.barcode.code39.displayChecksum.name", BarcodeInfo.BARCODE_KEY_SEPARATOR);
    protected static final String[] BARCODE_DISPLAY_START_STOP_NAME = DMProperties.getStringArray("docmosis.populator.barcode.code39.displayStartStop.name", BarcodeInfo.BARCODE_KEY_SEPARATOR);
    protected static final String[] BARCODE_INTERCHAR_GAP_WIDTH_NAME = DMProperties.getStringArray("docmosis.populator.barcode.code39.intercharGapWidth.name", BarcodeInfo.BARCODE_KEY_SEPARATOR);
    private double t = \u00a2;
    private boolean u = s;
    private String v;
    private Boolean \u00a4;
    private Boolean z;
    private Double \u00a3;
    private static final String[][] w = new String[][]{BARCODE_DPI_NAME, BARCODE_MODULE_WIDTH_NAME, BARCODE_DO_QUIET_ZONE_NAME, BARCODE_HEIGHT_NAME, BARCODE_ORIENTATION_NAME, BARCODE_FONT_SIZE_NAME, BARCODE_QUIET_ZONE_WIDTH_NAME, BARCODE_QUIET_ZONE_HEIGHT_NAME, BARCODE_WIDE_FACTOR_NAME, BARCODE_EXTENDED_CHARSET_ENABLED_NAME, BARCODE_CHECKSUM_MODE_NAME, BARCODE_DISPLAY_CHECKSUM_NAME, BARCODE_DISPLAY_START_STOP_NAME, BARCODE_INTERCHAR_GAP_WIDTH_NAME};
    protected static final String[] BARCODE_SETTING_NAMES_FLAT = BarcodeInfoCode39.flattenNames(w);

    public BarcodeInfoCode39(BarcodeInfo barcodeInfo) {
        super(barcodeInfo);
        if (barcodeInfo instanceof BarcodeInfoCode39) {
            BarcodeInfoCode39 barcodeInfoCode39 = (BarcodeInfoCode39)barcodeInfo;
            this.t = barcodeInfoCode39.t;
            this.u = barcodeInfoCode39.u;
            this.v = barcodeInfoCode39.v;
            this.\u00a4 = barcodeInfoCode39.\u00a4;
            this.z = barcodeInfoCode39.z;
            this.\u00a3 = barcodeInfoCode39.\u00a3;
        }
    }

    @Override
    protected boolean setField(String string, String string2) throws BarcodeException {
        boolean bl = false;
        if (BarcodeInfoCode39.isKey(BARCODE_WIDE_FACTOR_NAME, string)) {
            bl = true;
            try {
                this.setWideFactor(Double.parseDouble(string2));
            }
            catch (NumberFormatException numberFormatException) {
                throw new BarcodeException("invalid wide factor setting [" + string2 + "]", new String[]{"The value must be a double value and should be between 2.0 and 3.0"});
            }
        }
        if (BarcodeInfoCode39.isKey(BARCODE_EXTENDED_CHARSET_ENABLED_NAME, string)) {
            bl = true;
            try {
                this.setExtendedCharsetEnabled(Boolean.valueOf(string2));
            }
            catch (NumberFormatException numberFormatException) {
                throw new BarcodeException("invalid extended charset setting [" + string2 + "]", new String[]{"Must be true or false"});
            }
        }
        if (BarcodeInfoCode39.isKey(BARCODE_CHECKSUM_MODE_NAME, string)) {
            bl = true;
            string2 = string2.trim();
            this.validateChecksumMode(string2);
            try {
                this.setChecksumMode(string2);
            }
            catch (NumberFormatException numberFormatException) {
                throw new BarcodeException("invalid display checksum setting [" + string2 + "]", new String[]{"Must be true or false"});
            }
        }
        if (BarcodeInfoCode39.isKey(BARCODE_DISPLAY_CHECKSUM_NAME, string)) {
            bl = true;
            try {
                this.setDisplayChecksum(Boolean.valueOf(string2));
            }
            catch (NumberFormatException numberFormatException) {
                throw new BarcodeException("invalid display checksum setting [" + string2 + "]", new String[]{"Must be true or false"});
            }
        }
        if (BarcodeInfoCode39.isKey(BARCODE_DISPLAY_START_STOP_NAME, string)) {
            bl = true;
            try {
                this.setDisplayStartStop(Boolean.valueOf(string2));
            }
            catch (NumberFormatException numberFormatException) {
                throw new BarcodeException("invalid display stop start setting [" + string2 + "]", new String[]{"Must be true or false"});
            }
        }
        if (BarcodeInfoCode39.isKey(BARCODE_INTERCHAR_GAP_WIDTH_NAME, string)) {
            bl = true;
            try {
                this.setIntercharGapWidth(new Double(string2));
            }
            catch (NumberFormatException numberFormatException) {
                throw new BarcodeException("invalid interchar gap width setting [" + string2 + "]", new String[]{"The value must be a double value"});
            }
        }
        return bl;
    }

    private void validateChecksumMode(String string) throws BarcodeException {
        String string2 = "add|auto|check|ignore";
        String[] stringArray = "add|auto|check|ignore".split("\\|");
        boolean bl = false;
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string.equalsIgnoreCase(stringArray[i])) continue;
            bl = true;
            break;
        }
        if (!bl) {
            throw new BarcodeException("Invalid checksum mode [" + string + "].  Must be one of " + "add|auto|check|ignore", new String[]{"Choose one of add|auto|check|ignore"});
        }
    }

    @Override
    protected String[][] getSupportedSettingNames() {
        return w;
    }

    @Override
    protected String[] getSupportedSettingNamesFlattened() {
        return BARCODE_SETTING_NAMES_FLAT;
    }

    public double getWideFactor() {
        return this.t;
    }

    public void setWideFactor(double d) {
        this.t = d;
    }

    public boolean isExtendedCharsetEnabled() {
        return this.u;
    }

    public void setExtendedCharsetEnabled(boolean bl) {
        this.u = bl;
    }

    public Boolean getDisplayChecksum() {
        return this.\u00a4;
    }

    public void setDisplayChecksum(Boolean bl) {
        this.\u00a4 = bl;
    }

    public Boolean getDisplayStartStop() {
        return this.z;
    }

    public void setDisplayStartStop(Boolean bl) {
        this.z = bl;
    }

    public Double getIntercharGapWidth() {
        return this.\u00a3;
    }

    public void setIntercharGapWidth(Double d) {
        this.\u00a3 = d;
    }

    public String getChecksumMode() {
        return this.v;
    }

    public void setChecksumMode(String string) {
        this.v = string;
    }

    @Override
    public String toString() {
        return "BarcodeInfoCode39 [wideFactor=" + this.t + ", extendedCharsetEnabled=" + this.u + ", checksumMode=" + this.v + ", displayChecksum=" + this.\u00a4 + ", displayStartStop=" + this.z + ", intercharGapWidth=" + this.\u00a3 + "]";
    }
}

