/*
 * Decompiled with CFR 0.152.
 */
package com.docmosis.template.analysis.barcode;

import com.docmosis.template.analysis.barcode.BarcodeException;
import com.docmosis.template.analysis.barcode.BarcodeType;
import com.docmosis.util.DMProperties;
import com.docmosis.util.StringUtilities;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public abstract class BarcodeInfo
implements Serializable {
    public static final String BARCODE_KEY_SEPARATOR = DMProperties.getString("docmosis.populator.barcode.separator.settingKey");
    private static final String F = "docmosis.populator.barcode.dpi.max";
    private static final int T = DMProperties.getInt("docmosis.populator.barcode.dpi.max", 1200);
    private static final String H = "docmosis.populator.barcode.dpi.default";
    private static final int R = DMProperties.getInt("docmosis.populator.barcode.dpi.default", 600);
    protected static final String[] BARCODE_DPI_NAME = DMProperties.getStringArray("docmosis.populator.barcode.dpi.name", BARCODE_KEY_SEPARATOR);
    private static final String M = "docmosis.populator.barcode.moduleWidth.default";
    private static final double N = DMProperties.getDouble("docmosis.populator.barcode.moduleWidth.default", 0.19);
    protected static final String[] BARCODE_MODULE_WIDTH_NAME = DMProperties.getStringArray("docmosis.populator.barcode.moduleWidth.name", BARCODE_KEY_SEPARATOR);
    private static final String P = "docmosis.populator.barcode.doQuietZone.default";
    private static final boolean K = DMProperties.getBoolean("docmosis.populator.barcode.doQuietZone.default", false);
    protected static final String[] BARCODE_DO_QUIET_ZONE_NAME = DMProperties.getStringArray("docmosis.populator.barcode.doQuietZone.name", BARCODE_KEY_SEPARATOR);
    private static final String A = "docmosis.populator.barcode.height.default";
    private static final double B = DMProperties.getDouble("docmosis.populator.barcode.height.default", 10.0);
    protected static final String[] BARCODE_HEIGHT_NAME = DMProperties.getStringArray("docmosis.populator.barcode.height.name", BARCODE_KEY_SEPARATOR);
    protected static final String[] BARCODE_ORIENTATION_NAME = DMProperties.getStringArray("docmosis.populator.barcode.orientation.name", BARCODE_KEY_SEPARATOR);
    protected static final String[] BARCODE_FONT_SIZE_NAME = DMProperties.getStringArray("docmosis.populator.barcode.fontSize.name", BARCODE_KEY_SEPARATOR);
    protected static final String[] BARCODE_QUIET_ZONE_WIDTH_NAME = DMProperties.getStringArray("docmosis.populator.barcode.quietZoneWidth.name", BARCODE_KEY_SEPARATOR);
    protected static final String[] BARCODE_QUIET_ZONE_HEIGHT_NAME = DMProperties.getStringArray("docmosis.populator.barcode.quietZoneHeight.name", BARCODE_KEY_SEPARATOR);
    protected static final Set<String> REGISTERED_SETTING_NAMES = new HashSet<String>();
    private int J = R;
    private double E = N;
    private boolean L = K;
    private double O = B;
    private int G = 0;
    private Integer D;
    private Double S;
    private Double Q;
    private String C;
    private BarcodeType I;

    protected BarcodeInfo(BarcodeType barcodeType, String string) {
        this.I = barcodeType;
        this.C = string;
    }

    protected BarcodeInfo(BarcodeInfo barcodeInfo) {
        if (barcodeInfo == null) {
            return;
        }
        this.J = barcodeInfo.J;
        this.E = barcodeInfo.E;
        this.L = barcodeInfo.L;
        this.O = barcodeInfo.O;
        this.G = barcodeInfo.G;
        this.D = barcodeInfo.D;
        this.S = barcodeInfo.S;
        this.Q = barcodeInfo.Q;
        this.C = barcodeInfo.C;
        this.I = barcodeInfo.I;
    }

    public int getDpi() {
        return this.J;
    }

    public void setDpi(int n) {
        this.J = n;
    }

    public String getBarcodeValue() {
        return this.C;
    }

    public void setBarcodeValue(String string) {
        this.C = string;
    }

    public BarcodeType getType() {
        return this.I;
    }

    public void setType(BarcodeType barcodeType) {
        this.I = barcodeType;
    }

    public double getModuleWidth() {
        return this.E;
    }

    public void setModuleWidth(double d) {
        this.E = d;
    }

    public boolean isDoQuietZone() {
        return this.L;
    }

    public void setDoQuietZone(boolean bl) {
        this.L = bl;
    }

    public double getHeight() {
        return this.O;
    }

    public void setHeight(double d) {
        this.O = d;
    }

    public int getOrientation() {
        return this.G;
    }

    public void setOrientation(int n) {
        this.G = n;
    }

    public Integer getFontSize() {
        return this.D;
    }

    public void setFontSize(Integer n) {
        this.D = n;
    }

    public Double getQuietZoneWidth() {
        return this.S;
    }

    public void setQuietZoneWidth(Double d) {
        this.S = d;
    }

    public Double getQuietZoneHeight() {
        return this.Q;
    }

    public void setQuietZoneHeight(Double d) {
        this.Q = d;
    }

    public static boolean isBarcode(BarcodeInfo barcodeInfo) {
        return barcodeInfo != null && barcodeInfo.getType() != null;
    }

    public static boolean isQRCode(BarcodeInfo barcodeInfo) {
        return BarcodeInfo.isBarcode(barcodeInfo) && barcodeInfo.getType().isQRCode();
    }

    public final void setValuesFrom(String string, BarcodeType barcodeType, List<String[]> list) throws BarcodeException {
        this.setBarcodeValue(string);
        this.setType(barcodeType);
        if (list != null) {
            for (String[] stringArray : list) {
                String string2;
                if (stringArray.length != 2 || StringUtilities.isEmpty(stringArray[0]) || StringUtilities.isEmpty(stringArray[1])) {
                    string2 = "";
                    for (int i = 0; i < stringArray.length; ++i) {
                        if (string2.length() > 0) {
                            string2 = string2 + "=";
                        }
                        string2 = string2 + stringArray[i];
                    }
                    throw new BarcodeException("Setting \"" + string2 + "\" is not well formed.", new String[]{"Make sure your settings are key=value"});
                }
                string2 = stringArray[0];
                String string3 = stringArray[1];
                this.setFieldInternal(string2, string3);
            }
        }
    }

    private void setFieldInternal(String string, String string2) throws BarcodeException {
        boolean bl = false;
        if (BarcodeInfo.isKey(BARCODE_DPI_NAME, string)) {
            bl = true;
            try {
                this.setDpi(Integer.parseInt(string2));
            }
            catch (NumberFormatException numberFormatException) {
                throw new BarcodeException("invalid DPI setting for barcode [" + string2 + "]", new String[]{"Correct the DPI setting"});
            }
        }
        if (BarcodeInfo.isKey(BARCODE_ORIENTATION_NAME, string)) {
            bl = true;
            try {
                this.setOrientation(Integer.parseInt(string2));
            }
            catch (NumberFormatException numberFormatException) {
                throw new BarcodeException("invalid Orientation setting for barcode [" + string2 + "]", new String[]{"Values allowed are 0, 90, -90, 180, -180, 270, -270"});
            }
        }
        if (BarcodeInfo.isKey(BARCODE_HEIGHT_NAME, string)) {
            bl = true;
            try {
                this.setHeight(Double.parseDouble(string2));
            }
            catch (NumberFormatException numberFormatException) {
                throw new BarcodeException("invalid height setting for barcode [" + string2 + "]", new String[]{"Height is specified as a number of mm eg 10.0"});
            }
        }
        if (BarcodeInfo.isKey(BARCODE_MODULE_WIDTH_NAME, string)) {
            bl = true;
            try {
                this.setModuleWidth(Double.parseDouble(string2));
            }
            catch (NumberFormatException numberFormatException) {
                throw new BarcodeException("invalid height setting for barcode [" + string2 + "]", new String[]{"Height is specified as a number of mm eg 10.0"});
            }
        }
        if (BarcodeInfo.isKey(BARCODE_DO_QUIET_ZONE_NAME, string)) {
            bl = true;
            try {
                this.setDoQuietZone(Boolean.valueOf(string2));
            }
            catch (NumberFormatException numberFormatException) {
                throw new BarcodeException("invalid do quiet zone setting for barcode [" + string2 + "]", new String[]{"must be true or false"});
            }
        }
        if (BarcodeInfo.isKey(BARCODE_QUIET_ZONE_WIDTH_NAME, string)) {
            bl = true;
            try {
                this.setQuietZoneWidth(Double.valueOf(string2));
            }
            catch (NumberFormatException numberFormatException) {
                throw new BarcodeException("invalid quiet zone width setting for barcode [" + string2 + "]", new String[]{"Height is specified as a number of mm eg 10.0"});
            }
        }
        if (BarcodeInfo.isKey(BARCODE_QUIET_ZONE_HEIGHT_NAME, string)) {
            bl = true;
            try {
                this.setQuietZoneHeight(Double.valueOf(string2));
            }
            catch (NumberFormatException numberFormatException) {
                throw new BarcodeException("invalid quiet zone height setting for barcode [" + string2 + "]", new String[]{"Height is specified as a number of mm eg 10.0"});
            }
        }
        if (BarcodeInfo.isKey(BARCODE_FONT_SIZE_NAME, string)) {
            bl = true;
            try {
                this.setFontSize(new Integer(string2));
            }
            catch (NumberFormatException numberFormatException) {
                throw new BarcodeException("invalid height setting for barcode [" + string2 + "]", new String[]{"Height is specified as a number of mm eg 10.0"});
            }
        }
        if (!(bl |= this.setField(string, string2))) {
            throw new BarcodeException("Unknown Setting [" + string + "] for barcode type " + this.getType(), new String[]{"Valid settings for " + this.getType() + " barcodes are:" + this.getSupportedSettings()});
        }
    }

    public String getSupportedSettings() {
        StringBuffer stringBuffer = new StringBuffer();
        ArrayList arrayList = new ArrayList(Arrays.asList(this.getSupportedSettingNames()));
        if (this.getSupportedSettingNames() != null) {
            arrayList.addAll(Arrays.asList(this.getSupportedSettingNames()));
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            if (i > 0) {
                stringBuffer.append(", ");
            }
            String[] stringArray = (String[])arrayList.get(i);
            for (int j = 0; j < stringArray.length; ++j) {
                if (j > 0) {
                    stringBuffer.append("/");
                }
                stringBuffer.append(stringArray[j]);
            }
        }
        return stringBuffer.toString();
    }

    protected abstract boolean setField(String var1, String var2) throws BarcodeException;

    protected abstract String[] getSupportedSettingNamesFlattened();

    protected abstract String[][] getSupportedSettingNames();

    protected static String[] flattenNames(String[][] stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String[][] stringArray2 = stringArray;
        int n = stringArray2.length;
        for (int i = 0; i < n; ++i) {
            String[] stringArray3;
            for (String string : stringArray3 = stringArray2[i]) {
                arrayList.add(string);
            }
        }
        stringArray2 = new String[arrayList.size()];
        arrayList.toArray((T[])stringArray2);
        return stringArray2;
    }

    protected static boolean isKey(String[] stringArray, String string) {
        boolean bl = false;
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].trim().equalsIgnoreCase(string.trim())) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public void validate(boolean bl) throws BarcodeException {
        if (this.getType() == null) {
            throw new BarcodeException("The type of barcode has not been defined", new String[]{"Make sure the type is set in the template or data"});
        }
        if (!bl && this.getBarcodeValue() == null) {
            throw new BarcodeException("The barcode must have a value to render", new String[]{"Make sure the data specifies a barcode value"});
        }
        if (this.J > T) {
            throw new BarcodeException("Barcode DPI setting [" + this.J + "] is higher than allowed maximum [" + T + "]", new String[]{"Correct the DPI setting"});
        }
    }

    public String toString() {
        return "BarcodeInfo [dpi=" + this.J + ", moduleWidth=" + this.E + ", doQuietZone=" + this.L + ", height=" + this.O + ", orientation=" + this.G + ", fontSize=" + this.D + ", quietZoneWidth=" + this.S + ", quietZoneHeight=" + this.Q + ", barcodeValue=" + this.C + ", type=" + this.I + "]";
    }
}

