/*
 * Decompiled with CFR 0.152.
 */
package com.docmosis.template.analysis.barcode;

import com.docmosis.template.analysis.barcode.BarcodeException;
import com.docmosis.template.analysis.barcode.BarcodeGenerator;
import com.docmosis.template.analysis.barcode.BarcodeInfo;
import com.docmosis.template.analysis.barcode.BarcodeType;
import com.docmosis.util.DMProperties;
import com.docmosis.util.logging.LogManager;
import com.docmosis.util.logging.Logger;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class BarcodeGeneratorFactory {
    private static final Logger C = LogManager.getLogger(BarcodeGeneratorFactory.class);
    private static final String F = DMProperties.getString("docmosis.analyzer.field.barcode.barcode4j.detectClass", "org.krysalis.barcode4j.impl.AbstractBarcodeBean");
    private static final String A = DMProperties.getString("docmosis.analyzer.field.barcode.zxing.detectClass", "com.google.zxing.WriterException");
    private static final Map E = new HashMap();
    private static final boolean D;
    private static final boolean B;

    public static BarcodeGenerator getGenerator(BarcodeType barcodeType) throws BarcodeException {
        if (!D) {
            throw new BarcodeException("Barcode4j has not been detected.  Barcode generation disabled.");
        }
        if (barcodeType.isQRCode() && !B) {
            throw new BarcodeException("ZXing has not been detected.  QR code generation disabled.");
        }
        _A _A2 = (_A)E.get(barcodeType);
        if (_A2 == null) {
            throw new BarcodeException("Cannot find Barcode generator for type [" + barcodeType + "]", new String[]{"Choose known type:" + BarcodeGeneratorFactory.getKnownTypes()});
        }
        return _A2.A();
    }

    public static BarcodeGenerator getGenerator(BarcodeInfo barcodeInfo) throws BarcodeException {
        return BarcodeGeneratorFactory.getGenerator(barcodeInfo.getType());
    }

    public static String getKnownTypes() {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = E.keySet().iterator();
        while (iterator.hasNext()) {
            String string = ((BarcodeType)iterator.next()).getName();
            if (stringBuffer.length() > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        boolean bl = false;
        try {
            Class.forName(F);
            bl = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (LinkageError linkageError) {
            C.error("Unable to link the Barcode4j library", linkageError);
        }
        finally {
            D = bl;
        }
        boolean bl2 = false;
        try {
            Class.forName(A);
            bl2 = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (LinkageError linkageError) {
            C.error("Unable to link the zxing library", linkageError);
        }
        finally {
            B = bl2;
        }
        if (C.isInfoEnabled()) {
            C.info("barcode4j      enabled:" + D);
            C.info("qrcode (zxing) enabled:" + B);
        }
        if (D) {
            E.put(BarcodeType.CODE_39, new _A("com.docmosis.template.analysis.barcode.impl.BarcodeGeneratorCode39"));
            E.put(BarcodeType.CODE_128, new _A("com.docmosis.template.analysis.barcode.impl.BarcodeGeneratorCode128"));
            E.put(BarcodeType.PDF_417, new _A("com.docmosis.template.analysis.barcode.impl.BarcodeGeneratorPdf417"));
            E.put(BarcodeType.ITF_14, new _A("com.docmosis.template.analysis.barcode.impl.BarcodeGeneratorItf14"));
            E.put(BarcodeType.IMb, new _A("com.docmosis.template.analysis.barcode.impl.BarcodeGeneratorIMb"));
        }
        if (B) {
            E.put(BarcodeType.QR_CODE, new _A("com.docmosis.template.analysis.barcode.impl.BarcodeGeneratorQR"));
        }
    }

    private static class _A {
        private BarcodeGenerator A;
        private final String B;

        public _A(String string) {
            this.B = string;
        }

        private synchronized BarcodeGenerator A() throws BarcodeException {
            if (this.A == null) {
                try {
                    this.A = (BarcodeGenerator)Class.forName(this.B).newInstance();
                }
                catch (InstantiationException instantiationException) {
                    String string = "Unable to instantiate barcode class:" + this.B;
                    C.error(string, instantiationException);
                    throw new BarcodeException(string, instantiationException, null);
                }
                catch (IllegalAccessException illegalAccessException) {
                    String string = "Unable to instantiate barcode class:" + this.B;
                    C.error(string, illegalAccessException);
                    throw new BarcodeException(string, illegalAccessException, null);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    String string = "Unable to instantiate barcode class:" + this.B;
                    C.error(string, classNotFoundException);
                    throw new BarcodeException(string, classNotFoundException, null);
                }
            }
            return this.A;
        }
    }
}

